/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability;

import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityTestPhase;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.HarvestabilityIdentifiers;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;

public enum LiquidHarvestHandler implements HarvestHandler
{
    INSTANCE;

    public static final EffectiveTool BUCKET;

    @Override
    public boolean testHarvest(HarvestabilityInfo info, HarvestabilityTestPhase phase, EntityPlayer player, Block block, int meta, MovingObjectPosition position) {
        if (phase == HarvestabilityTestPhase.EFFECTIVE_TOOL_NAME) {
            if (this.isStaticWaterOrLava(block)) {
                info.setEffectiveTool(BUCKET);
            } else if (block instanceof BlockLiquid) {
                info.setEffectiveTool(EffectiveTool.CANNOT_HARVEST);
            }
        } else if (phase == HarvestabilityTestPhase.CURRENTLY_HARVESTABLE) {
            if (this.isStaticWaterOrLava(block)) {
                info.setCurrentlyHarvestable(player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151133_ar);
            } else if (block instanceof BlockLiquid) {
                info.setCurrentlyHarvestable(false);
            }
        } else if (phase == HarvestabilityTestPhase.IS_HELD_TOOL_EFFECTIVE) {
            if (this.isStaticWaterOrLava(block)) {
                info.setHeldToolEffective(player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == Items.field_151133_ar);
            } else if (block instanceof BlockLiquid) {
                info.setHeldToolEffective(false);
            }
        }
        return true;
    }

    private boolean isStaticWaterOrLava(Block block) {
        if (block instanceof BlockStaticLiquid) {
            BlockStaticLiquid staticLiquid = (BlockStaticLiquid)block;
            return staticLiquid.func_149688_o() == Material.field_151586_h || staticLiquid.func_149688_o() == Material.field_151587_i;
        }
        return false;
    }

    @Override
    public ResourceLocation getUid() {
        return HarvestabilityIdentifiers.LIQUID;
    }

    @Override
    public int getDefaultPriority() {
        return 4901;
    }

    static {
        BUCKET = new EffectiveTool("bucket", Arrays.asList(new ItemStack(Items.field_151133_ar)));
    }
}

