/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.harvestability;

import com.gtnewhorizons.wdmla.api.harvestability.EffectiveTool;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestLevel;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityInfo;
import com.gtnewhorizons.wdmla.api.harvestability.HarvestabilityTestPhase;
import com.gtnewhorizons.wdmla.api.provider.HarvestHandler;
import com.gtnewhorizons.wdmla.plugin.harvestability.HarvestabilityIdentifiers;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.NotNull;

public enum BaseHarvestLogicHandler implements HarvestHandler
{
    INSTANCE;


    @Override
    public boolean testHarvest(HarvestabilityInfo info, HarvestabilityTestPhase phase, EntityPlayer player, Block block, int meta, MovingObjectPosition position) {
        ItemStack tool;
        if (phase == HarvestabilityTestPhase.EFFECTIVE_TOOL_NAME) {
            if (!player.func_82246_f(position.field_72311_b, position.field_72312_c, position.field_72309_d) || this.isBlockUnbreakable(block, player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d)) {
                info.setEffectiveTool(EffectiveTool.CANNOT_HARVEST);
            } else {
                info.setEffectiveTool(new EffectiveTool(block.getHarvestTool(meta), null));
            }
        } else if (phase == HarvestabilityTestPhase.HARVEST_LEVEL) {
            info.setHarvestLevel(info.getEffectiveTool().getHarvestLevel(block, meta));
        } else if (phase == HarvestabilityTestPhase.CURRENTLY_HARVESTABLE) {
            if (info.getEffectiveTool().isSameTool(EffectiveTool.CANNOT_HARVEST)) {
                info.setCurrentlyHarvestable(false);
                info.setHarvestLevel(HarvestLevel.NO_TOOL);
                return false;
            }
            if (this.canInstaBreak(info.getHarvestLevel(), info.getEffectiveTool().isValid(), block, !info.getAdditionalToolsInfo().isEmpty())) {
                info.setEffectiveTool(EffectiveTool.NO_TOOL);
                info.setCurrentlyHarvestable(true);
                info.setHarvestLevel(HarvestLevel.NO_TOOL);
                info.setHeldToolEffective(true);
                return false;
            }
            if (player.func_70694_bm() == null) {
                info.setCurrentlyHarvestable(ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta));
            } else {
                info.setCurrentlyHarvestable(this.isCurrentlyHarvestable(player, block, meta, player.func_70694_bm()));
            }
        } else if (phase == HarvestabilityTestPhase.IS_HELD_TOOL_EFFECTIVE && (tool = player.func_70694_bm()) != null) {
            boolean isEffective = BaseHarvestLogicHandler.isToolEffectiveAgainst(tool, block, meta, info.getEffectiveTool());
            info.setHeldToolEffective(isEffective && info.isCurrentlyHarvestable());
        }
        return true;
    }

    @Override
    public ResourceLocation getUid() {
        return HarvestabilityIdentifiers.BASE_LOGIC;
    }

    @Override
    public int getDefaultPriority() {
        return -10000;
    }

    public boolean isBlockUnbreakable(Block block, World world, int x, int y, int z) {
        return block.func_149712_f(world, x, y, z) == -1.0f;
    }

    public boolean canInstaBreak(HarvestLevel harvestLevel, boolean hasEffectiveTool, Block block, boolean hasAdditionalInfo) {
        boolean blockHasEffectiveTools = harvestLevel.isToolRequired() && hasEffectiveTool;
        return block.func_149688_o().func_76229_l() && !blockHasEffectiveTools && !hasAdditionalInfo;
    }

    public boolean isCurrentlyHarvestable(EntityPlayer player, Block block, int meta, @NotNull ItemStack itemHeld) {
        boolean isHeldToolCorrect = BaseHarvestLogicHandler.canToolHarvestBlock(itemHeld, block) || block.canHarvestBlock(player, meta);
        boolean isAboveMinHarvestLevel = ForgeHooks.canToolHarvestBlock((Block)block, (int)meta, (ItemStack)itemHeld);
        return isHeldToolCorrect && isAboveMinHarvestLevel || ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (int)meta);
    }

    public static boolean canToolHarvestBlock(ItemStack tool, Block block) {
        return block.func_149688_o().func_76229_l() || tool.func_150998_b(block);
    }

    public static boolean isToolEffectiveAgainst(ItemStack tool, Block block, int metadata, EffectiveTool effectiveTool) {
        return ForgeHooks.isToolEffective((ItemStack)tool, (Block)block, (int)metadata) || (BaseHarvestLogicHandler.toolHasAnyToolClass(tool) ? effectiveTool.isToolInstance(tool) : tool.func_77973_b().getDigSpeed(tool, block, metadata) > 1.5f);
    }

    public static boolean toolHasAnyToolClass(ItemStack tool) {
        return !tool.func_77973_b().getToolClasses(tool).isEmpty();
    }
}

