/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.debug;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IToggleableProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;

public class CoordinatesProvider
implements IToggleableProvider {
    public static ForBlock getBlock() {
        return ForBlock.INSTANCE;
    }

    public static ForEntity getEntity() {
        return ForEntity.INSTANCE;
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.COORDINATES;
    }

    @Override
    public int getDefaultPriority() {
        return 5001;
    }

    @Override
    public boolean enabledByDefault() {
        return false;
    }

    public static class ForBlock
    extends CoordinatesProvider
    implements IBlockComponentProvider {
        private static final ForBlock INSTANCE = new ForBlock();

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
            if (!accessor.showDetails()) {
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.seeing.block"), StatCollector.func_74837_a((String)"hud.msg.wdmla.coordinates", (Object[])new Object[]{SpecialChars.RED + FormatUtil.STANDARD_NO_GROUP.format(accessor.getHitResult().field_72311_b) + SpecialChars.RESET, SpecialChars.GREEN + FormatUtil.STANDARD_NO_GROUP.format(accessor.getHitResult().field_72312_c) + SpecialChars.RESET, SpecialChars.BLUE + FormatUtil.STANDARD_NO_GROUP.format(accessor.getHitResult().field_72309_d) + SpecialChars.RESET})));
            } else {
                Vec3 hitVec = accessor.getHitResult().field_72307_f;
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.seeing"), StatCollector.func_74837_a((String)"hud.msg.wdmla.coordinates", (Object[])new Object[]{SpecialChars.RED + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72450_a) + SpecialChars.RESET, SpecialChars.GREEN + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72448_b) + SpecialChars.RESET, SpecialChars.BLUE + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72449_c) + SpecialChars.RESET})));
            }
        }
    }

    public static class ForEntity
    extends CoordinatesProvider
    implements IEntityComponentProvider {
        private static final ForEntity INSTANCE = new ForEntity();

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
            if (!accessor.showDetails()) {
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.seeing.entity"), String.format("%s:%s:%s", SpecialChars.RED + FormatUtil.STANDARD_NO_GROUP.format(accessor.getEntity().field_70165_t) + SpecialChars.RESET, SpecialChars.GREEN + FormatUtil.STANDARD_NO_GROUP.format(accessor.getEntity().field_70163_u) + SpecialChars.RESET, SpecialChars.BLUE + FormatUtil.STANDARD_NO_GROUP.format(accessor.getEntity().field_70161_v) + SpecialChars.RESET)));
            } else {
                Vec3 hitVec = accessor.getHitResult().field_72307_f;
                tooltip.child(ThemeHelper.INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.seeing"), String.format("%s:%s:%s", SpecialChars.RED + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72450_a) + SpecialChars.RESET, SpecialChars.GREEN + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72448_b) + SpecialChars.RESET, SpecialChars.BLUE + FormatUtil.STANDARD_NO_GROUP.format(hitVec.field_72449_c) + SpecialChars.RESET)));
            }
        }
    }
}

