/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.core;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.IconComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.overlay.PotionIcon;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringUtils;

public enum StatusEffectProvider implements IEntityComponentProvider,
IServerDataProvider<EntityAccessor>
{
    INSTANCE;


    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        if (!accessor.getServerData().func_74764_b("ActiveEffects")) {
            return;
        }
        NBTTagList activeEffects = accessor.getServerData().func_150295_c("ActiveEffects", 10);
        for (int i = 0; i < activeEffects.func_74745_c(); ++i) {
            PotionEffect effect = PotionEffect.func_82722_b((NBTTagCompound)activeEffects.func_150305_b(i));
            if (effect == null) continue;
            String amplifier = effect.func_76458_c() >= 0 && effect.func_76458_c() <= 9 ? StatCollector.func_74838_a((String)("enchantment.level." + (effect.func_76458_c() + 1))) : FormatUtil.STANDARD.format(effect.func_76458_c() + 1);
            String effectName = StatCollector.func_74838_a((String)effect.func_76453_d()) + " " + amplifier;
            String duration = effect.func_100011_g() ? StatCollector.func_74838_a((String)"hud.msg.wdmla.infinity.icon") : StringUtils.func_76337_a((int)effect.func_76459_b());
            String builtLine = String.format(StatCollector.func_74838_a((String)"hud.msg.wdmla.effect.format"), effectName, duration);
            IComponent lineComponent = Potion.field_76425_a[effect.func_76456_a()].func_76398_f() ? ThemeHelper.INSTANCE.danger(builtLine) : ThemeHelper.INSTANCE.success(builtLine);
            tooltip.horizontal().child(new IconComponent(new PotionIcon(effect), PotionIcon.PATH).size(new Size(lineComponent.getHeight(), lineComponent.getHeight()))).child(lineComponent).tag(Identifiers.STATUS_EFFECT);
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, EntityAccessor accessor) {
        NBTTagCompound fullNBT = new NBTTagCompound();
        accessor.getEntity().func_70109_d(fullNBT);
        if (fullNBT.func_74764_b("ActiveEffects")) {
            data.func_74782_a("ActiveEffects", (NBTBase)fullNBT.func_150295_c("ActiveEffects", 10));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.STATUS_EFFECT;
    }
}

