/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin.core;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IEntityComponentProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.impl.ui.ThemeHelper;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.HealthComponent;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public enum EntityHealthProvider implements IEntityComponentProvider
{
    INSTANCE;


    @Override
    public int getDefaultPriority() {
        return -5001;
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.ENTITY_HEALTH;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor) {
        Entity entity = accessor.getEntity();
        if (!(entity instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase livingEntity = (EntityLivingBase)entity;
        float health = livingEntity.func_110143_aJ() / 2.0f;
        float maxhp = livingEntity.func_110138_aP() / 2.0f;
        int maxHPForText = ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_MAXHP, 40);
        if (livingEntity.func_110138_aP() > (float)maxHPForText) {
            tooltip.child(new HPanelComponent().child(new HealthComponent(1.0f, 1.0f)).text("HP: ").child(ThemeHelper.INSTANCE.info(FormatUtil.STANDARD.format(livingEntity.func_110143_aJ()))).text(" / ").child(ThemeHelper.INSTANCE.info(FormatUtil.STANDARD.format(livingEntity.func_110138_aP()))).tag(Identifiers.ENTITY_HEALTH));
        } else {
            tooltip.child(new HealthComponent(health, maxhp).tag(Identifiers.ENTITY_HEALTH));
        }
    }
}

