/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.plugin;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.gtnewhorizons.wdmla.api.IWDMlaPlugin;
import com.gtnewhorizons.wdmla.api.WDMlaPlugin;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.discovery.ASMDataTable;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.utils.WailaExceptionHandler;

public enum PluginScanner {
    INSTANCE;

    public final List<IWDMlaPlugin> results = Lists.newArrayList();
    public final List<String> blackListedRegistrationMethods = Lists.newArrayList();

    public void scan(FMLPreInitializationEvent event) {
        Set datas = event.getAsmData().getAll(WDMlaPlugin.class.getName());
        for (ASMDataTable.ASMData data : datas) {
            List deps;
            Map annotationInfo = data.getAnnotationInfo();
            String uid = (String)annotationInfo.get("uid");
            if (Strings.isNullOrEmpty((String)uid)) {
                uid = null;
            }
            if (!this.allModsLoaded(deps = (List)annotationInfo.get("dependencies"))) {
                Waila.log.info(String.format("skipped plugin %s loading: missing dependency", uid));
                continue;
            }
            String overridingMethod = (String)annotationInfo.get("overridingRegistrationMethodName");
            if (!Strings.isNullOrEmpty((String)overridingMethod)) {
                this.blackListedRegistrationMethods.add(overridingMethod);
            }
            try {
                Class<?> clazz = Class.forName(data.getClassName());
                if (IWDMlaPlugin.class.isAssignableFrom(clazz)) {
                    try {
                        IWDMlaPlugin inst = (IWDMlaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        this.results.add(inst);
                    }
                    catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                        WailaExceptionHandler.handleErr(e, clazz.getName(), null);
                    }
                    continue;
                }
                Waila.log.info("skipped plugin %s loading: class is not IWDMlaPlugin", new Object[]{uid});
            }
            catch (ClassNotFoundException e) {
                WailaExceptionHandler.handleErr(e, ((Object)((Object)this)).getClass().getName(), null);
            }
        }
    }

    private boolean allModsLoaded(Iterable<String> mods) {
        if (mods == null) {
            return true;
        }
        for (String s : mods) {
            if (Loader.isModLoaded((String)s)) continue;
            return false;
        }
        return true;
    }
}

