/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.overlay;

import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.WailaExceptionHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public final class GuiDraw {
    private static final int VANILLA_ITEM_SCALE = 16;
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
    private static final TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
    private static final RenderItem renderItem = new RenderItem();

    private GuiDraw() {
        throw new AssertionError();
    }

    public static void drawString(String text, float x, float y, int colour, boolean shadow, float scale) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        if (scale != 1.0f) {
            GL11.glEnable((int)32826);
            GL11.glScalef((float)scale, (float)scale, (float)1.0f);
        }
        if (shadow) {
            fontRenderer.func_78261_a(text, 0, 0, colour);
        } else {
            fontRenderer.func_78276_b(text, 0, 0, colour);
        }
        if (scale != 1.0f) {
            GL11.glDisable((int)32826);
        }
        GL11.glPopMatrix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void renderStack(IArea area, ItemStack stack, boolean drawOverlay, @Nullable String stackSizeOverride) {
        if (stack.func_77973_b() == null) {
            GuiDraw.drawString("Err", area.getX(), area.getY(), -3123, true, 1.0f);
            return;
        }
        float x = area.getX();
        float y = area.getY();
        float w = area.getW();
        float h = area.getH();
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)32826);
        float xScale = w / 16.0f;
        float yScale = h / 16.0f;
        try {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)x, (float)y, (float)0.0f);
            GL11.glScalef((float)xScale, (float)yScale, (float)1.0f);
            RenderHelper.func_74520_c();
            renderItem.func_82406_b(fontRenderer, textureManager, stack, 0, 0);
            if (drawOverlay) {
                if (stack.field_77994_a > 0) {
                    renderItem.func_94148_a(fontRenderer, textureManager, stack, 0, 0, stackSizeOverride);
                } else if (General.ghostProduct) {
                    if (stackSizeOverride == null) {
                        stackSizeOverride = String.valueOf(stack.field_77994_a);
                    }
                    renderItem.func_94148_a(fontRenderer, textureManager, stack, 0, 0, SpecialChars.YELLOW + stackSizeOverride);
                }
            }
            RenderHelper.func_74518_a();
        }
        catch (Exception e) {
            String stackStr = stack.toString();
            WailaExceptionHandler.handleErr(e, "renderStack | " + stackStr, null);
        }
        finally {
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)32826);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
    }

    public static void drawVerticalLine(float x1, float y1, float h, int color) {
        GuiDraw.drawRect(new Area(x1, y1, 1.0f, h), color);
    }

    public static void drawHorizontalLine(float x1, float y1, float w, int color) {
        GuiDraw.drawRect(new Area(x1, y1, w, 1.0f), color);
    }

    public static void drawRect(IArea area, int color) {
        GuiDraw.drawGradientRect(area, color, color);
    }

    public static void drawGradientRect(IArea area, int grad1, int grad2) {
        float x = area.getX();
        float y = area.getY();
        float w = area.getW();
        float h = area.getH();
        float zLevel = 0.0f;
        float f = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(grad1 & 0xFF) / 255.0f;
        float f4 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)(x + w), (double)y, (double)zLevel);
        tessellator.func_78377_a((double)x, (double)y, (double)zLevel);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x, (double)(y + h), (double)zLevel);
        tessellator.func_78377_a((double)(x + w), (double)(y + h), (double)zLevel);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawStraightGradientRect(IArea area, int grad1, int grad2, boolean horizontal) {
        float x = area.getX();
        float y = area.getY();
        float w = area.getW();
        float h = area.getH();
        float zLevel = 0.0f;
        float a1 = (float)(grad1 >> 24 & 0xFF) / 255.0f;
        float r1 = (float)(grad1 >> 16 & 0xFF) / 255.0f;
        float g1 = (float)(grad1 >> 8 & 0xFF) / 255.0f;
        float b1 = (float)(grad1 & 0xFF) / 255.0f;
        float a2 = (float)(grad2 >> 24 & 0xFF) / 255.0f;
        float r2 = (float)(grad2 >> 16 & 0xFF) / 255.0f;
        float g2 = (float)(grad2 >> 8 & 0xFF) / 255.0f;
        float b2 = (float)(grad2 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        if (horizontal) {
            tessellator.func_78369_a(r1, g1, b1, a1);
            tessellator.func_78377_a((double)x, (double)y, (double)zLevel);
            tessellator.func_78377_a((double)x, (double)(y + h), (double)zLevel);
            tessellator.func_78369_a(r2, g2, b2, a2);
            tessellator.func_78377_a((double)(x + w), (double)(y + h), (double)zLevel);
            tessellator.func_78377_a((double)(x + w), (double)y, (double)zLevel);
        } else {
            tessellator.func_78369_a(r1, g1, b1, a1);
            tessellator.func_78377_a((double)(x + w), (double)y, (double)zLevel);
            tessellator.func_78377_a((double)x, (double)y, (double)zLevel);
            tessellator.func_78369_a(r2, g2, b2, a2);
            tessellator.func_78377_a((double)x, (double)(y + h), (double)zLevel);
            tessellator.func_78377_a((double)(x + w), (double)(y + h), (double)zLevel);
        }
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public static void drawBoxBorder(IArea area, float thickness, int topLeftColor, int botRightColor) {
        float x1 = area.getX();
        float y1 = area.getY();
        float w = area.getW();
        float h = area.getH();
        GuiDraw.drawRect(new Area(x1, y1, w - 1.0f, thickness), topLeftColor);
        GuiDraw.drawRect(new Area(x1, y1, thickness, h - 1.0f), topLeftColor);
        GuiDraw.drawRect(new Area(x1 + w - thickness, y1, thickness, h), botRightColor);
        GuiDraw.drawRect(new Area(x1, y1 + h - thickness, w, thickness), botRightColor);
    }

    public static void drawTexturedModelRect(float x, float y, float u, float v, float w, float h, float tw, float th) {
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        float zLevel = 0.0f;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
        tessellator.func_78374_a((double)x, (double)(y + h), (double)zLevel, (double)u, (double)(v + th));
        tessellator.func_78374_a((double)(x + w), (double)(y + h), (double)zLevel, (double)(u + tw), (double)(v + th));
        tessellator.func_78374_a((double)(x + w), (double)y, (double)zLevel, (double)(u + tw), (double)v);
        tessellator.func_78374_a((double)x, (double)y, (double)zLevel, (double)u, (double)v);
        tessellator.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
    }

    public static void renderFluidStack(FluidStack content, float x0, float y0, float width, float height, float z) {
        if (content == null) {
            return;
        }
        Fluid fluid = content.getFluid();
        IIcon fluidStill = fluid.getIcon(content);
        int fluidColor = fluid.getColor(content);
        float r = (float)(fluidColor >> 16 & 0xFF) / 255.0f;
        float g = (float)(fluidColor >> 8 & 0xFF) / 255.0f;
        float b = (float)(fluidColor & 0xFF) / 255.0f;
        float a = (float)(fluidColor >> 24 & 0xFF) / 255.0f;
        a = a == 0.0f ? 1.0f : a;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        GuiDraw.drawTiledTexture(x0, y0, width, height, fluidStill.func_94209_e(), fluidStill.func_94206_g(), fluidStill.func_94212_f(), fluidStill.func_94210_h(), fluidStill.func_94211_a(), fluidStill.func_94216_b(), z);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawTiledTexture(float x, float y, float w, float h, float u0, float v0, float u1, float v1, int tileWidth, int tileHeight, float z) {
        int countX = ((int)w - 1) / tileWidth + 1;
        int countY = ((int)h - 1) / tileHeight + 1;
        float fillerX = w - (float)((countX - 1) * tileWidth);
        float fillerY = h - (float)((countY - 1) * tileHeight);
        float fillerU = u0 + (u1 - u0) * fillerX / (float)tileWidth;
        float fillerV = v0 + (v1 - v0) * fillerY / (float)tileHeight;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        int c = countX * countY;
        for (int i = 0; i < c; ++i) {
            int ix = i % countX;
            int iy = i / countX;
            float xx = x + (float)(ix * tileWidth);
            float yy = y + (float)(iy * tileHeight);
            float xw = tileWidth;
            float yh = tileHeight;
            float uEnd = u1;
            float vEnd = v1;
            if (ix == countX - 1) {
                xw = fillerX;
                uEnd = fillerU;
            }
            if (iy == countY - 1) {
                yh = fillerY;
                vEnd = fillerV;
            }
            GuiDraw.drawTexture(xx, yy, xx + xw, yy + yh, u0, v0, uEnd, vEnd, z);
        }
        tessellator.func_78381_a();
    }

    public static void drawTexture(float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1, float z) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78374_a((double)x0, (double)y1, (double)z, (double)u0, (double)v1);
        tessellator.func_78374_a((double)x1, (double)y1, (double)z, (double)u1, (double)v1);
        tessellator.func_78374_a((double)x1, (double)y0, (double)z, (double)u1, (double)v0);
        tessellator.func_78374_a((double)x0, (double)y0, (double)z, (double)u0, (double)v0);
    }

    public static void drawNonLivingEntity(int x, int y, int size, float yaw, float pitch, Entity entity) {
        GL11.glEnable((int)2903);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)50.0f);
        GL11.glScalef((float)(-size), (float)size, (float)size);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(180.0f - yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(-pitch), (float)1.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)32826);
        RenderHelper.func_74519_b();
        RenderManager.field_78727_a.field_78735_i = 180.0f;
        RenderManager.field_78727_a.func_147940_a(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f);
        GL11.glPopMatrix();
        RenderHelper.func_74518_a();
        GL11.glDisable((int)32826);
    }
}

