/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.api.ui.style.IRectStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import com.gtnewhorizons.wdmla.overlay.GuiDraw;
import org.jetbrains.annotations.NotNull;

public class RectDrawable
implements IDrawable {
    @NotNull
    private IRectStyle style = new RectStyle();

    public RectDrawable style(IRectStyle style) {
        this.style = style;
        return this;
    }

    @Override
    public void draw(IArea area) {
        if (this.style.getBackgroundColor1() != 0xFFFFFF || this.style.getBackgroundColor2() != 0xFFFFFF) {
            if (area.getH() == 1.0f) {
                GuiDraw.drawHorizontalLine(area.getX(), area.getY(), area.getW(), this.style.getBackgroundColor1());
            } else if (area.getW() == 1.0f) {
                GuiDraw.drawVerticalLine(area.getX(), area.getY(), area.getH(), this.style.getBackgroundColor1());
            } else {
                GuiDraw.drawGradientRect(area, this.style.getBackgroundColor1(), this.style.getBackgroundColor2());
            }
        }
        if (this.style.getBorderColor() != 0xFFFFFF) {
            GuiDraw.drawBoxBorder(area, this.style.getBorderThickness(), this.style.getBorderColor(), this.style.getBorderColor());
        }
    }
}

