/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.overlay.GuiDraw;
import net.minecraft.client.Minecraft;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class IconDrawable
implements IDrawable {
    private final IIcon icon;
    private final ResourceLocation path;
    private float suRatio = 0.0f;
    private float svRatio = 0.0f;
    private float twRatio = 1.0f;
    private float thRatio = 1.0f;

    public IconDrawable(IIcon icon, ResourceLocation path) {
        this.icon = icon;
        this.path = path;
    }

    public void clip(float suRatio, float svRatio, float twRatio, float thRatio) {
        this.suRatio = suRatio;
        this.svRatio = svRatio;
        this.twRatio = twRatio;
        this.thRatio = thRatio;
    }

    @Override
    public void draw(IArea area) {
        if (this.icon == null) {
            return;
        }
        float epsilon = 3.90625E-4f;
        float x = area.getX() + area.getW() * this.suRatio;
        float y = area.getY() + area.getH() * this.svRatio;
        float w = area.getW() * this.twRatio;
        float h = area.getH() * this.thRatio;
        float fullU = this.icon.func_94212_f() - 3.90625E-4f - this.icon.func_94209_e();
        float fullV = this.icon.func_94210_h() - 3.90625E-4f - this.icon.func_94206_g();
        float u0 = this.icon.func_94209_e() + 3.90625E-4f + fullU * this.suRatio;
        float v0 = this.icon.func_94206_g() + 3.90625E-4f + fullV * this.svRatio;
        float tw = fullU * w / area.getW();
        float th = fullV * h / area.getH();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.path);
        GuiDraw.drawTexturedModelRect(x, y, u0, v0, w, h, tw, th);
    }
}

