/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.ObjectDataCenter;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.impl.ui.value.Alpha;
import com.gtnewhorizons.wdmla.impl.ui.value.HUDBlockDamage;
import com.gtnewhorizons.wdmla.overlay.GuiDraw;
import org.jetbrains.annotations.NotNull;

public enum BreakProgressDrawable implements IDrawable
{
    INSTANCE;

    @NotNull
    private Alpha progressAlpha = new Alpha(0.0f);
    @NotNull
    private static HUDBlockDamage savedDamage;
    public boolean isBlockBrokenRecently = false;

    @Override
    public void draw(IArea area) {
        int color;
        if (General.breakProgress.mode != General.BreakProgress.Mode.FILLING_BAR) {
            return;
        }
        HUDBlockDamage damage = new HUDBlockDamage();
        if (damage.isIntact() && this.progressAlpha.isTransparent()) {
            return;
        }
        if (!damage.isIntact()) {
            savedDamage = damage;
            this.progressAlpha = savedDamage.getAlphaForProgress();
            this.isBlockBrokenRecently = false;
        } else if (this.isBlockBrokenRecently) {
            savedDamage = new HUDBlockDamage(1);
            this.progressAlpha = savedDamage.getAlphaForProgress();
            this.isBlockBrokenRecently = false;
        } else {
            this.progressAlpha = this.progressAlpha.fade();
        }
        int n = color = ObjectDataCenter.canCurrentTargetBeHarvested() ? this.progressAlpha.apply(-6250336) : this.progressAlpha.apply(-5636096);
        if (General.breakProgress.position == General.BreakProgress.Position.BOTTOM) {
            area = new Area(area.getX(), area.getEY(), area.getW(), area.getH());
        }
        GuiDraw.drawGradientRect(savedDamage.computeDrawArea(area), color, color);
    }

    static {
        savedDamage = new HUDBlockDamage();
    }
}

