/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.drawable;

import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IArea;
import com.gtnewhorizons.wdmla.impl.ui.drawable.IconDrawable;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import com.gtnewhorizons.wdmla.overlay.VanillaUIIcons;
import net.minecraft.util.MathHelper;

public class ArmorDrawable
implements IDrawable {
    private final int maxArmorsPerLine;
    private final float armor;
    private final float maxArmor;
    private final IconDrawable armorBG;
    private final IconDrawable armorIcon;
    private final IconDrawable hArmor;
    private final IconDrawable eArmor;

    public ArmorDrawable(int maxArmorsPerLine, float armor, float maxArmor) {
        this.maxArmorsPerLine = maxArmorsPerLine;
        this.armor = armor;
        this.maxArmor = maxArmor;
        this.armorBG = new IconDrawable(VanillaUIIcons.ARMOR_BG, VanillaUIIcons.PATH);
        this.armorIcon = new IconDrawable(VanillaUIIcons.ARMOR, VanillaUIIcons.PATH);
        this.hArmor = new IconDrawable(VanillaUIIcons.HARMOR, VanillaUIIcons.PATH);
        this.eArmor = new IconDrawable(VanillaUIIcons.EARMOR, VanillaUIIcons.PATH);
    }

    @Override
    public void draw(IArea area) {
        int nArmor = MathHelper.func_76123_f((float)this.maxArmor);
        int nArmorsPerLine = (int)Math.min((double)this.maxArmorsPerLine, Math.ceil(this.maxArmor));
        float offsetX = area.getX();
        float offsetY = area.getY();
        for (int iArmor = 1; iArmor <= nArmor; ++iArmor) {
            if (iArmor <= MathHelper.func_76141_d((float)this.armor)) {
                this.armorBG.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                this.armorIcon.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if ((float)iArmor > this.armor && (float)iArmor <= this.armor + 0.5f) {
                this.armorBG.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                this.hArmor.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if ((float)iArmor > this.armor + 0.5f) {
                this.eArmor.draw(new Area(offsetX, offsetY, 8.0f, 8.0f));
                offsetX += 8.0f;
            }
            if (iArmor % nArmorsPerLine != 0) continue;
            offsetY += 10.0f;
            offsetX = area.getX();
        }
    }
}

