/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.component.PanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import org.jetbrains.annotations.NotNull;

public class VPanelComponent
extends PanelComponent {
    @Override
    public void tick(float x, float y) {
        this.foreground.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), this.getWidth(), this.getHeight()));
        float totWidth = this.getWidth();
        float cy = y + this.padding.getTop() + this.bgStyle.getBorderThickness();
        for (int i = 0; i < this.children.size(); ++i) {
            float w = ((IComponent)this.children.get(i)).getWidth();
            float cx = x;
            switch (this.style.getAlignment()) {
                case TOPLEFT: {
                    cx = x + this.padding.getLeft() + this.bgStyle.getBorderThickness();
                    break;
                }
                case CENTER: {
                    cx = x + (totWidth - w) / 2.0f;
                    break;
                }
                case BOTTOMRIGHT: {
                    cx = x + totWidth - w - this.padding.getRight() - this.bgStyle.getBorderThickness();
                }
            }
            ((IComponent)this.children.get(i)).tick(cx, cy);
            if (i >= this.children.size() - 1) continue;
            cy += ((IComponent)this.children.get(i)).getHeight() + this.style.getSpacing();
        }
    }

    @Override
    public float getWidth() {
        float w = 0.0f;
        for (IComponent child : this.children) {
            float ww = child.getWidth();
            if (!(ww > w)) continue;
            w = ww;
        }
        return this.padding.getLeft() + w + this.padding.getRight() + this.bgStyle.getBorderThickness() * 2.0f;
    }

    @Override
    public float getHeight() {
        float h = 0.0f;
        for (IComponent child : this.children) {
            h += child.getHeight();
        }
        float totalSpacing = this.children.isEmpty() ? 0.0f : this.style.getSpacing() * (float)(this.children.size() - 1);
        return this.padding.getTop() + h + totalSpacing + this.padding.getBottom() + this.bgStyle.getBorderThickness() * 2.0f;
    }

    @Override
    public PanelComponent size(@NotNull ISize size) {
        throw new IllegalArgumentException("Vertical Panel is auto sized.");
    }
}

