/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui.component;

import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.IDrawable;
import com.gtnewhorizons.wdmla.api.ui.sizer.IPadding;
import com.gtnewhorizons.wdmla.api.ui.sizer.ISize;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Area;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class Component
implements IComponent {
    protected IPadding padding;
    protected ISize size;
    protected IDrawable foreground;
    protected ResourceLocation tag;

    protected Component(IPadding padding, ISize size, IDrawable foreground) {
        this.padding = padding;
        this.size = size;
        this.foreground = foreground;
    }

    public Component padding(@NotNull IPadding padding) {
        this.padding = padding;
        return this;
    }

    public Component size(@NotNull ISize size) {
        this.size = size;
        return this;
    }

    @Override
    public void tick(float x, float y) {
        this.foreground.draw(new Area(x + this.padding.getLeft(), y + this.padding.getTop(), this.size.getW(), this.size.getH()));
    }

    @Override
    public float getWidth() {
        return this.padding.getLeft() + this.size.getW() + this.padding.getRight();
    }

    @Override
    public float getHeight() {
        return this.padding.getTop() + this.size.getH() + this.padding.getBottom();
    }

    @Override
    public IComponent tag(ResourceLocation tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public ResourceLocation getTag() {
        return this.tag;
    }
}

