/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl.ui;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.Theme;
import com.gtnewhorizons.wdmla.api.ui.IComponent;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.MessageType;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.config.PluginsConfig;
import com.gtnewhorizons.wdmla.impl.format.TimeFormattingPattern;
import com.gtnewhorizons.wdmla.impl.ui.component.EntityComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.IconComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ItemComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.TextStyle;
import com.gtnewhorizons.wdmla.overlay.WDMlaUIIcons;
import com.gtnewhorizons.wdmla.plugin.vanilla.VanillaIdentifiers;
import com.gtnewhorizons.wdmla.util.FormatUtil;
import java.util.List;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.overlay.DisplayUtil;
import mcp.mobius.waila.utils.ModIdentification;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.Nullable;

public class ThemeHelper {
    public static final ThemeHelper INSTANCE = new ThemeHelper();
    private static final int ITEM_SIZE = Minecraft.func_71410_x().field_71466_p.field_78288_b;

    private ThemeHelper() {
    }

    @Deprecated
    public void overrideTooltipIcon(ITooltip root, ItemStack newItemStack) {
        this.overrideTooltipIcon(root, newItemStack, false);
    }

    public void overrideTooltipIcon(ITooltip root, ItemStack newItemStack, boolean overrideFancyRenderer) {
        if (!overrideFancyRenderer && PluginsConfig.core.defaultBlock.fancyRenderer == PluginsConfig.Core.fancyRendererMode.ALL) {
            return;
        }
        root.replaceChildWithTag(Identifiers.ITEM_ICON, new ItemComponent(newItemStack).doDrawOverlay(false).tag(Identifiers.ITEM_ICON));
    }

    public void overrideTooltipTitle(ITooltip root, ItemStack newItemStack) {
        String strippedName = DisplayUtil.itemDisplayNameShortFormatted(newItemStack);
        this.overrideTooltipTitle(root, strippedName);
    }

    public void overrideTooltipTitle(ITooltip root, String formattedNewName) {
        Theme theme = General.currentTheme.get();
        ITooltip replacedName = new HPanelComponent().child(new TextComponent(formattedNewName).style(new TextStyle().color(theme.textColor(MessageType.TITLE)))).tag(Identifiers.ITEM_NAME);
        root.replaceChildWithTag(Identifiers.ITEM_NAME, replacedName);
    }

    public void overrideEntityTooltipTitle(ITooltip root, String newName, @Nullable Entity entityMayHaveCustomName) {
        EntityLiving living;
        Theme theme = General.currentTheme.get();
        newName = entityMayHaveCustomName instanceof EntityLiving && (living = (EntityLiving)entityMayHaveCustomName).func_94056_bM() ? FormatUtil.formatNameByPixelCount(living.func_94057_bL()) : FormatUtil.formatNameByPixelCount(newName);
        ITooltip replacedName = new HPanelComponent().child(new TextComponent(newName).style(new TextStyle().color(theme.textColor(MessageType.TITLE)))).tag(Identifiers.ENTITY_NAME);
        root.replaceChildWithTag(Identifiers.ENTITY_NAME, replacedName);
    }

    public void overrideEntityTooltipIcon(ITooltip root, @Nullable Entity newEntity) {
        if (PluginsConfig.core.defaultEntity.showEntity) {
            if (!PluginsConfig.core.defaultEntity.fancyRenderer && !(newEntity instanceof EntityLiving)) {
                root.replaceChildWithTag(Identifiers.ENTITY, new HPanelComponent().tag(Identifiers.ENTITY));
            } else {
                root.replaceChildWithTag(Identifiers.ENTITY, new EntityComponent(newEntity).padding(new Padding(6, 0, 10, 0)).size(new Size(12, 12)).tag(Identifiers.ENTITY));
            }
        }
    }

    public void overrideTooltipModName(ITooltip root, ItemStack newItemStack) {
        this.overrideTooltipModName(root, ModIdentification.nameFromStack(newItemStack));
    }

    public void overrideTooltipModName(ITooltip root, String newName) {
        Theme theme = General.currentTheme.get();
        IComponent replacedModName = new TextComponent(SpecialChars.ITALIC + newName).style(new TextStyle().color(theme.textColor(MessageType.MOD_NAME))).tag(Identifiers.MOD_NAME);
        root.replaceChildWithTag(Identifiers.MOD_NAME, replacedModName);
    }

    public void overrideTooltipHeader(ITooltip root, ItemStack newItemStack) {
        this.overrideTooltipIcon(root, newItemStack, false);
        this.overrideTooltipTitle(root, newItemStack);
        this.overrideTooltipModName(root, newItemStack);
    }

    public IComponent info(String content) {
        return this.color(content, MessageType.INFO);
    }

    public IComponent title(String content) {
        return this.color(content, MessageType.TITLE);
    }

    public IComponent success(String content) {
        return this.color(content, MessageType.SUCCESS);
    }

    public IComponent warning(String content) {
        return this.color(content, MessageType.WARNING);
    }

    public IComponent danger(String content) {
        return this.color(content, MessageType.DANGER);
    }

    public IComponent failure(String content) {
        return this.color(content, MessageType.FAILURE);
    }

    public IComponent color(String content, MessageType type) {
        Theme theme = General.currentTheme.get();
        return new TextComponent(content).style(new TextStyle().color(theme.textColor(type)));
    }

    public IComponent furnaceLikeProgress(List<ItemStack> input, List<ItemStack> output, int currentProgress, int maxProgress, boolean showDetails) {
        return this.furnaceLikeProgress(input, output, currentProgress, maxProgress, showDetails, null);
    }

    public IComponent furnaceLikeProgress(List<ItemStack> input, List<ItemStack> output, int currentProgress, int maxProgress, boolean showDetails, @Nullable IComponent legacyProcessText) {
        if (!General.forceLegacy) {
            HPanelComponent hPanel = new HPanelComponent();
            for (ItemStack itemStack : input) {
                if (itemStack == null) continue;
                hPanel.item(itemStack);
            }
            float ratio = (float)currentProgress / (float)maxProgress;
            hPanel.padding(new Padding().horizontal(2)).child(new IconComponent(WDMlaUIIcons.FURNACE_BG, WDMlaUIIcons.FURNACE_BG.texPath).padding(new Padding()).child(new IconComponent(WDMlaUIIcons.FURNACE, WDMlaUIIcons.FURNACE.texPath).clip(0.0f, 0.0f, ratio, 1.0f).padding(new Padding())));
            for (ItemStack outputStack : output) {
                if (outputStack == null) continue;
                hPanel.item(outputStack);
            }
            return hPanel;
        }
        VPanelComponent vPanel = new VPanelComponent();
        if (showDetails) {
            for (ItemStack itemStack : input) {
                if (itemStack == null) continue;
                vPanel.horizontal().text(String.format("%s: ", StatCollector.func_74838_a((String)"hud.msg.wdmla.in"))).child(INSTANCE.info(String.format("%dx %s", itemStack.field_77994_a, DisplayUtil.itemDisplayNameShortFormatted(itemStack))));
            }
            for (ItemStack itemStack : output) {
                if (itemStack == null) continue;
                vPanel.horizontal().text(String.format("%s: ", StatCollector.func_74838_a((String)"hud.msg.wdmla.out"))).child(INSTANCE.info(String.format("%dx %s", itemStack.field_77994_a, DisplayUtil.itemDisplayNameShortFormatted(itemStack))));
            }
        }
        if (currentProgress != 0 && maxProgress != 0 && legacyProcessText == null) {
            legacyProcessText = INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.progress"), TimeFormattingPattern.ALWAYS_TICK.tickFormatter.apply(currentProgress) + " / " + TimeFormattingPattern.ALWAYS_TICK.tickFormatter.apply(maxProgress));
        }
        if (legacyProcessText != null) {
            vPanel.child(legacyProcessText);
        }
        if (vPanel.childrenSize() != 0) {
            return vPanel;
        }
        return null;
    }

    public IComponent value(String entry, String value) {
        return new HPanelComponent().text(String.format("%s: ", entry)).child(this.info(value));
    }

    public ITooltip smallItem(ItemStack itemStack) {
        return new ItemComponent(itemStack).doDrawOverlay(false).size(new Size(ITEM_SIZE, ITEM_SIZE));
    }

    public IComponent itemStackFullLine(ItemStack stack) {
        String strippedName = DisplayUtil.stripSymbols(DisplayUtil.itemDisplayNameShortFormatted(stack));
        TextComponent name = new TextComponent(strippedName);
        ITooltip hPanel = new HPanelComponent().child(this.smallItem(stack));
        String s = String.valueOf(stack.field_77994_a);
        return hPanel.text(s).text(StatCollector.func_74838_a((String)"hud.msg.wdmla.item.count") + "").child(name);
    }

    public IComponent growthValue(float growthValue) {
        if (growthValue < 1.0f) {
            return INSTANCE.value(StatCollector.func_74838_a((String)"hud.msg.wdmla.growth"), FormatUtil.PERCENTAGE_STANDARD.format(growthValue)).tag(VanillaIdentifiers.GROWTH_RATE);
        }
        return new HPanelComponent().text(String.format("%s: ", StatCollector.func_74838_a((String)"hud.msg.wdmla.growth"))).child(INSTANCE.success(String.format("%s", StatCollector.func_74838_a((String)"hud.msg.wdmla.mature")))).tag(VanillaIdentifiers.GROWTH_RATE);
    }
}

