/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.gtnewhorizons.wdmla.api.accessor.AccessorClientHandler;
import com.gtnewhorizons.wdmla.api.accessor.EntityAccessor;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.overlay.RayTracing;
import com.gtnewhorizons.wdmla.wailacompat.DataProviderCompat;
import com.gtnewhorizons.wdmla.wailacompat.RayTracingCompat;
import com.gtnewhorizons.wdmla.wailacompat.TooltipCompat;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.network.Message0x03EntRequest;
import mcp.mobius.waila.network.WailaPacketHandler;
import net.minecraft.entity.Entity;

public class EntityAccessorClientHandler
implements AccessorClientHandler<EntityAccessor> {
    private final TooltipCompat tooltipCompat = new TooltipCompat();
    private final DataProviderCompat dataProviderCompat = new DataProviderCompat();

    @Override
    public boolean shouldDisplay(EntityAccessor accessor) {
        return true;
    }

    @Override
    public boolean shouldRequestData(EntityAccessor accessor) {
        for (IServerDataProvider<EntityAccessor> provider : WDMlaCommonRegistration.instance().getEntityNBTProviders(accessor.getEntity())) {
            if (!provider.shouldRequestData(accessor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void requestData(EntityAccessor accessor) {
        HashSet<String> keys = new HashSet<String>();
        WailaPacketHandler.INSTANCE.sendToServer(new Message0x03EntRequest(accessor.getEntity(), keys));
    }

    @Override
    public void gatherComponents(EntityAccessor accessor, Function<IWDMlaProvider, ITooltip> tooltipProvider) {
        for (IComponentProvider<EntityAccessor> provider : WDMlaClientRegistration.instance().getEntityProviders(accessor.getEntity(), iComponentProvider -> WDMlaConfig.instance().isProviderEnabled((IComponentProvider<?>)iComponentProvider))) {
            ITooltip middleTooltip = tooltipProvider.apply(provider);
            provider.appendTooltip(middleTooltip, accessor);
        }
        DataAccessorCommon legacyAccessor = DataAccessorCommon.instance;
        legacyAccessor.set(accessor.getWorld(), accessor.getPlayer(), accessor.getHitResult());
        Entity entity = RayTracingCompat.INSTANCE.getWailaEntity(RayTracing.instance().getTarget());
        if (entity == null) {
            entity = RayTracing.instance().getTargetEntity();
        }
        List<String> legacyTooltips = this.dataProviderCompat.getLegacyEntityTooltips(entity, legacyAccessor);
        ITooltip convertedTooltips = this.tooltipCompat.computeRenderables(legacyTooltips);
        ITooltip lateTooltip = tooltipProvider.apply(null);
        lateTooltip.child(convertedTooltips);
    }
}

