/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.impl;

import com.gtnewhorizons.wdmla.api.accessor.AccessorClientHandler;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.provider.IWDMlaProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.config.WDMlaConfig;
import com.gtnewhorizons.wdmla.impl.WDMlaClientRegistration;
import com.gtnewhorizons.wdmla.impl.WDMlaCommonRegistration;
import com.gtnewhorizons.wdmla.wailacompat.DataProviderCompat;
import com.gtnewhorizons.wdmla.wailacompat.RayTracingCompat;
import com.gtnewhorizons.wdmla.wailacompat.TooltipCompat;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import mcp.mobius.waila.api.impl.ConfigHandler;
import mcp.mobius.waila.api.impl.DataAccessorCommon;
import mcp.mobius.waila.api.impl.ModuleRegistrar;
import mcp.mobius.waila.network.Message0x01TERequest;
import mcp.mobius.waila.network.WailaPacketHandler;
import mcp.mobius.waila.utils.Constants;
import net.minecraft.item.ItemStack;

public class BlockAccessorClientHandler
implements AccessorClientHandler<BlockAccessor> {
    private final TooltipCompat tooltipCompat = new TooltipCompat();
    private final DataProviderCompat dataProviderCompat = new DataProviderCompat();

    @Override
    public boolean shouldDisplay(BlockAccessor accessor) {
        return ConfigHandler.instance().getConfig("general", Constants.CFG_WAILA_SHOW, true);
    }

    @Override
    public boolean shouldRequestData(BlockAccessor accessor) {
        if (accessor.getTileEntity() == null) {
            return false;
        }
        for (IServerDataProvider<BlockAccessor> provider : WDMlaCommonRegistration.instance().getBlockNBTProviders(accessor.getBlock(), accessor.getTileEntity())) {
            if (!provider.shouldRequestData(accessor)) continue;
            return true;
        }
        return ModuleRegistrar.instance().hasNBTProviders(accessor.getBlock()) || ModuleRegistrar.instance().hasNBTProviders(accessor.getTileEntity());
    }

    @Override
    public void requestData(BlockAccessor accessor) {
        HashSet<String> keys = new HashSet<String>();
        WailaPacketHandler.INSTANCE.sendToServer(new Message0x01TERequest(accessor.getTileEntity(), keys));
    }

    @Override
    public void gatherComponents(BlockAccessor accessor, Function<IWDMlaProvider, ITooltip> tooltipProvider) {
        DataAccessorCommon legacyAccessor = DataAccessorCommon.instance;
        legacyAccessor.set(accessor.getWorld(), accessor.getPlayer(), accessor.getHitResult());
        ItemStack itemForm = RayTracingCompat.INSTANCE.getWailaStack(accessor.getHitResult());
        if (itemForm == null) {
            itemForm = accessor.getItemForm();
        }
        for (IComponentProvider<BlockAccessor> provider : WDMlaClientRegistration.instance().getBlockProviders(accessor.getBlock(), iComponentProvider -> WDMlaConfig.instance().isProviderEnabled((IComponentProvider<?>)iComponentProvider))) {
            ITooltip middleTooltip = tooltipProvider.apply(provider);
            provider.appendTooltip(middleTooltip, accessor);
        }
        List<String> legacyTooltips = this.dataProviderCompat.getLegacyBlockTooltips(itemForm, legacyAccessor);
        ITooltip convertedTooltips = this.tooltipCompat.computeRenderables(legacyTooltips);
        ITooltip lateTooltip = tooltipProvider.apply(null);
        lateTooltip.child(convertedTooltips);
    }
}

