/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.example;

import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.BlockAccessor;
import com.gtnewhorizons.wdmla.api.provider.IBlockComponentProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerDataProvider;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.sizer.IPadding;
import com.gtnewhorizons.wdmla.impl.ui.component.PanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ProgressComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Padding;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import java.util.Random;
import mcp.mobius.waila.overlay.DisplayUtil;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;

public enum ExampleNBTBlockProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    @Override
    public ResourceLocation getUid() {
        return Identifiers.EXAMPLE_NBT_BLOCK;
    }

    @Override
    public int getDefaultPriority() {
        return 10;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor) {
        int burnTime;
        int cookTime = accessor.getServerData().func_74765_d("CookTime");
        cookTime = Math.round((float)cookTime / 20.0f);
        ItemStack[] items = new ItemStack[3];
        NBTTagList itemsTag = accessor.getServerData().func_150295_c("Items", 10);
        boolean allEmpty = true;
        for (int i = 0; i < itemsTag.func_74745_c(); ++i) {
            NBTTagCompound itemTag = itemsTag.func_150305_b(i);
            byte slot = itemTag.func_74771_c("Slot");
            if (slot < 0 || slot >= items.length) continue;
            items[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            if (items[slot] == null) continue;
            allEmpty = false;
        }
        if (!accessor.showDetails()) {
            return;
        }
        int random = accessor.getServerData().func_74762_e("random");
        tooltip.child(new TextComponent("Recieved Server Data: " + random));
        if (cookTime != 0) {
            ITooltip amountTooltip = new ProgressComponent(cookTime, 10L).child(new VPanelComponent().padding(TooltipComponent.DEFAULT_PROGRESS_DESCRIPTION_PADDING).child(new TextComponent("Smelting: " + cookTime + " / 10 s")));
            tooltip.child(amountTooltip);
        }
        if ((burnTime = accessor.getServerData().func_74762_e("BurnTime") / 20) > 0) {
            tooltip.horizontal().text("Burn").item(new ItemStack((Block)Blocks.field_150480_ab), new Padding(), new Size(8, 8)).text(": " + burnTime + " Seconds Remaining");
        }
        if (!allEmpty) {
            IPadding itemPadding = new Padding().vertical(2);
            PanelComponent itemSection = new VPanelComponent().bgStyle(new RectStyle().backgroundColor(-2147418113).borderColor(-16711681));
            if (items[0] != null) {
                itemSection.horizontal().text("In: ", itemPadding).item(items[0], new Padding(), new Size(10, 10)).text(" " + DisplayUtil.itemDisplayNameShortFormatted(items[0]), itemPadding);
            }
            if (items[2] != null) {
                itemSection.horizontal().text("Out: ", itemPadding).item(items[2], new Padding(), new Size(10, 10)).text(" " + DisplayUtil.itemDisplayNameShortFormatted(items[2]), itemPadding);
            }
            if (items[1] != null) {
                itemSection.horizontal().text("Fuel: ", itemPadding).item(items[1], new Padding(), new Size(10, 10)).text(" " + DisplayUtil.itemDisplayNameShortFormatted(items[1]), itemPadding);
            }
            tooltip.child(itemSection);
        }
    }

    @Override
    public void appendServerData(NBTTagCompound data, BlockAccessor accessor) {
        ItemStack[] dummyItemStacks = new ItemStack[]{new ItemStack(Items.field_151174_bG), new ItemStack(Items.field_151044_h), new ItemStack(Items.field_151168_bH)};
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < 3; ++i) {
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            dummyItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        data.func_74782_a("Items", (NBTBase)nbttaglist);
        data.func_74777_a("CookTime", (short)100);
        data.func_74768_a("BurnTime", 5);
        data.func_74768_a("random", new Random().nextInt(11));
    }
}

