/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.example;

import com.google.common.collect.Lists;
import com.gtnewhorizons.wdmla.api.Identifiers;
import com.gtnewhorizons.wdmla.api.accessor.Accessor;
import com.gtnewhorizons.wdmla.api.provider.IClientExtensionProvider;
import com.gtnewhorizons.wdmla.api.provider.IServerExtensionProvider;
import com.gtnewhorizons.wdmla.api.view.ClientViewGroup;
import com.gtnewhorizons.wdmla.api.view.ItemView;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum ExampleItemStorageProvider implements IServerExtensionProvider<ItemStack>,
IClientExtensionProvider<ItemStack, ItemView>
{
    INSTANCE;


    @Override
    public List<ClientViewGroup<ItemView>> getClientGroups(Accessor accessor, List<ViewGroup<ItemStack>> groups) {
        return ClientViewGroup.map(groups, stack -> {
            NBTTagCompound customData = stack.func_77978_p();
            if (customData == null) {
                return null;
            }
            if (customData.func_74764_b("amount")) {
                String text = String.valueOf(customData.func_74762_e("amount"));
                return new ItemView((ItemStack)stack).amountText(text);
            }
            if (customData.func_74764_b("description")) {
                String desc = customData.func_74779_i("description");
                return new ItemView((ItemStack)stack).description(new TextComponent(desc));
            }
            return null;
        }, (viewGroup, clientViewGroup) -> {
            if (viewGroup.id != null) {
                clientViewGroup.title = viewGroup.id;
            }
        });
    }

    @Override
    @Nullable
    public List<ViewGroup<ItemStack>> getGroups(Accessor accessor) {
        Object object = accessor.getTarget();
        if (object instanceof IInventory) {
            IInventory inventory = (IInventory)object;
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                stack = stack.func_77946_l();
                NBTTagCompound amountNBT = new NBTTagCompound();
                long totalTime = accessor.getWorld().func_82737_E();
                amountNBT.func_74768_a("amount", (int)(totalTime % 400L / 20L));
                stack.func_77982_d(amountNBT);
                list.add(stack);
            }
            ArrayList list2 = Lists.newArrayList();
            for (int i = 0; i < 4; ++i) {
                ItemStack stack = new ItemStack(Items.field_151034_e, 3);
                NBTTagCompound descNBT = new NBTTagCompound();
                descNBT.func_74778_a("description", String.format("This item is %d times important", i));
                stack.func_77982_d(descNBT);
                list2.add(stack);
            }
            return Arrays.asList(new ViewGroup(list, "content", null), new ViewGroup(list2, "info", null));
        }
        return null;
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.EXAMPLE_ITEM_STORAGE;
    }
}

