/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.config;

import com.gtnewhorizon.gtnhlib.config.Config;
import com.gtnewhorizons.wdmla.plugin.debug.RegistryDataProvider;

@Config(modid="wdmla", category="plugins", configSubDirectory="WDMla", filename="plugins")
@Config.LangKey(value="option.wdmla.plugin.category")
public class PluginsConfig {
    public static final Core core = new Core();
    public static final Universal universal = new Universal();
    public static final Vanilla vanilla = new Vanilla();
    public static final Harvestability harvestability = new Harvestability();
    public static final Debug debug = new Debug();

    @Config.LangKey(value="provider.wdmla.core.category")
    public static class Core {
        public final DefaultBlock defaultBlock = new DefaultBlock();
        public final DefaultEntity defaultEntity = new DefaultEntity();

        @Config.LangKey(value="provider.wdmla.core.default.block")
        public static class DefaultBlock {
            @Config.LangKey(value="option.wdmla.core.show.blockicon")
            @Config.DefaultBoolean(value=true)
            public boolean showIcon;
            @Config.LangKey(value="option.wdmla.core.show.blockname")
            @Config.DefaultBoolean(value=true)
            public boolean showBlockName;
            @Config.LangKey(value="option.wdmla.core.show.modname")
            @Config.DefaultBoolean(value=true)
            public boolean showModName;
            @Config.LangKey(value="option.wdmla.core.fancy.renderer")
            @Config.DefaultEnum(value="ALL")
            @Config.Comment(value={"None: Always render fake itemStack, ALL: Always render 3D block, \n FALLBACK: Render 3D block if the block has no Item variant"})
            public fancyRendererMode fancyRenderer;
            @Config.LangKey(value="option.wdmla.core.renderer.rotation.speed")
            @Config.DefaultInt(value=1)
            @Config.RangeInt(min=1, max=10000)
            public int rendererRotationSpeed;
        }

        @Config.LangKey(value="provider.wdmla.core.default.entity")
        public static class DefaultEntity {
            @Config.LangKey(value="option.wdmla.core.show.entity")
            @Config.DefaultBoolean(value=true)
            public boolean showEntity;
            @Config.LangKey(value="option.wdmla.core.show.entityname")
            @Config.DefaultBoolean(value=true)
            public boolean showEntityName;
            @Config.LangKey(value="option.wdmla.core.show.modname")
            @Config.DefaultBoolean(value=true)
            public boolean showModName;
            @Config.LangKey(value="option.wdmla.core.fancy.renderer")
            @Config.DefaultBoolean(value=true)
            public boolean fancyRenderer;
            @Config.LangKey(value="option.wdmla.core.renderer.rotation.speed")
            @Config.DefaultInt(value=1)
            @Config.RangeInt(min=1, max=10000)
            public int rendererRotationSpeed;
            @Config.LangKey(value="option.wdmla.core.entity.icon.auto.scale")
            @Config.DefaultBoolean(value=true)
            public boolean iconAutoScale;
            @Config.LangKey(value="option.wdmla.core.entity.icon.default.scale")
            @Config.DefaultFloat(value=1.2f)
            @Config.RangeFloat(min=0.1f, max=100.0f)
            public float iconDefaultScale;
        }

        public static enum fancyRendererMode {
            NONE,
            FALLBACK,
            ALL;

        }
    }

    @Config.LangKey(value="provider.wdmla.universal.category")
    public static class Universal {
        public final ItemStorage itemStorage = new ItemStorage();
        public final FluidStorage fluidStorage = new FluidStorage();
        public final EnergyStorage energyStorage = new EnergyStorage();

        @Config.LangKey(value="provider.wdmla.universal.item.storage")
        public static class ItemStorage {
            @Config.LangKey(value="option.wdmla.universal.normal.amount")
            @Config.DefaultInt(value=9)
            @Config.RangeInt(min=0, max=10000)
            public int normalAmount;
            @Config.LangKey(value="option.wdmla.universal.detailed.amount")
            @Config.DefaultInt(value=54)
            @Config.RangeInt(min=0, max=10000)
            public int detailedAmount;
            @Config.LangKey(value="option.wdmla.universal.items.per.line")
            @Config.DefaultInt(value=9)
            @Config.RangeInt(min=0, max=10000)
            public int itemsPerLine;
            @Config.LangKey(value="option.wdmla.universal.show.name.amount")
            @Config.DefaultInt(value=4)
            @Config.RangeInt(min=0, max=10000)
            public int showNameAmount;
        }

        @Config.LangKey(value="provider.wdmla.universal.fluid.storage")
        public static class FluidStorage {
            @Config.LangKey(value="option.wdmla.universal.fluid.mode")
            @Config.DefaultEnum(value="GAUGE")
            public Mode mode;
            @Config.LangKey(value="option.wdmla.universal.fluid.normal.amount")
            @Config.DefaultInt(value=4)
            @Config.RangeInt(min=0, max=10000)
            public int normalAmount;
            @Config.LangKey(value="option.wdmla.universal.fluid.detailed")
            @Config.DefaultBoolean(value=false)
            public boolean detailed;

            public static enum Mode {
                GAUGE,
                ICON_TEXT,
                TEXT;

            }
        }

        @Config.LangKey(value="provider.wdmla.universal.energy.storage")
        public static class EnergyStorage {
        }
    }

    @Config.LangKey(value="provider.wdmla.minecraft.category")
    public static class Vanilla {
        public final RedstoneState redstoneState = new RedstoneState();
        public final Pet pet = new Pet();
        public final Animal animal = new Animal();
        public final CommandBlock commandBlock = new CommandBlock();

        @Config.LangKey(value="provider.wdmla.minecraft.redstone.state")
        public static class RedstoneState {
            @Config.LangKey(value="option.wdmla.vanilla.leverstate")
            @Config.DefaultBoolean(value=true)
            public boolean showLeverState;
            @Config.LangKey(value="option.wdmla.vanilla.repeater")
            @Config.DefaultBoolean(value=true)
            public boolean showRepeaterDelay;
            @Config.LangKey(value="option.wdmla.vanilla.comparator")
            @Config.DefaultBoolean(value=true)
            public boolean showComparatorMode;
        }

        @Config.LangKey(value="provider.wdmla.minecraft.pet")
        public static class Pet {
            @Config.LangKey(value="option.wdmla.vanilla.show.petsitting")
            @Config.DefaultBoolean(value=true)
            public boolean showPetSit;
            @Config.LangKey(value="option.wdmla.vanilla.show.petowner")
            @Config.DefaultBoolean(value=true)
            public boolean showPetOwner;
        }

        @Config.LangKey(value="provider.wdmla.minecraft.animal")
        public static class Animal {
            @Config.LangKey(value="option.wdmla.vanilla.show.animalgrowth")
            @Config.DefaultBoolean(value=true)
            public boolean showAnimalGrowth;
            @Config.LangKey(value="option.wdmla.vanilla.show.breedcooldown")
            @Config.DefaultBoolean(value=true)
            public boolean showBreedCooldown;
        }

        @Config.LangKey(value="provider.wdmla.minecraft.command.block")
        public static class CommandBlock {
            @Config.LangKey(value="option.wdmla.vanilla.max.command.length")
            @Config.DefaultInt(value=40)
            @Config.RangeInt(min=0, max=10000)
            public int maxCommandLength;
        }
    }

    @Config.LangKey(value="provider.wdmla.harvestability.category")
    public static class Harvestability {
        public final TinkersConstruct tinkersConstruct = new TinkersConstruct();
        public final IguanaTweaks iguanaTweaks = new IguanaTweaks();
        public final Icon icon = new Icon();
        public final Text text = new Text();
        public final Condition condition = new Condition();

        @Config.Comment(value={"IDs of the TiC effective pickaxe material corresponding to the harvest level."})
        @Config.LangKey(value="provider.wdmla.harvestability.tinkersconstruct")
        public static class TinkersConstruct {
            @Config.DefaultInt(value=0)
            @Config.Comment(value={"default: wood"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel0;
            @Config.DefaultInt(value=1)
            @Config.Comment(value={"default: stone"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel1;
            @Config.DefaultInt(value=2)
            @Config.Comment(value={"default: iron"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel2;
            @Config.DefaultInt(value=6)
            @Config.Comment(value={"default: obsidian"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel3;
            @Config.DefaultInt(value=10)
            @Config.Comment(value={"default: cobalt"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel4;
            @Config.DefaultInt(value=12)
            @Config.Comment(value={"default: manyullyn"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel5;
        }

        @Config.Comment(value={"IDs of the IguanaTweaks effective pickaxe material corresponding to the harvest level.\nIt will override TiC config if the mod is loaded"})
        @Config.LangKey(value="provider.wdmla.harvestability.iguanatweaks")
        public static final class IguanaTweaks {
            @Config.DefaultInt(value=0)
            @Config.Comment(value={"default: wood"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel0;
            @Config.DefaultInt(value=13)
            @Config.Comment(value={"default: copper"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel1;
            @Config.DefaultInt(value=2)
            @Config.Comment(value={"default: iron"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel2;
            @Config.DefaultInt(value=14)
            @Config.Comment(value={"default: tin"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel3;
            @Config.DefaultInt(value=16)
            @Config.Comment(value={"default: redstone"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel4;
            @Config.DefaultInt(value=6)
            @Config.Comment(value={"default: obsidian"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel5;
            @Config.DefaultInt(value=11)
            @Config.Comment(value={"default: ardite"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel6;
            @Config.DefaultInt(value=10)
            @Config.Comment(value={"default: cobalt"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel7;
            @Config.DefaultInt(value=12)
            @Config.Comment(value={"default: manyullyn"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel8;
            @Config.DefaultInt(value=12)
            @Config.Comment(value={"default: manyullynplus"})
            @Config.RangeInt(min=1, max=100)
            public int harvestLevel9;
        }

        @Config.LangKey(value="provider.wdmla.harvestability.icon")
        public static final class Icon {
            @Config.LangKey(value="option.wdmla.harvestability.currentlyHarvestable.icon")
            @Config.DefaultBoolean(value=true)
            @Config.Comment(value={"Shows the line of Currently Harvestable icons"})
            public boolean currentlyHarvestableIcon;
            @Config.LangKey(value="option.wdmla.harvestability.currentlyharvestable.string")
            @Config.DefaultString(value="\u2714")
            @Config.Comment(value={"The string below the Harvest Tool icon after the item name"})
            public String currentlyHarvestableString;
            @Config.LangKey(value="option.wdmla.harvestability.notcurrentlyharvestable.string")
            @Config.DefaultString(value="\u2715")
            @Config.Comment(value={"The string below the Harvest Tool icon after the item name"})
            public String notCurrentlyHarvestableString;
            @Config.LangKey(value="option.wdmla.harvestability.shearability.item")
            @Config.DefaultString(value="minecraft:shears")
            @Config.Comment(value={"The icon after an item represents that the item is shearable"})
            public String shearabilityItem;
            @Config.LangKey(value="option.wdmla.harvestability.silktouchability.item")
            @Config.DefaultString(value="minecraft:grass")
            @Config.Comment(value={"The icon after an item represents that the item can be harvested by silk touch"})
            public String silkTouchabilityItem;
            @Config.LangKey(value="option.wdmla.harvestability.effectivetool.icon")
            @Config.DefaultBoolean(value=true)
            @Config.Comment(value={"Shows the Effective Tool icon along with Currently Harvestable icon"})
            public boolean effectiveToolIcon;
            @Config.LangKey(value="option.wdmla.harvestability.shearability.icon")
            @Config.DefaultBoolean(value=true)
            @Config.Comment(value={"Shows the Shearability icon when holding the respective tool"})
            public boolean showShearabilityIcon;
            @Config.LangKey(value="option.wdmla.harvestability.silktouchability.icon")
            @Config.DefaultBoolean(value=true)
            @Config.Comment(value={"Shows the Silktouchabiity icon when holding the respective tool"})
            public boolean showSilkTouchabilityIcon;
            @Config.LangKey(value="option.wdmla.harvestability.coloriconwitheffectiveness")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Colors the Currently Harvestable icon with held tool effectiveness"})
            public boolean colorIconWithEffectiveness;
            @Config.LangKey(value="option.wdmla.harvestability.always.show.additional.tools")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Shows additional tools like Silktouchabiity even if you aren't holding the respective tool"})
            public boolean alwaysShowAdditionalTools;
        }

        @Config.LangKey(value="provider.wdmla.harvestability.text")
        public static final class Text {
            @Config.LangKey(value="option.wdmla.harvestability.harvestlevelnum")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Shows the Harvest Level number as text"})
            public boolean harvestLevelNum;
            @Config.LangKey(value="option.wdmla.harvestability.harvestlevelname")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Shows the Harvest Level name as text, if it is different than number"})
            public boolean harvestLevelName;
            @Config.LangKey(value="option.wdmla.harvestability.effectivetool.line")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Shows the Effective Tool line"})
            public boolean effectiveToolLine;
            @Config.LangKey(value="option.wdmla.harvestability.currentlyharvestable.line")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Shows the Currently Harvestable line"})
            public boolean currentlyHarvestableLine;
        }

        @Config.LangKey(value="provider.wdmla.harvestability.condition")
        public static final class Condition {
            @Config.LangKey(value="option.wdmla.harvestability.oresonly")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Only shows tooltip when the block is ore"})
            public boolean oresOnly;
            @Config.LangKey(value="option.wdmla.harvestability.textdetailsonly")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Only shows the text part of the tooltip when pressing details key"})
            public boolean textDetailsOnly;
            @Config.LangKey(value="option.wdmla.harvestability.unharvestableonly")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Only shows tooltip when the block cannot be harvested"})
            public boolean unHarvestableOnly;
            @Config.LangKey(value="option.wdmla.harvestability.toolrequiredonly")
            @Config.DefaultBoolean(value=false)
            @Config.Comment(value={"Only shows tooltip when a tool is required to harvest"})
            public boolean toolRequiredOnly;
        }
    }

    @Config.LangKey(value="provider.wdmla.debug.category")
    public static class Debug {
        public final RegistryData registryData = new RegistryData();

        @Config.LangKey(value="provider.wdmla.debug.registry.data")
        public static class RegistryData {
            @Config.LangKey(value="option.wdmla.debug.entity.registry.data")
            @Config.DefaultBoolean(value=false)
            public boolean entityRegistryData;
            @Config.LangKey(value="option.wdmla.debug.registry.data.display.mode")
            @Config.DefaultEnum(value="SHORT")
            public RegistryDataProvider.DisplayMode displayMode;
        }
    }
}

