/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.view;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.jetbrains.annotations.Nullable;

public class ViewGroup<T> {
    public List<T> views;
    @Nullable
    public String id;
    @Nullable
    protected NBTTagCompound extraData;

    public ViewGroup(List<T> views) {
        this(views, null, null);
    }

    public ViewGroup(List<T> views, @Nullable String id, @Nullable NBTTagCompound extraData) {
        this.views = views;
        this.id = id;
        this.extraData = extraData;
    }

    public ViewGroup(List<T> newViews, ViewGroup<?> oldGroup) {
        this.views = newViews;
        this.id = oldGroup.id;
        this.extraData = oldGroup.extraData;
    }

    public NBTTagCompound getExtraData() {
        if (this.extraData == null) {
            this.extraData = new NBTTagCompound();
        }
        return this.extraData;
    }

    public void setProgress(float progress) {
        this.getExtraData().func_74776_a("Progress", progress);
    }

    public static NBTTagCompound encode(ViewGroup<NBTTagCompound> viewGroup) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < viewGroup.views.size(); ++i) {
            NBTTagCompound viewNBTTag = new NBTTagCompound();
            viewNBTTag.func_74774_a("index", (byte)i);
            viewNBTTag.func_74782_a("view", (NBTBase)viewGroup.views.get(i));
            nbttaglist.func_74742_a((NBTBase)viewNBTTag);
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74782_a("views", (NBTBase)nbttaglist);
        if (viewGroup.id != null) {
            data.func_74778_a("id", viewGroup.id);
        }
        if (viewGroup.extraData != null) {
            data.func_74782_a("extradata", (NBTBase)viewGroup.extraData);
        }
        return data;
    }

    public static ViewGroup<NBTTagCompound> decode(NBTTagCompound data) {
        NBTTagList nbttaglist = data.func_150295_c("views", 10);
        ArrayList<NBTTagCompound> views = new ArrayList<NBTTagCompound>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound view = nbttaglist.func_150305_b(i).func_74775_l("view");
            views.add(view);
        }
        String id = data.func_74764_b("id") ? data.func_74779_i("id") : null;
        NBTTagCompound extraData = data.func_74764_b("extradata") ? data.func_74775_l("extradata") : null;
        return new ViewGroup<NBTTagCompound>(views, id, extraData);
    }
}

