/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wdmla.api.view;

import com.gtnewhorizons.wdmla.api.Theme;
import com.gtnewhorizons.wdmla.api.ui.ComponentAlignment;
import com.gtnewhorizons.wdmla.api.ui.ITooltip;
import com.gtnewhorizons.wdmla.api.ui.MessageType;
import com.gtnewhorizons.wdmla.api.view.ViewGroup;
import com.gtnewhorizons.wdmla.config.General;
import com.gtnewhorizons.wdmla.impl.ui.component.HPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.PanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.ProgressComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.RectComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TextComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.TooltipComponent;
import com.gtnewhorizons.wdmla.impl.ui.component.VPanelComponent;
import com.gtnewhorizons.wdmla.impl.ui.sizer.Size;
import com.gtnewhorizons.wdmla.impl.ui.style.PanelStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.ProgressStyle;
import com.gtnewhorizons.wdmla.impl.ui.style.RectStyle;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class ClientViewGroup<T> {
    public final List<T> views;
    @Nullable
    public String title;
    @ApiStatus.Experimental
    public MessageType messageType = MessageType.NORMAL;
    @ApiStatus.Experimental
    public float boxProgress;
    @Nullable
    public NBTTagCompound extraData;

    public ClientViewGroup(List<T> views) {
        this.views = views;
    }

    public static <IN, OUT> List<ClientViewGroup<OUT>> map(List<ViewGroup<IN>> groups, Function<IN, OUT> itemFactory, @Nullable BiConsumer<ViewGroup<IN>, ClientViewGroup<OUT>> clientGroupDecorator) {
        return groups.stream().map($ -> {
            ClientViewGroup group = new ClientViewGroup($.views.stream().map(itemFactory).filter(Objects::nonNull).collect(Collectors.toList()));
            NBTTagCompound data = $.extraData;
            if (data != null) {
                group.boxProgress = data.func_74760_g("Progress");
                String messageTypeString = data.func_74779_i("MessageType");
                MessageType messageType = group.messageType = !StringUtils.func_151246_b((String)messageTypeString) ? MessageType.valueOf(messageTypeString) : MessageType.NORMAL;
            }
            if (clientGroupDecorator != null) {
                clientGroupDecorator.accept((ViewGroup)$, group);
            }
            group.extraData = data;
            return group;
        }).collect(Collectors.toList());
    }

    public static <T> void tooltip(ITooltip tooltip, List<ClientViewGroup<T>> groups, boolean renderGroup, BiConsumer<ITooltip, ClientViewGroup<T>> consumer) {
        for (ClientViewGroup<T> group : groups) {
            consumer.accept(tooltip, group);
            if (!renderGroup || !(group.boxProgress > 0.0f) || !(group.boxProgress < 1.0f)) continue;
            TextComponent content = new TextComponent(String.format("%d%%", (int)(group.boxProgress * 100.0f)));
            tooltip.child(new ProgressComponent(group.boxProgress).style(new ProgressStyle().singleColor(General.currentTheme.get().textColor(group.messageType))).child(new VPanelComponent().padding(TooltipComponent.DEFAULT_PROGRESS_DESCRIPTION_PADDING).child(content)));
        }
    }

    public boolean shouldRenderGroup() {
        return this.title != null || this.boxProgress > 0.0f;
    }

    public void renderHeader(ITooltip tooltip) {
        if (this.title != null) {
            Theme theme = General.currentTheme.get();
            PanelComponent hPanel = new HPanelComponent().style(new PanelStyle().alignment(ComponentAlignment.CENTER));
            hPanel.child(new RectComponent().style(new RectStyle().backgroundColor(theme.textColor(MessageType.NORMAL))).size(new Size(20, 1)));
            hPanel.child(new TextComponent(this.title).scale(0.6f));
            hPanel.child(new RectComponent().style(new RectStyle().backgroundColor(theme.textColor(MessageType.NORMAL))).size(new Size(30, 1)));
            tooltip.child(hPanel);
        }
    }
}

