/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.api.TCExtensionManager;
import acs.tabbychat.compat.MacroKeybindCompat;
import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.GuiSleepTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.gui.context.ChatContextMenu;
import acs.tabbychat.gui.context.ContextCopy;
import acs.tabbychat.gui.context.ContextCut;
import acs.tabbychat.gui.context.ContextPaste;
import acs.tabbychat.gui.context.ContextSpellingSuggestion;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.settings.TimeStampEnum;
import acs.tabbychat.threads.BackgroundChatThread;
import acs.tabbychat.util.IPResolver;
import com.google.common.collect.Lists;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.StringUtils;
import org.apache.commons.compress.compressors.gzip.GzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TabbyChatUtils {
    public static final String version = "1.12.2";
    public static final String name = "TabbyChat";
    public static final String modid = "tabbychat";
    public static Logger log = LogManager.getLogger((String)"TabbyChat");
    private static Calendar logDay = Calendar.getInstance();
    private static final File logDir = new File(new File(Minecraft.func_71410_x().field_71412_D, "logs"), "TabbyChat");
    private static final SimpleDateFormat logNameFormat = new SimpleDateFormat("'_'yyyy-MM-dd'.log'");

    public static void startup() {
        TabbyChatUtils.compressLogs();
        ChatContextMenu.addContext(new ContextSpellingSuggestion());
        ChatContextMenu.addContext(new ContextCut());
        ChatContextMenu.addContext(new ContextCopy());
        ChatContextMenu.addContext(new ContextPaste());
        TCExtensionManager.INSTANCE.registerExtension(MacroKeybindCompat.class);
    }

    private static void compressLogs() {
        if (!logDir.exists()) {
            return;
        }
        Collection logs = FileUtils.listFiles((File)logDir, (String[])new String[]{"txt", "log"}, (boolean)true);
        for (File file : logs) {
            String name = file.getName();
            if (name.contains(logNameFormat.format(logDay.getTime()))) continue;
            try {
                TabbyChatUtils.gzipFile(file);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gzipFile(File file) throws IOException {
        File dest = new File(file.getParentFile(), GzipUtils.getCompressedFilename((String)file.getName()));
        try (FileOutputStream os = new FileOutputStream(dest);){
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream(os), StandardCharsets.UTF_8);){
                writer.write(FileUtils.readFileToString((File)file, (String)"UTF-8"));
            }
            finally {
                if (!file.delete()) {
                    TabbyChat.printErr("Failed to delete " + file.getName() + " after zipping");
                }
            }
        }
    }

    public static void chatGuiTick(Minecraft mc) {
        GuiScreen screen = mc.field_71462_r;
        if (!(screen instanceof GuiChat)) {
            return;
        }
        GuiChat chat = (GuiChat)screen;
        if (screen.getClass() == GuiChatTC.class) {
            return;
        }
        if (screen.getClass() == GuiSleepTC.class) {
            return;
        }
        if (screen instanceof GuiSleepMP) {
            mc.func_147108_a((GuiScreen)new GuiSleepTC());
        } else {
            mc.func_147108_a((GuiScreen)new GuiChatTC(chat.field_146409_v));
        }
    }

    public static ServerData getServerData() {
        return Minecraft.func_71410_x().func_147104_D();
    }

    public static File getServerDir() {
        String ip = new IPResolver(TabbyChatUtils.getServerIp()).getSafeAddress();
        return new File(ITCSettingsGUI.tabbyChatDir, ip);
    }

    public static String getServerIp() {
        String ip = Minecraft.func_71410_x().func_71356_B() ? "singleplayer" : (TabbyChatUtils.getServerData() == null ? "unknown" : TabbyChatUtils.getServerData().field_78845_b);
        return ip;
    }

    public static File getTabbyChatDir() {
        return new File(new File(Minecraft.func_71410_x().field_71412_D, "config"), modid);
    }

    public static void hookIntoChat(GuiNewChatTC _gnc) {
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        if (chat.getClass() != GuiNewChatTC.class) {
            try {
                ReflectionHelper.setPrivateValue(GuiIngame.class, (Object)Minecraft.func_71410_x().field_71456_v, (Object)((Object)_gnc), (int)6);
                _gnc.field_146248_g = chat.func_146238_c();
                _gnc.backupLines = (List)ReflectionHelper.getPrivateValue(GuiNewChat.class, (Object)chat, (int)3);
                _gnc.field_146252_h = (List)ReflectionHelper.getPrivateValue(GuiNewChat.class, (Object)chat, (int)4);
            }
            catch (Exception e) {
                TabbyChat.printException("Error loading chat hook.", e);
            }
        }
    }

    public static void logChat(String theChat, ChatChannel theChannel) {
        String basename;
        File fileDir;
        Calendar tmpcal = Calendar.getInstance();
        String time = SimpleDateFormat.getTimeInstance().format(Calendar.getInstance().getTime());
        theChat = StringUtils.func_76338_a((String)String.format("[%s] %s", time, theChat));
        if (theChannel == null || theChannel.getTitle() == null) {
            theChannel = new ChatChannel("*");
        }
        if (Objects.equals(TabbyChatUtils.getServerIp(), "singleplayer")) {
            IntegratedServer ms = Minecraft.func_71410_x().func_71401_C();
            fileDir = new File(new File(logDir, "singleplayer"), ms.func_71221_J());
        } else {
            fileDir = new File(logDir, new IPResolver(TabbyChatUtils.getServerIp()).getSafeAddress());
        }
        if (!theChannel.getTitle().equals("*")) {
            fileDir = new File(fileDir, theChannel.getTitle());
            basename = theChannel.getTitle();
        } else {
            basename = "all";
        }
        if (theChannel.getLogFile() == null || tmpcal.get(6) != logDay.get(6)) {
            logDay = tmpcal;
            theChannel.setLogFile(new File(fileDir, basename + logNameFormat.format(logDay.getTime())));
        }
        if (!theChannel.getLogFile().exists()) {
            try {
                Files.createDirectories(fileDir.toPath(), new FileAttribute[0]);
                Files.createFile(theChannel.getLogFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                TabbyChat.printErr("Cannot create log file : '" + e.getLocalizedMessage() + "' : " + e);
                return;
            }
        }
        try {
            FileUtils.writeLines((File)theChannel.getLogFile(), (String)"UTF-8", (Collection)Lists.newArrayList((Object[])new String[]{theChat.trim()}), (boolean)true);
        }
        catch (IOException e) {
            TabbyChat.printErr("Cannot write to log file : '" + e.getLocalizedMessage() + "' : " + e);
        }
    }

    public static Float median(float val1, float val2, float val3) {
        if (val1 < val2 && val1 < val3) {
            return Float.valueOf(Math.min(val2, val3));
        }
        if (val1 > val2 && val1 > val3) {
            return Float.valueOf(Math.max(val2, val3));
        }
        return Float.valueOf(val1);
    }

    public static ColorCodeEnum parseColor(String _input) {
        if (_input == null) {
            return null;
        }
        try {
            return ColorCodeEnum.valueOf(_input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static ChannelDelimEnum parseDelimiters(String _input) {
        if (_input == null) {
            return null;
        }
        try {
            return ChannelDelimEnum.valueOf(_input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static FormatCodeEnum parseFormat(String _input) {
        if (_input == null) {
            return null;
        }
        try {
            return FormatCodeEnum.valueOf(_input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Integer parseInteger(String _input, int min, int max, int fallback) {
        int result;
        try {
            result = Integer.parseInt(_input);
            result = Math.max(min, result);
            result = Math.min(max, result);
        }
        catch (NumberFormatException e) {
            result = fallback;
        }
        return result;
    }

    public static int parseInteger(String _input) {
        NumberFormat formatter = NumberFormat.getInstance();
        boolean state = formatter.isParseIntegerOnly();
        formatter.setParseIntegerOnly(true);
        ParsePosition pos = new ParsePosition(0);
        int result = formatter.parse(_input, pos).intValue();
        formatter.setParseIntegerOnly(state);
        if (_input.length() == pos.getIndex()) {
            return result;
        }
        return -1;
    }

    public static NotificationSoundEnum parseSound(String _input) {
        if (_input == null) {
            return NotificationSoundEnum.ORB;
        }
        try {
            return NotificationSoundEnum.valueOf(_input);
        }
        catch (IllegalArgumentException e) {
            return NotificationSoundEnum.ORB;
        }
    }

    public static String parseString(String _input) {
        return _input == null ? " " : _input;
    }

    public static TimeStampEnum parseTimestamp(String _input) {
        if (_input == null) {
            return null;
        }
        try {
            return TimeStampEnum.valueOf(_input);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static LinkedHashMap<String, ChatChannel> swapChannels(LinkedHashMap<String, ChatChannel> currentMap, int _left, int _right) {
        if (_left == _right) {
            return currentMap;
        }
        if (_left > _right) {
            int _tmp = _left;
            _left = _right;
            _right = _tmp;
        }
        if (_right >= currentMap.size()) {
            return currentMap;
        }
        String[] arrayCopy = new String[currentMap.size()];
        arrayCopy = currentMap.keySet().toArray(arrayCopy);
        String tmp = arrayCopy[_left];
        arrayCopy[_left] = arrayCopy[_right];
        arrayCopy[_right] = tmp;
        int n = arrayCopy.length;
        LinkedHashMap<String, ChatChannel> returnMap = new LinkedHashMap<String, ChatChannel>(n);
        for (String s : arrayCopy) {
            returnMap.put(s, currentMap.get(s));
        }
        return returnMap;
    }

    public static void writeLargeChat(String toSend) {
        BackgroundChatThread sendProc;
        List<String> actives = TabbyChat.getInstance().getActive();
        if (!TabbyChat.getInstance().enabled() || actives.size() != 1) {
            sendProc = new BackgroundChatThread(toSend);
        } else {
            ChatChannel active = TabbyChat.getInstance().channelMap.get(actives.get(0));
            String tabPrefix = active.cmdPrefix;
            boolean hiddenPrefix = active.hidePrefix;
            if (((Boolean)TabbyChat.advancedSettings.convertUnicodeText.getValue()).booleanValue()) {
                toSend = TabbyChatUtils.convertUnicode(toSend);
            }
            sendProc = tabPrefix != null && tabPrefix.length() > 0 ? (!hiddenPrefix ? new BackgroundChatThread(toSend, tabPrefix) : (!toSend.startsWith("/") ? new BackgroundChatThread(tabPrefix + " " + toSend, tabPrefix) : new BackgroundChatThread(toSend))) : new BackgroundChatThread(toSend);
        }
        sendProc.start();
    }

    public static String convertUnicode(String chat) {
        StringBuilder newChat = new StringBuilder();
        for (String s : chat.split("\\\u0000")) {
            if (s.contains("u")) {
                try {
                    newChat.append(StringEscapeUtils.unescapeJava((String)s));
                }
                catch (IllegalArgumentException e) {
                    newChat.append(s);
                }
                continue;
            }
            newChat.append(s);
        }
        return newChat.toString();
    }

    public static void saveProperties(Properties settingsTable, File settingsFile, Pair<String, String> parentDirLogMessage, String propertyPrefix) {
        Logger log = TabbyChatUtils.log;
        if (!settingsFile.getParentFile().exists()) {
            try {
                Files.createDirectories(settingsFile.getParentFile().toPath(), new FileAttribute[0]);
                log.info((String)parentDirLogMessage.getLeft());
            }
            catch (IOException e) {
                log.warn((String)parentDirLogMessage.getRight());
            }
        }
        try (FileOutputStream fOutStream = new FileOutputStream(settingsFile);
             BufferedOutputStream bOutStream = new BufferedOutputStream(fOutStream);){
            settingsTable.store(bOutStream, propertyPrefix);
        }
        catch (Exception e) {
            TabbyChat.printException("Error while writing settings to file '" + settingsFile + "'", e);
        }
    }

    public static Properties loadSettingsFromFile(File file) {
        Properties settingsTable = new Properties();
        if (file == null) {
            return settingsTable;
        }
        if (!file.exists()) {
            try {
                Files.createDirectories(file.getParentFile().toPath(), new FileAttribute[0]);
                Files.createFile(file.toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                TabbyChat.printException("Error while creating file '" + file + "'", e);
            }
            return settingsTable;
        }
        try (FileInputStream fInStream = new FileInputStream(file);
             BufferedInputStream bInStream = new BufferedInputStream(fInStream);){
            settingsTable.load(bInStream);
        }
        catch (Exception e) {
            TabbyChat.printException("Error while reading settings from file '" + file + "'", e);
        }
        return settingsTable;
    }
}

