/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.api.IChatExtension;
import acs.tabbychat.util.TabbyChatUtils;
import java.util.ArrayList;
import java.util.List;

public class ChatExtensions {
    private final List<IChatExtension> list = new ArrayList<IChatExtension>();

    public ChatExtensions(List<Class<? extends IChatExtension>> list) {
        for (Class<? extends IChatExtension> ext : list) {
            try {
                IChatExtension exten = ext.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                exten.load();
                this.list.add(exten);
            }
            catch (Exception e) {
                TabbyChatUtils.log.error("Unable to initialize " + ext.getName(), (Throwable)e);
            }
        }
    }

    public <T extends IChatExtension> List<T> getListOf(Class<T> extClass) {
        ArrayList<IChatExtension> t = new ArrayList<IChatExtension>();
        for (IChatExtension ext : this.list) {
            if (!extClass.isInstance(ext)) continue;
            t.add(ext);
        }
        return t;
    }
}

