/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.util;

import acs.tabbychat.core.TCChatLine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.ChatComponentStyle;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class ChatComponentUtils {
    private static final FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;

    public static IChatComponent replaceText(IChatComponent chat, String regex, String replacement) {
        List iter = chat.func_150253_a();
        ChatComponentText newChat = new ChatComponentText("");
        for (IChatComponent next : iter) {
            ChatComponentText comp = new ChatComponentText(next.func_150260_c().replaceAll(regex, replacement));
            comp.func_150255_a(next.func_150256_b().func_150232_l());
            newChat.func_150257_a((IChatComponent)comp);
        }
        return newChat;
    }

    public static String formatString(String text, boolean force) {
        return !force && !Minecraft.func_71410_x().field_71474_y.field_74344_o ? EnumChatFormatting.func_110646_a((String)text) : text;
    }

    public static List<TCChatLine> split(List<TCChatLine> lines, int width) {
        ArrayList<TCChatLine> list = new ArrayList<TCChatLine>();
        for (TCChatLine line : lines) {
            list.addAll(ChatComponentUtils.split(line, width));
        }
        return list;
    }

    public static List<TCChatLine> split(TCChatLine line, int width) {
        ArrayList<TCChatLine> list = new ArrayList<TCChatLine>();
        List<IChatComponent> ichat = ChatComponentUtils.split(line.getChatComponentWithTimestamp(), width);
        for (IChatComponent chat : ichat) {
            list.add(0, new TCChatLine(line.func_74540_b(), chat, line.func_74539_c()));
        }
        return list;
    }

    public static List<IChatComponent> split(IChatComponent chat, int limit) {
        int j = 0;
        ChatComponentText chatcomponenttext = new ChatComponentText("");
        ArrayList<IChatComponent> arraylist = new ArrayList<IChatComponent>();
        ArrayList arraylist1 = Lists.newArrayList(ChatComponentUtils.getTypeSafeIterable(chat));
        for (int k = 0; k < arraylist1.size(); ++k) {
            String s4;
            String s1;
            IChatComponent ichatcomponent1;
            String s;
            if (chatcomponenttext == null) {
                chatcomponenttext = new ChatComponentText(" ");
            }
            if ((s = (ichatcomponent1 = (IChatComponent)arraylist1.get(k)).func_150261_e()) == null) {
                s = "";
            }
            boolean flag2 = false;
            if (s.contains("\n")) {
                int l = s.indexOf(10);
                s1 = s.substring(l + 1);
                s = s.substring(0, l + 1);
                ChatComponentText chatcomponenttext1 = new ChatComponentText(s1);
                chatcomponenttext1.func_150255_a(ichatcomponent1.func_150256_b().func_150232_l());
                arraylist1.add(k + 1, chatcomponenttext1);
                flag2 = true;
            }
            s1 = (s4 = ChatComponentUtils.formatString(ichatcomponent1.func_150256_b().func_150218_j() + s, true)).endsWith("\n") ? s4.substring(0, s4.length() - 1) : s4;
            int j1 = fontRenderer.func_78256_a(s1);
            ChatComponentText chatcomponenttext2 = new ChatComponentText(s1);
            chatcomponenttext2.func_150255_a(ichatcomponent1.func_150256_b().func_150232_l());
            if (j + j1 > limit) {
                String s3;
                String s2 = fontRenderer.func_78262_a(s4, limit - j, false);
                String string = s3 = s2.length() < s4.length() ? s4.substring(s2.length()) : null;
                if (s3 != null && s3.length() > 0) {
                    int i1 = s2.lastIndexOf(" ");
                    if (i1 >= 0 && fontRenderer.func_78256_a(s4.substring(0, i1)) > 0) {
                        s2 = s4.substring(0, i1);
                        s3 = s4.substring(++i1);
                    } else if (j > 0 && !s4.contains(" ")) {
                        s2 = "";
                        s3 = s4;
                    }
                    ChatComponentText chatcomponenttext3 = new ChatComponentText(s3);
                    chatcomponenttext3.func_150255_a(ichatcomponent1.func_150256_b().func_150232_l());
                    arraylist1.add(k + 1, chatcomponenttext3);
                }
                j1 = fontRenderer.func_78256_a(s2);
                chatcomponenttext2 = new ChatComponentText(s2);
                chatcomponenttext2.func_150255_a(ichatcomponent1.func_150256_b().func_150232_l());
                flag2 = true;
            }
            if (j + j1 <= limit) {
                j += j1;
                chatcomponenttext.func_150257_a((IChatComponent)chatcomponenttext2);
            } else {
                flag2 = true;
            }
            if (!flag2) continue;
            arraylist.add((IChatComponent)chatcomponenttext);
            j = 0;
            chatcomponenttext = null;
        }
        arraylist.add((IChatComponent)chatcomponenttext);
        return arraylist;
    }

    public static IChatComponent formattedStringToChat(String chat) {
        ChatComponentText newChat = new ChatComponentText("");
        String[] parts = chat.split("\u00a7");
        boolean first = true;
        for (String part : parts) {
            if (first) {
                first = false;
                newChat.func_150258_a(part);
                continue;
            }
            IChatComponent last = (IChatComponent)newChat.func_150253_a().get(newChat.func_150253_a().size() - 1);
            EnumChatFormatting format = null;
            for (EnumChatFormatting formats : EnumChatFormatting.values()) {
                if (!String.valueOf(formats.func_96298_a()).equals(part.substring(0, 1))) continue;
                format = formats;
            }
            if (format != null) {
                ChatComponentText chat1 = new ChatComponentText(part.substring(1));
                if (format.equals((Object)EnumChatFormatting.RESET)) {
                    chat1.func_150256_b().func_150238_a(EnumChatFormatting.WHITE);
                    chat1.func_150256_b().func_150227_a(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150217_b(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150237_e(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150225_c(Boolean.valueOf(false));
                    chat1.func_150256_b().func_150228_d(Boolean.valueOf(false));
                } else {
                    chat1.func_150255_a(last.func_150256_b().func_150206_m());
                }
                if (format.func_96302_c()) {
                    chat1.func_150256_b().func_150238_a(format);
                }
                if (format.equals((Object)EnumChatFormatting.BOLD)) {
                    chat1.func_150256_b().func_150227_a(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.ITALIC)) {
                    chat1.func_150256_b().func_150217_b(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.UNDERLINE)) {
                    chat1.func_150256_b().func_150228_d(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.OBFUSCATED)) {
                    chat1.func_150256_b().func_150237_e(Boolean.valueOf(true));
                }
                if (format.equals((Object)EnumChatFormatting.STRIKETHROUGH)) {
                    chat1.func_150256_b().func_150225_c(Boolean.valueOf(true));
                }
                newChat.func_150257_a((IChatComponent)chat1);
                continue;
            }
            last.func_150258_a("\u00a7" + part);
        }
        return newChat;
    }

    public static IChatComponent subComponent(IChatComponent chat, int index) {
        ChatComponentText result = new ChatComponentText("");
        int pos = 0;
        boolean found = false;
        for (IChatComponent ichat : ChatComponentUtils.getTypeSafeIterable(chat)) {
            if (!ichat.func_150253_a().isEmpty()) continue;
            String text = ichat.func_150261_e();
            if (text.length() + pos >= index) {
                if (found) {
                    result.func_150257_a(ichat);
                } else {
                    found = true;
                    ChatComponentText local = new ChatComponentText(text.substring(index - pos));
                    local.func_150255_a(ichat.func_150256_b().func_150206_m());
                    result.func_150257_a((IChatComponent)local);
                }
            }
            pos += text.length();
        }
        return result;
    }

    public static IChatComponent subComponent(IChatComponent chat, int start, int end) {
        ChatComponentText result = new ChatComponentText("");
        int pos = start;
        Iterator iter = ChatComponentStyle.func_150262_a((Iterable)ChatComponentUtils.subComponent(chat, start).func_150253_a());
        while (iter.hasNext()) {
            IChatComponent ichat = (IChatComponent)iter.next();
            if (!ichat.func_150253_a().isEmpty()) continue;
            String text = ichat.func_150261_e();
            if (pos + text.length() >= end) {
                ChatComponentText local = new ChatComponentText(text.substring(0, end - pos));
                local.func_150256_b().func_150221_a(chat.func_150256_b().func_150206_m());
                result.func_150257_a((IChatComponent)local);
                break;
            }
            result.func_150257_a(ichat);
            pos += text.length();
        }
        return result;
    }

    public static Iterable<IChatComponent> getTypeSafeIterable(IChatComponent component) {
        return component;
    }
}

