/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.threads;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.util.TabbyChatUtils;
import net.minecraft.client.resources.I18n;

public class BackgroundUpdateCheck
extends Thread {
    @Override
    public void run() {
        int i;
        String newest = TabbyChat.getNewestVersion();
        String current = "1.12.2";
        boolean updateFound = false;
        if (!((Boolean)TabbyChat.generalSettings.tabbyChatEnable.getValue()).booleanValue() || !((Boolean)TabbyChat.generalSettings.updateCheckEnable.getValue()).booleanValue() || newest.equalsIgnoreCase("invalid")) {
            return;
        }
        String[] newVersionString = newest.split("\\.");
        String[] versionString = current.split("\\.");
        int[] newVersion = new int[newVersionString.length];
        int[] version = new int[versionString.length];
        for (i = 0; i < newVersion.length; ++i) {
            newVersion[i] = TabbyChatUtils.parseInteger(newVersionString[i], Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        }
        for (i = 0; i < version.length; ++i) {
            version[i] = TabbyChatUtils.parseInteger(versionString[i], Integer.MIN_VALUE, Integer.MAX_VALUE, 0);
        }
        for (i = 0; i < Math.min(version.length, newVersion.length); ++i) {
            if (version[i] < newVersion[i]) {
                updateFound = true;
                break;
            }
            if (version[i] > newVersion[i]) break;
        }
        if (updateFound) {
            TabbyChatUtils.log.info("Update Found!");
            String updateReport = "\u00a77" + I18n.func_135052_a((String)"messages.update1", (Object[])new Object[0]) + ' ' + current + I18n.func_135052_a((String)"messages.update2", (Object[])new Object[0]) + ' ' + newest + ") " + I18n.func_135052_a((String)"messages.update3", (Object[])new Object[0]) + "\u00a7r";
            TabbyChat.printMessageToChat(updateReport);
        }
    }
}

