/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.threads;

import acs.tabbychat.core.TabbyChat;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraftforge.client.ClientCommandHandler;
import org.apache.commons.lang3.StringUtils;

public class BackgroundChatThread
extends Thread {
    String sendChat;
    String knownPrefix;
    final Minecraft mc;

    public BackgroundChatThread(String _send) {
        this.sendChat = _send;
        this.mc = Minecraft.func_71410_x();
    }

    public BackgroundChatThread(String _send, String _prefix) {
        this.sendChat = _send;
        this.knownPrefix = _prefix;
        this.mc = Minecraft.func_71410_x();
    }

    @Override
    public synchronized void run() {
        int start;
        String[] toSplit;
        this.mc.field_71456_v.func_146158_b().func_146239_a(this.sendChat);
        String cmdPrefix = "";
        if (this.knownPrefix != null && this.sendChat.startsWith(this.knownPrefix)) {
            cmdPrefix = this.knownPrefix.trim() + " ";
            this.sendChat = this.sendChat.substring(this.knownPrefix.length()).trim();
            toSplit = this.sendChat.split(" ");
            start = 0;
        } else {
            toSplit = this.sendChat.split(" ");
            start = 0;
            if (toSplit.length > 0 && toSplit[0].startsWith("/")) {
                if (toSplit[0].startsWith("/msg")) {
                    cmdPrefix = toSplit[0] + " " + toSplit[1] + " ";
                    start = 2;
                } else if (toSplit[0].startsWith("/fmsg") && toSplit.length > 1) {
                    if (!toSplit[1].endsWith("bind")) {
                        String[] fShipNameArray = this.sendChat.split("\"");
                        if (fShipNameArray.length > 1) {
                            cmdPrefix = toSplit[0] + " \"" + fShipNameArray[1] + "\" ";
                            start = 2 + StringUtils.countMatches((CharSequence)fShipNameArray[1], (CharSequence)" ");
                        } else {
                            cmdPrefix = "/fmsg ";
                            start = 1;
                        }
                    }
                } else if (!toSplit[0].trim().equals("/")) {
                    cmdPrefix = toSplit[0] + " ";
                    start = 1;
                }
            }
        }
        this.sendChat(start, toSplit, cmdPrefix);
    }

    private void sendChat(int start, String[] toSplit, String cmdPrefix) {
        int suffix = cmdPrefix.length();
        StringBuilder sendPart = new StringBuilder(119);
        for (int word = start; word < toSplit.length; ++word) {
            if (sendPart.length() + toSplit[word].length() + suffix > 100) {
                this.mc.field_71439_g.func_71165_d(cmdPrefix + sendPart.toString().trim());
                try {
                    Thread.sleep(Integer.parseInt((String)TabbyChat.advancedSettings.multiChatDelay.getValue()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                sendPart = new StringBuilder(119);
                if (toSplit[word].startsWith("/")) {
                    sendPart.append("_");
                }
            }
            sendPart.append(toSplit[word]).append(" ");
        }
        if (sendPart.length() != 0 || cmdPrefix.length() != 0) {
            String message = cmdPrefix + sendPart.toString().trim();
            if (ClientCommandHandler.instance.func_71556_a((ICommandSender)this.mc.field_71439_g, message = ChatAllowedCharacters.func_71565_a((String)message)) == 1) {
                return;
            }
            this.mc.field_71439_g.func_71165_d(message);
        }
    }
}

