/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings.files;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.lang3.tuple.Pair;

public class TCSettingsAdvancedFile {
    private final File settingsFile = new File(TabbyChatUtils.getTabbyChatDir(), "advanced.cfg");
    private final String chatScrollHistoryPropertyName = "chatScrollHistory";
    private final String maxLengthChannelNamePropertyName = "maxLengthChannelName";
    private final String anchoredTopPropertyName = "chatbox.anchoredTop";
    private final String convertUnicodeTextPropertyName = "convertunicodetext";
    private final String multiChatDelayPropertyName = "multiChatDelay";
    private final String chatBoxHeightPropertyName = "chatbox.height";
    private final String chatBoxUnfocHeightPropertyName = "chatBoxUnfocHeight";
    private final String chatBoxYPropertyName = "chatbox.y";
    private final String chatBoxXPropertyName = "chatbox.x";
    private final String textIgnoreOpacityPropertyName = "textignoreopacity";
    private final String chatBoxWidthPropertyName = "chatbox.width";
    private final String chatFadeTicksPropertyName = "chatFadeTicks";
    private final String pinnedPropertyName = "pinchatinterface";
    public int chatScrollHistory = 100;
    public int maxLengthChannelName = 10;
    public boolean anchoredTop = false;
    public boolean convertUnicodeText = false;
    public int multiChatDelay = 500;
    public int chatBoxHeight = 180;
    public float chatBoxUnfocHeight = 50.0f;
    public int chatBoxY = -36;
    public int chatBoxX = 0;
    public boolean textIgnoreOpacity = true;
    public int chatBoxWidth = 320;
    public float chatFadeTicks = 200.0f;
    public boolean pinned = false;

    public void loadSettingsFile() {
        Properties settingsTable = new Properties();
        if (!this.settingsFile.exists()) {
            return;
        }
        try (FileInputStream fInStream = new FileInputStream(this.settingsFile);
             BufferedInputStream bInStream = new BufferedInputStream(fInStream);){
            settingsTable.load(bInStream);
        }
        catch (Exception e) {
            TabbyChat.printException("Error while reading settings from file '" + this.settingsFile + "'", e);
        }
        try {
            this.chatScrollHistory = Integer.parseInt(settingsTable.getProperty("chatScrollHistory"));
            this.maxLengthChannelName = Integer.parseInt(settingsTable.getProperty("maxLengthChannelName"));
            this.anchoredTop = Boolean.parseBoolean(settingsTable.getProperty("chatbox.anchoredTop"));
            this.convertUnicodeText = Boolean.parseBoolean(settingsTable.getProperty("convertunicodetext"));
            this.multiChatDelay = Integer.parseInt(settingsTable.getProperty("multiChatDelay"));
            this.chatBoxHeight = TabbyChatUtils.parseInteger(settingsTable.getProperty("chatbox.height"), ChatBox.absMinH, 10000, 180);
            this.chatBoxUnfocHeight = Float.parseFloat(settingsTable.getProperty("chatBoxUnfocHeight"));
            this.chatBoxX = TabbyChatUtils.parseInteger(settingsTable.getProperty("chatbox.x"), ChatBox.absMinX, 10000, ChatBox.absMinX);
            this.chatBoxY = TabbyChatUtils.parseInteger(settingsTable.getProperty("chatbox.y"), -10000, ChatBox.absMinY, ChatBox.absMinY);
            this.textIgnoreOpacity = Boolean.parseBoolean(settingsTable.getProperty("textignoreopacity"));
            this.chatBoxWidth = TabbyChatUtils.parseInteger(settingsTable.getProperty("chatbox.width"), ChatBox.absMinW, 10000, 320);
            this.chatFadeTicks = Float.parseFloat(settingsTable.getProperty("chatFadeTicks"));
            this.pinned = Boolean.parseBoolean(settingsTable.getProperty("pinchatinterface"));
        }
        catch (NumberFormatException e) {
            TabbyChatUtils.log.warn("Failed to load (part of) advanced settings, using defaults");
        }
    }

    public void saveSettingsFile() {
        Properties settingsTable = new Properties();
        settingsTable.put("chatScrollHistory", Integer.toString(this.chatScrollHistory));
        settingsTable.put("maxLengthChannelName", Integer.toString(this.maxLengthChannelName));
        settingsTable.put("chatbox.anchoredTop", Boolean.toString(this.anchoredTop));
        settingsTable.put("convertunicodetext", Boolean.toString(this.convertUnicodeText));
        settingsTable.put("multiChatDelay", Integer.toString(this.multiChatDelay));
        settingsTable.put("chatbox.height", Integer.toString(this.chatBoxHeight));
        settingsTable.put("chatBoxUnfocHeight", Float.toString(this.chatBoxUnfocHeight));
        settingsTable.put("chatbox.y", Integer.toString(this.chatBoxY));
        settingsTable.put("chatbox.x", Integer.toString(this.chatBoxX));
        settingsTable.put("textignoreopacity", Boolean.toString(this.textIgnoreOpacity));
        settingsTable.put("chatbox.width", Integer.toString(this.chatBoxWidth));
        settingsTable.put("chatFadeTicks", Float.toString(this.chatFadeTicks));
        settingsTable.put("pinchatinterface", Boolean.toString(this.pinned));
        TabbyChatUtils.saveProperties(settingsTable, this.settingsFile, (Pair<String, String>)Pair.of((Object)"Created parent dir for advanced tabbychat settings", (Object)"Failed to create parent directory for advanced tabbychat settings"), "settings.advanced");
    }
}

