/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings;

import acs.tabbychat.settings.ITCSetting;
import acs.tabbychat.settings.TCSetting;
import acs.tabbychat.util.TabbyChatUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class TCSettingSlider
extends TCSetting<Float> {
    private final int buttonOffColor = 0x44FFFFFF;
    public String units = "%";
    protected float minValue;
    protected float maxValue;
    protected float sliderValue;
    private int sliderX;
    private boolean dragging = false;

    public TCSettingSlider(float theSetting, String theProperty, String theCategory, int theID, float minVal, float maxVal) {
        super(Float.valueOf(theSetting), theProperty, theCategory, theID);
        this.width(100);
        this.height(11);
        this.minValue = minVal;
        this.maxValue = maxVal;
    }

    @Override
    public void clear() {
        super.clear();
        this.calculateSliderValue();
    }

    @Override
    public void setValue(Float updateVal) {
        this.value = updateVal;
        this.tempValue = updateVal;
        this.calculateSliderValue();
    }

    public void calculateSliderValue() {
        this.sliderValue = (((Float)this.tempValue).floatValue() - this.minValue) / (this.maxValue - this.minValue);
    }

    @Override
    public void func_146112_a(Minecraft par1, int cursorX, int cursorY) {
        int fgcolor = -1717526368;
        if (!this.field_146124_l) {
            fgcolor = 0x66A0A0A0;
        } else if (this.hovered(cursorX, cursorY).booleanValue()) {
            fgcolor = -1711276128;
            if (this.dragging) {
                this.sliderX = cursorX - 1;
                this.sliderValue = (float)(this.sliderX - (this.x() + 1)) / (float)(this.width() - 5);
                if (this.sliderValue < 0.0f) {
                    this.sliderValue = 0.0f;
                } else if (this.sliderValue > 1.0f) {
                    this.sliderValue = 1.0f;
                }
            }
        }
        int labelColor = this.field_146124_l ? 0xFFFFFF : 0x666666;
        int buttonColor = this.field_146124_l ? this.buttonColor : this.buttonOffColor;
        Gui.func_73734_a((int)this.x(), (int)(this.y() + 1), (int)(this.x() + 1), (int)(this.y() + this.height() - 1), (int)fgcolor);
        Gui.func_73734_a((int)(this.x() + 1), (int)this.y(), (int)(this.x() + this.width() - 1), (int)(this.y() + 1), (int)fgcolor);
        Gui.func_73734_a((int)(this.x() + 1), (int)(this.y() + this.height() - 1), (int)(this.x() + this.width() - 1), (int)(this.y() + this.height()), (int)fgcolor);
        Gui.func_73734_a((int)(this.x() + this.width() - 1), (int)(this.y() + 1), (int)(this.x() + this.width()), (int)(this.y() + this.height() - 1), (int)fgcolor);
        Gui.func_73734_a((int)(this.x() + 1), (int)(this.y() + 1), (int)(this.x() + this.width() - 1), (int)(this.y() + this.height() - 1), (int)-16777216);
        this.sliderX = Math.round(this.sliderValue * (float)(this.width() - 5)) + this.x() + 1;
        Gui.func_73734_a((int)this.sliderX, (int)(this.y() + 1), (int)(this.sliderX + 1), (int)(this.y() + 2), (int)(buttonColor & 0x88FFFFFF));
        Gui.func_73734_a((int)(this.sliderX + 1), (int)(this.y() + 1), (int)(this.sliderX + 2), (int)(this.y() + 2), (int)buttonColor);
        Gui.func_73734_a((int)(this.sliderX + 2), (int)(this.y() + 1), (int)(this.sliderX + 3), (int)(this.y() + 2), (int)(buttonColor & 0x88FFFFFF));
        Gui.func_73734_a((int)this.sliderX, (int)(this.y() + 2), (int)(this.sliderX + 1), (int)(this.y() + this.height() - 2), (int)buttonColor);
        Gui.func_73734_a((int)(this.sliderX + 1), (int)(this.y() + 2), (int)(this.sliderX + 2), (int)(this.y() + this.height() - 2), (int)(buttonColor & 0x88FFFFFF));
        Gui.func_73734_a((int)(this.sliderX + 2), (int)(this.y() + 2), (int)(this.sliderX + 3), (int)(this.y() + this.height() - 2), (int)buttonColor);
        Gui.func_73734_a((int)this.sliderX, (int)(this.y() + this.height() - 2), (int)(this.sliderX + 1), (int)(this.y() + this.height() - 1), (int)(buttonColor & 0x88FFFFFF));
        Gui.func_73734_a((int)(this.sliderX + 1), (int)(this.y() + this.height() - 2), (int)(this.sliderX + 2), (int)(this.y() + this.height() - 1), (int)buttonColor);
        Gui.func_73734_a((int)(this.sliderX + 2), (int)(this.y() + this.height() - 2), (int)(this.sliderX + 3), (int)(this.y() + this.height() - 1), (int)(buttonColor & 0x88FFFFFF));
        int valCenter = this.sliderValue < 0.5f ? Math.round(0.7f * (float)this.width()) : Math.round(0.2f * (float)this.width());
        String valLabel = Math.round(this.sliderValue * (this.maxValue - this.minValue) + this.minValue) + this.units;
        this.func_73732_a(TCSettingSlider.mc.field_71466_p, valLabel, valCenter + this.x(), this.y() + 2, buttonColor);
        this.func_73732_a(TCSettingSlider.mc.field_71466_p, this.description, this.labelX + TCSettingSlider.mc.field_71466_p.func_78256_a(this.description) / 2, this.y() + (this.height() - 6) / 2, labelColor);
    }

    @Override
    public Float getTempValue() {
        this.tempValue = Float.valueOf(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
        return (Float)this.tempValue;
    }

    @Override
    public void setTempValue(Float theVal) {
        super.setTempValue(theVal);
        this.calculateSliderValue();
    }

    @Override
    public ITCSetting.TCSettingType getType() {
        return ITCSetting.TCSettingType.SLIDER;
    }

    public void handleMouseInput() {
        int mY;
        if (TCSettingSlider.mc.field_71462_r == null) {
            return;
        }
        int mX = Mouse.getEventX() * TCSettingSlider.mc.field_71462_r.field_146294_l / TCSettingSlider.mc.field_71443_c;
        if (!this.hovered(mX, mY = TCSettingSlider.mc.field_71462_r.field_146295_m - Mouse.getEventY() * TCSettingSlider.mc.field_71462_r.field_146295_m / TCSettingSlider.mc.field_71440_d - 1).booleanValue()) {
            return;
        }
        int var1 = Mouse.getEventDWheel();
        if (var1 != 0) {
            if (var1 > 1) {
                var1 = 3;
            }
            if (var1 < -1) {
                var1 = -3;
            }
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                var1 *= -7;
            }
        }
        this.sliderValue += (float)var1 / 100.0f;
        if (this.sliderValue < 0.0f) {
            this.sliderValue = 0.0f;
        } else if (this.sliderValue > 1.0f) {
            this.sliderValue = 1.0f;
        }
        this.tempValue = Float.valueOf(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
    }

    @Override
    public void mouseClicked(int par1, int par2, int par3) {
        if (par3 == 0 && this.hovered(par1, par2).booleanValue() && this.field_146124_l) {
            this.sliderX = par1 - 1;
            this.sliderValue = (float)(this.sliderX - (this.x() + 1)) / (float)(this.width() - 5);
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            } else if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            if (!this.dragging) {
                this.dragging = true;
            }
        }
    }

    public void func_146118_a(int par1, int par2) {
        this.dragging = false;
    }

    @Override
    public void reset() {
        super.reset();
        this.calculateSliderValue();
    }

    @Override
    public void save() {
        this.tempValue = Float.valueOf(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
        super.save();
    }

    @Override
    public void setCleanValue(Float updateVal) {
        if (updateVal == null) {
            this.clear();
        } else {
            this.value = TabbyChatUtils.median(this.minValue, this.maxValue, updateVal.floatValue());
        }
    }

    public void setRange(float theMin, float theMax) {
        this.minValue = theMin;
        this.maxValue = theMax;
        this.calculateSliderValue();
    }
}

