/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.settings;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.util.TabbyChatUtils;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class TCChatFilter {
    public boolean inverseMatch = false;
    public boolean caseSensitive = false;
    public boolean highlightBool = false;
    public boolean audioNotificationBool = false;
    public boolean sendToTabBool = false;
    public boolean sendToAllTabs = false;
    public boolean removeMatches = false;
    public boolean globalFilter = true;
    public ColorCodeEnum highlightColor = ColorCodeEnum.YELLOW;
    public FormatCodeEnum highlightFormat = FormatCodeEnum.BOLD;
    public NotificationSoundEnum audioNotificationSound = NotificationSoundEnum.ORB;
    public String sendToTabName = "";
    public String expressionString = ".*";
    public Pattern expressionPattern = Pattern.compile(this.expressionString);
    public String filterName;
    private int[] lastMatch;
    private String tabName = null;

    public TCChatFilter(String name) {
        this.filterName = name;
    }

    public TCChatFilter(TCChatFilter orig) {
        this(orig.filterName);
        this.copyFrom(orig);
    }

    public boolean applyFilterToDirtyChat(IChatComponent input) {
        Matcher findFilterMatches = this.expressionPattern.matcher(EnumChatFormatting.func_110646_a((String)input.func_150260_c()));
        boolean foundMatch = false;
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (findFilterMatches.find()) {
            foundMatch = true;
            if (!this.highlightBool) break;
            list.add(findFilterMatches.start());
            list.add(findFilterMatches.end());
        }
        this.lastMatch = list.stream().mapToInt(value -> value).toArray();
        if (this.sendToTabBool && !this.sendToAllTabs) {
            if (this.inverseMatch) {
                this.tabName = this.sendToTabName;
            } else if (this.sendToTabName.startsWith("%")) {
                int group = TabbyChatUtils.parseInteger(this.sendToTabName.substring(1));
                if (foundMatch && group >= 0 && findFilterMatches.groupCount() >= group) {
                    this.tabName = findFilterMatches.group(group);
                    if (this.tabName == null) {
                        this.tabName = this.filterName;
                    }
                } else {
                    this.tabName = this.filterName;
                }
            } else {
                this.tabName = this.sendToTabName;
            }
        } else {
            this.tabName = null;
        }
        return !foundMatch && this.inverseMatch || foundMatch && !this.inverseMatch;
    }

    public void audioNotification() {
        Minecraft.func_71410_x().field_71439_g.func_85030_a(this.audioNotificationSound.file(), 1.0f, 1.0f);
    }

    public void compilePattern() {
        try {
            this.expressionPattern = this.caseSensitive ? Pattern.compile(this.expressionString) : Pattern.compile(this.expressionString, 2);
        }
        catch (PatternSyntaxException e) {
            TabbyChat.printMessageToChat("Invalid expression entered for filter '" + this.filterName + "', resetting to default.");
            this.expressionString = ".*";
            this.expressionPattern = Pattern.compile(this.expressionString);
        }
    }

    public void compilePattern(String newExpression) {
        this.expressionString = newExpression;
        this.compilePattern();
    }

    public void copyFrom(TCChatFilter orig) {
        this.filterName = orig.filterName;
        this.inverseMatch = orig.inverseMatch;
        this.caseSensitive = orig.caseSensitive;
        this.highlightBool = orig.highlightBool;
        this.audioNotificationBool = orig.audioNotificationBool;
        this.sendToTabBool = orig.sendToTabBool;
        this.sendToAllTabs = orig.sendToAllTabs;
        this.removeMatches = orig.removeMatches;
        this.highlightColor = orig.highlightColor;
        this.highlightFormat = orig.highlightFormat;
        this.audioNotificationSound = orig.audioNotificationSound;
        this.sendToTabName = orig.sendToTabName;
        this.expressionString = orig.expressionString;
        this.globalFilter = orig.globalFilter;
        this.compilePattern();
    }

    public int[] getLastMatch() {
        int[] tmp = this.lastMatch;
        this.lastMatch = null;
        return tmp;
    }

    public Properties getProperties() {
        Properties myProps = new Properties();
        myProps.put("filterName", this.filterName);
        myProps.put("inverseMatch", (Object)this.inverseMatch);
        myProps.put("caseSensitive", (Object)this.caseSensitive);
        myProps.put("highlightBool", (Object)this.highlightBool);
        myProps.put("audioNotificationBool", (Object)this.audioNotificationBool);
        myProps.put("sendToTabBool", (Object)this.sendToTabBool);
        myProps.put("sendToAllTabs", (Object)this.sendToAllTabs);
        myProps.put("removeMatches", (Object)this.removeMatches);
        myProps.put("highlightColor", this.highlightColor.name());
        myProps.put("highlightFormat", this.highlightFormat.name());
        myProps.put("audioNotificationSound", this.audioNotificationSound.name());
        myProps.put("sendToTabName", this.sendToTabName);
        myProps.put("expressionString", this.expressionString);
        myProps.put("globalFilter", (Object)this.globalFilter);
        return myProps;
    }

    public String getTabName() {
        String tmp = this.tabName;
        this.tabName = null;
        return tmp;
    }
}

