/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.jazzy;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.jazzy.TCSpellCheckListener;
import acs.tabbychat.shadow.com.swabunga.spell.event.SpellCheckEvent;
import acs.tabbychat.shadow.com.swabunga.spell.event.StringWordTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;

public class TCSpellCheckManager {
    private static TCSpellCheckManager instance = null;
    private final ReentrantReadWriteLock errorLock = new ReentrantReadWriteLock();
    private final Lock errorReadLock = this.errorLock.readLock();
    private final Lock errorWriteLock = this.errorLock.writeLock();
    private final HashMap<Integer, String> errorCache = new HashMap();
    private TCSpellCheckListener listener;
    private String lastAttemptedLocale;

    private TCSpellCheckManager() {
        this.reloadDictionaries();
    }

    public static TCSpellCheckManager getInstance() {
        if (instance == null) {
            instance = new TCSpellCheckManager();
        }
        return instance;
    }

    public void addToIgnoredWords(String word) {
        if (!this.listener.spellCheck.isIgnored(word)) {
            this.listener.spellCheck.ignoreAll(word);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawErrors(GuiScreen screen, List<GuiTextField> inputFields) {
        ArrayList<String> inputCache = new ArrayList<String>();
        int activeFields = 0;
        for (GuiTextField field : inputFields) {
            if (field.func_146176_q()) {
                ++activeFields;
            }
            inputCache.add(field.func_146179_b());
        }
        if (activeFields == 0) {
            return;
        }
        this.errorReadLock.lock();
        try {
            for (Map.Entry<Integer, String> error : this.errorCache.entrySet()) {
                int width;
                ListIterator inputs = inputCache.listIterator(activeFields);
                if (!inputs.hasPrevious()) {
                    break;
                }
                String input = (String)inputs.previous();
                if (input.length() == 0) {
                    break;
                }
                int y = screen.field_146295_m - 4 - 12 * (activeFields - 1);
                int x = 4;
                int wordIndex = error.getKey();
                int errLength = error.getValue().length();
                while (wordIndex >= input.length()) {
                    wordIndex -= input.length();
                    y += 12;
                    if (!inputs.hasPrevious()) {
                        return;
                    }
                    input = (String)inputs.previous();
                }
                if (wordIndex + errLength > input.length()) {
                    width = Minecraft.func_71410_x().field_71466_p.func_78256_a(input.substring(wordIndex));
                    this.drawUnderline(screen, x += Minecraft.func_71410_x().field_71466_p.func_78256_a(input.substring(0, wordIndex)), y, width);
                    if (inputs.hasPrevious()) {
                        int remainder = errLength - input.length() + wordIndex;
                        input = (String)inputs.previous();
                        if (input.length() == 0) continue;
                        if (remainder > input.length()) {
                            return;
                        }
                        y += 12;
                        x = 4;
                        width = Minecraft.func_71410_x().field_71466_p.func_78256_a(input.substring(0, remainder));
                    }
                } else {
                    x += Minecraft.func_71410_x().field_71466_p.func_78256_a(input.substring(0, wordIndex));
                    width = Minecraft.func_71410_x().field_71466_p.func_78256_a(error.getValue());
                }
                this.drawUnderline(screen, x, y, width);
            }
        }
        finally {
            this.errorReadLock.unlock();
        }
    }

    private void drawUnderline(GuiScreen screen, int x, int y, int width) {
        int next = x + 1;
        while (next - x < width) {
            Gui.func_73734_a((int)(next - 1), (int)y, (int)next, (int)(y + 1), (int)-1426128896);
            next += 2;
        }
    }

    protected void handleListenerEvent(SpellCheckEvent event) {
        this.errorWriteLock.lock();
        try {
            this.errorCache.put(event.getWordContextPosition(), event.getInvalidWord());
        }
        finally {
            this.errorWriteLock.unlock();
        }
    }

    public boolean loadLocaleDictionary() {
        File localeDict = new File(ITCSettingsGUI.tabbyChatDir, Minecraft.func_71410_x().field_71474_y.field_74363_ab + ".dic");
        if (localeDict.canRead()) {
            this.listener = new TCSpellCheckListener(localeDict);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUserDictionary() {
        File userDict = new File(ITCSettingsGUI.tabbyChatDir, "user.dic");
        BufferedReader in = null;
        if (userDict.canRead()) {
            try {
                String word;
                in = new BufferedReader(new FileReader(userDict));
                while ((word = in.readLine()) != null) {
                    this.listener.spellCheck.ignoreAll(word);
                }
            }
            catch (Exception e) {
                TabbyChat.printException("Unable to load user dictionary for spell checking", e);
            }
            finally {
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    public void reloadDictionaries() {
        if (!this.loadLocaleDictionary()) {
            this.listener = new TCSpellCheckListener();
        }
        this.lastAttemptedLocale = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        this.loadUserDictionary();
    }

    public void update(List<GuiTextField> inputFields) {
        if (!Objects.equals(this.lastAttemptedLocale, Minecraft.func_71410_x().field_71474_y.field_74363_ab)) {
            this.reloadDictionaries();
        }
        this.errorWriteLock.lock();
        try {
            this.errorCache.clear();
        }
        finally {
            this.errorWriteLock.unlock();
        }
        StringBuilder inputCache = new StringBuilder();
        for (GuiTextField inputField : inputFields) {
            if (!inputField.func_146176_q()) continue;
            inputCache.insert(0, inputField.func_146179_b());
        }
        this.listener.checkSpelling(inputCache.toString());
    }

    public List<String> getSuggestions(String word, int threshold) {
        return this.listener.spellCheck.getSuggestions(word, threshold);
    }

    public boolean isSpelledCorrectly(String word) {
        return this.listener.spellCheck.checkSpelling(new StringWordTokenizer(word)) == -1;
    }
}

