/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.jazzy;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.shadow.com.swabunga.spell.engine.SpellDictionaryHashMap;
import acs.tabbychat.shadow.com.swabunga.spell.event.SpellCheckEvent;
import acs.tabbychat.shadow.com.swabunga.spell.event.SpellCheckListener;
import acs.tabbychat.shadow.com.swabunga.spell.event.SpellChecker;
import acs.tabbychat.shadow.com.swabunga.spell.event.StringWordTokenizer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class TCSpellCheckListener
implements SpellCheckListener {
    protected SpellChecker spellCheck = null;

    public TCSpellCheckListener() {
        try {
            InputStream in = TCSpellCheckListener.class.getResourceAsStream("/english.0");
            if (in != null) {
                SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(new InputStreamReader(in));
                this.spellCheck = new SpellChecker(dictionary);
                this.spellCheck.addSpellCheckListener(this);
            }
        }
        catch (IOException e) {
            TabbyChat.printException("", e);
        }
    }

    public TCSpellCheckListener(File dict) {
        try {
            SpellDictionaryHashMap dictionary = new SpellDictionaryHashMap(dict);
            this.spellCheck = new SpellChecker(dictionary);
            this.spellCheck.addSpellCheckListener(this);
        }
        catch (Exception e) {
            TabbyChat.printException("Error instantiating spell checker", e);
        }
    }

    @Override
    public void spellingError(SpellCheckEvent event) {
        TabbyChat.spellChecker.handleListenerEvent(event);
    }

    public void checkSpelling(String line) {
        this.spellCheck.checkSpelling(new StringWordTokenizer(line));
    }
}

