/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui.context;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.context.ChatContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;

public class ContextSpellingSuggestion
extends ChatContext {
    private String[] suggestions;
    private String title;

    @Override
    public void onClicked() {
    }

    @Override
    public String getDisplayString() {
        return this.title;
    }

    @Override
    public ResourceLocation getDisplayIcon() {
        return null;
    }

    @Override
    public List<ChatContext> getChildren() {
        ArrayList<ChatContext> list = new ArrayList<ChatContext>();
        if (this.suggestions == null) {
            return null;
        }
        for (String word : this.suggestions) {
            list.add(this.makeBaby(word));
        }
        return list;
    }

    @Override
    public boolean isPositionValid(int x, int y) {
        this.title = "Spelling";
        GuiTextField text = this.getMenu().screen.field_146415_a;
        int start = text.func_146187_c(-1);
        int end = text.func_146187_c(1);
        String word = text.func_146179_b().substring(start, end);
        if (!word.isEmpty() && !TabbyChat.spellChecker.isSpelledCorrectly(word)) {
            List<String> suggs = TabbyChat.spellChecker.getSuggestions(word, 0);
            this.suggestions = this.objectToStringArray(suggs.toArray());
            if (this.suggestions.length == 0) {
                this.title = "No Suggestions";
                return false;
            }
            return true;
        }
        this.suggestions = null;
        return false;
    }

    private String[] objectToStringArray(Object[] object) {
        String[] array = new String[object.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = object[i].toString();
        }
        return array;
    }

    @Override
    public ChatContext.Behavior getDisabledBehavior() {
        if (this.suggestions == null) {
            return ChatContext.Behavior.HIDE;
        }
        return ChatContext.Behavior.GRAY;
    }

    private ChatContext makeBaby(final String word) {
        return new ChatContext(){

            @Override
            public void onClicked() {
                GuiTextField field = this.getMenu().screen.field_146415_a;
                int start = field.func_146187_c(-1);
                int end = field.func_146187_c(1);
                field.func_146190_e(start);
                field.func_146199_i(end);
                String sel = field.func_146207_c();
                char pref = sel.charAt(0);
                char suff = sel.charAt(sel.length() - 1);
                if (Character.isLetter(pref)) {
                    pref = '\u0000';
                }
                if (Character.isLetter(suff)) {
                    suff = ' ';
                }
                this.getMenu().screen.field_146415_a.func_146191_b((pref != '\u0000' ? Character.valueOf(pref) : "") + word + suff);
            }

            @Override
            public boolean isPositionValid(int x, int y) {
                return true;
            }

            @Override
            public String getDisplayString() {
                return word;
            }

            @Override
            public ResourceLocation getDisplayIcon() {
                return null;
            }

            @Override
            public ChatContext.Behavior getDisabledBehavior() {
                return ChatContext.Behavior.GRAY;
            }

            @Override
            public List<ChatContext> getChildren() {
                return null;
            }
        };
    }
}

