/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui.context;

import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.context.ChatContext;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;

public class ChatContextMenu
extends Gui {
    private static final List<ChatContext> registered = new ArrayList<ChatContext>();
    public ChatContext parent;
    public GuiChatTC screen;
    public int xPos;
    public int yPos;
    public int width;
    public int height;
    protected List<ChatContext> items;
    private final Minecraft mc = Minecraft.func_71410_x();

    public ChatContextMenu(GuiChatTC chat, int x, int y) {
        this.items = registered;
        this.screen = chat;
        this.setup(chat, x, y);
    }

    ChatContextMenu(ChatContext parent, int x, int y, List<ChatContext> items) {
        this.parent = parent;
        this.items = items;
        this.screen = parent.getMenu().screen;
        this.setup(this.screen, x, y);
    }

    public static void addContext(ChatContext item) {
        registered.add(item);
    }

    public static void insertContextAtPos(int pos, ChatContext item) {
        registered.add(pos, item);
    }

    public static void removeContext(ChatContext item) {
        registered.remove((Object)item);
    }

    public static void removeContext(int pos) {
        registered.remove(pos);
    }

    public static List<ChatContext> getRegisteredMenus() {
        return registered;
    }

    private void setup(GuiChatTC chat, int x, int y) {
        ScaledResolution sr = new ScaledResolution(this.mc, this.mc.field_71443_c, this.mc.field_71440_d);
        this.xPos = x;
        this.yPos = y;
        this.width = 100;
        if (x > sr.func_78326_a() - this.width) {
            this.xPos = this.parent == null ? (this.xPos -= this.width) : (this.xPos -= this.width * 2);
        }
        ArrayList<ChatContext> visible = new ArrayList<ChatContext>();
        for (ChatContext item : this.items) {
            item.menu = this;
            item.field_146124_l = item.isPositionValid(this.xPos, this.yPos);
            if (!item.field_146124_l && item.getDisabledBehavior() == ChatContext.Behavior.HIDE) continue;
            visible.add(item);
        }
        this.height = visible.size() * 15;
        if (this.yPos + this.height > sr.func_78328_b()) {
            this.yPos -= this.height;
            if (this.parent != null) {
                this.yPos += 15;
            }
        }
        if (this.yPos < 0) {
            this.yPos = 0;
        }
        int i = 0;
        for (ChatContext item : visible) {
            item.field_146127_k = i;
            item.field_146128_h = this.xPos;
            item.field_146129_i = this.yPos + i * 15;
            ++i;
        }
    }

    public void drawMenu(int x, int y) {
        Point scaled = ChatBox.scaleMouseCoords(x, y, true);
        for (ChatContext item : this.items) {
            if (!item.field_146124_l && item.getDisabledBehavior() == ChatContext.Behavior.HIDE || scaled == null) continue;
            item.func_146112_a(this.mc, scaled.x, scaled.y);
        }
    }

    public boolean mouseClicked(int mouseX, int mouseY) {
        for (ChatContext item : this.items) {
            if (!item.field_146124_l || !item.isHoveredWithChildren(mouseX, mouseY)) continue;
            return item.mouseClicked(mouseX, mouseY);
        }
        return false;
    }

    public void buttonClicked(ChatContext item) {
        item.onClicked();
    }

    public boolean isCursorOver(int x, int y) {
        boolean children = false;
        for (ChatContext cont : this.items) {
            if (cont.isHoveredWithChildren(x, y) && cont.children != null) {
                children = cont.children.isCursorOver(x, y);
            }
            if (!children) continue;
            break;
        }
        return x > this.xPos && x < this.xPos + this.width && y > this.yPos && y < this.yPos + this.height || children;
    }
}

