/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingList;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;

public class TCSettingsSpelling
extends TCSettingsGUI {
    private static final int SPELL_CHECK_ENABLE = 9108;
    private static final int ADD_WORD = 9502;
    private static final int REMOVE_WORD = 9503;
    private static final int CLEAR_WORDS = 9504;
    private static final int NEXT = 9506;
    private static final int PREV = 9507;
    private static final int OPEN = 9508;
    private static final int RELOAD = 9509;
    public TCSettingBool spellCheckEnable;
    private GuiTextField wordInput;
    private final PrefsButton addWord = new PrefsButton(9502, 0, 0, 15, 12, ">");
    private final PrefsButton removeWords = new PrefsButton(9503, 0, 0, 15, 12, "<");
    private final PrefsButton clearWords = new PrefsButton(9504, 0, 0, 15, 12, "<<");
    private final PrefsButton next = new PrefsButton(9506, 0, 0, 15, 12, "->");
    private final PrefsButton prev = new PrefsButton(9507, 0, 0, 15, 12, "<-");
    private final PrefsButton open = new PrefsButton(9508, 0, 0, 85, 15, "");
    private final PrefsButton reload = new PrefsButton(9509, 0, 0, 85, 15, "");
    private final File dictionary = new File(tabbyChatDir, "dictionary.txt");
    public TCSettingList spellingList = new TCSettingList(this.dictionary);

    public TCSettingsSpelling(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.spelling";
        this.spellCheckEnable = new TCSettingBool(true, "spellCheckEnable", this.propertyPrefix, 9108);
        this.name = I18n.func_135052_a((String)"settings.spelling.name", (Object[])new Object[0]);
        this.settingsFile = new File(tabbyChatDir, "spellcheck.cfg");
        this.bgcolor = 1728034351;
        this.defineDrawableSettings();
    }

    @Override
    public void saveSettingsFile() {
        try {
            this.spellingList.saveEntries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.saveSettingsFile();
    }

    @Override
    public Properties loadSettingsFile() {
        super.loadSettingsFile();
        try {
            if (!this.dictionary.exists()) {
                Files.createDirectories(this.dictionary.getParentFile().toPath(), new FileAttribute[0]);
                Files.createFile(this.dictionary.toPath(), new FileAttribute[0]);
            }
            this.spellingList.loadEntries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void defineDrawableSettings() {
        this.field_146292_n.add(this.spellCheckEnable);
        this.field_146292_n.add(this.addWord);
        this.field_146292_n.add(this.removeWords);
        this.field_146292_n.add(this.clearWords);
        this.field_146292_n.add(this.next);
        this.field_146292_n.add(this.prev);
        this.field_146292_n.add(this.open);
        this.field_146292_n.add(this.reload);
    }

    @Override
    public void initDrawableSettings() {
        int col1x = (this.field_146294_l - 300) / 2 + 55;
        int col2x = this.field_146294_l / 2 + 25;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        this.spellCheckEnable.setButtonLoc(col1x, this.rowY(1));
        this.spellCheckEnable.setLabelLoc(col1x + 19);
        this.spellCheckEnable.buttonColor = buttonColor;
        this.spellingList.x(col2x);
        this.spellingList.y(this.rowY(4));
        this.spellingList.width(100);
        this.spellingList.height(96);
        this.wordInput = new GuiTextField(this.field_146297_k.field_71466_p, col1x, this.rowY(6), 75, 12);
        this.wordInput.func_146205_d(true);
        this.open.field_146126_j = I18n.func_135052_a((String)"settings.spelling.opendictionary", (Object[])new Object[0]);
        this.open.x(col1x);
        this.open.y(this.rowY(10));
        this.reload.field_146126_j = I18n.func_135052_a((String)"settings.spelling.reloaddictionary", (Object[])new Object[0]);
        this.reload.x(col1x);
        this.reload.y(this.rowY(9));
        this.addWord.x(col2x - 25);
        this.addWord.y(this.rowY(5));
        this.removeWords.x(col2x - 25);
        this.removeWords.y(this.rowY(6));
        this.clearWords.x(col2x - 25);
        this.clearWords.y(this.rowY(7));
        this.next.x(col2x + 53);
        this.next.y(this.rowY(10));
        this.prev.x(col2x + 33);
        this.prev.y(this.rowY(10));
    }

    @Override
    public void func_73863_a(int x, int y, float f) {
        int col1x = (this.field_146294_l - 300) / 2 + 55;
        int col2x = this.field_146294_l / 2 + 45;
        super.func_73863_a(x, y, f);
        this.wordInput.func_146194_f();
        this.spellingList.drawList(this.field_146297_k, x, y);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"settings.spelling.userdictionary", (Object[])new Object[0]), col1x, this.rowY(3), 0xFFFFFF);
        this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"book.pageIndicator", (Object[])new Object[]{this.spellingList.getPageNum(), this.spellingList.getTotalPages()}), col2x, this.rowY(3), 0xFFFFFF);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        try {
            this.spellingList.loadEntries();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        this.wordInput.func_146192_a(x, y, button);
        this.spellingList.mouseClicked(x, y, button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        super.func_73869_a(c, i);
        this.wordInput.func_146201_a(c, i);
    }

    @Override
    public void func_146284_a(GuiButton button) {
        switch (button.field_146127_k) {
            case 9502: {
                this.spellingList.addToList(this.wordInput.func_146179_b());
                this.wordInput.func_146180_a("");
                break;
            }
            case 9503: {
                for (TCSettingList.Entry entry : this.spellingList.getSelected()) {
                    entry.remove();
                }
                break;
            }
            case 9504: {
                this.spellingList.clearList();
                break;
            }
            case 9506: {
                this.spellingList.nextPage();
                break;
            }
            case 9507: {
                this.spellingList.previousPage();
                break;
            }
            case 9508: {
                try {
                    if (!Desktop.isDesktopSupported()) break;
                    Desktop.getDesktop().open(this.dictionary);
                }
                catch (IOException iOException) {}
                break;
            }
            case 9509: {
                try {
                    this.spellingList.loadEntries();
                    break;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        super.func_146284_a(button);
    }
}

