/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ITCSettingsGUI;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.ITCSetting;
import acs.tabbychat.settings.NotificationSoundEnum;
import acs.tabbychat.settings.TCChatFilter;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingEnum;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.resources.I18n;

public class TCSettingsFilters
extends TCSettingsGUI {
    private static final int INVERSE_MATCH_ID = 9301;
    private static final int CASE_SENSE_ID = 9302;
    private static final int HIGHLIGHT_BOOL_ID = 9303;
    private static final int HIGHLIGHT_COLOR_ID = 9304;
    private static final int HIGHLIGHT_FORMAT_ID = 9305;
    private static final int AUDIO_NOTIFICATION_BOOL_ID = 9306;
    private static final int AUDIO_NOTIFICATION_ENUM_ID = 9307;
    private static final int PREV_ID = 9308;
    private static final int NEXT_ID = 9309;
    private static final int FILTER_NAME_ID = 9310;
    private static final int SEND_TO_TAB_BOOL_ID = 9311;
    private static final int SEND_TO_TAB_NAME_ID = 9312;
    private static final int SEND_TO_ALL_TABS_ID = 9313;
    private static final int REMOVE_MATCHES_ID = 9314;
    private static final int EXPRESSION_ID = 9315;
    private static final int ADD_ID = 9316;
    private static final int DEL_ID = 9317;
    private static final int GLOBAL_ID = 9318;
    public TCSettingBool inverseMatch;
    public TCSettingBool caseSensitive;
    public TCSettingBool highlightBool;
    public TCSettingEnum highlightColor;
    public TCSettingEnum highlightFormat;
    public TCSettingBool audioNotificationBool;
    public TCSettingEnum audioNotificationSound;
    public TCSettingTextBox filterName;
    public TCSettingBool sendToTabBool;
    public TCSettingTextBox sendToTabName;
    public TCSettingBool sendToAllTabs;
    public TCSettingBool removeMatches;
    public TCSettingTextBox expressionString;
    public TCSettingBool globalFilter;
    public TreeMap<Integer, TCChatFilter> filterMap = new TreeMap();
    protected int curFilterId = 0;
    protected TreeMap<Integer, TCChatFilter> tempFilterMap = new TreeMap();
    private final File globalFiltersFile;

    public TCSettingsFilters(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.filters";
        this.inverseMatch = new TCSettingBool(false, "inverseMatch", this.propertyPrefix, 9301);
        this.caseSensitive = new TCSettingBool(false, "caseSensitive", this.propertyPrefix, 9302);
        this.highlightBool = new TCSettingBool(true, "highlightBool", this.propertyPrefix, 9303);
        this.highlightColor = new TCSettingEnum(ColorCodeEnum.YELLOW, "highlightColor", this.propertyPrefix, 9304, FormatCodeEnum.ITALIC);
        this.highlightFormat = new TCSettingEnum(FormatCodeEnum.BOLD, "highlightFormat", this.propertyPrefix, 9305, FormatCodeEnum.ITALIC);
        this.audioNotificationBool = new TCSettingBool(false, "audioNotificationBool", this.propertyPrefix, 9306);
        this.audioNotificationSound = new TCSettingEnum(NotificationSoundEnum.ORB, "audioNotificationSound", this.propertyPrefix, 9307);
        this.filterName = new TCSettingTextBox("New", "filterName", this.propertyPrefix, 9310);
        this.sendToTabBool = new TCSettingBool(false, "sendToTabBool", this.propertyPrefix, 9311);
        this.sendToTabName = new TCSettingTextBox("", "sendToTabName", this.propertyPrefix, 9312);
        this.sendToAllTabs = new TCSettingBool(false, "sendToAllTabs", this.propertyPrefix, 9313);
        this.removeMatches = new TCSettingBool(false, "removeMatches", this.propertyPrefix, 9314);
        this.expressionString = new TCSettingTextBox(".*", "expressionString", this.propertyPrefix, 9315);
        this.globalFilter = new TCSettingBool(true, "globalFilter", this.propertyPrefix, 9318);
        this.name = I18n.func_135052_a((String)"settings.filters.name", (Object[])new Object[0]);
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "filters.cfg");
        this.globalFiltersFile = new File(ITCSettingsGUI.tabbyChatDir, "global-filters.cfg");
        this.bgcolor = 1713938216;
        this.filterName.setCharLimit(50);
        this.sendToTabName.setCharLimit(20);
        this.expressionString.setCharLimit(Integer.MAX_VALUE);
        this.defineDrawableSettings();
    }

    @Override
    public void func_146284_a(GuiButton button) {
        this.storeTempFilter();
        switch (button.field_146127_k) {
            case 9316: {
                this.curFilterId = this.tempFilterMap.size() == 0 ? 1 : this.tempFilterMap.lastKey() + 1;
                this.tempFilterMap.put(this.curFilterId, new TCChatFilter("New" + this.curFilterId));
                this.displayCurrentFilter();
                break;
            }
            case 9317: {
                this.tempFilterMap.remove(this.curFilterId);
                if (this.displayNextFilter()) break;
                this.displayPreviousFilter();
                break;
            }
            case 9308: {
                if (this.tempFilterMap.size() <= 0 || this.displayPreviousFilter()) break;
                this.curFilterId = this.tempFilterMap.lastKey();
                this.displayCurrentFilter();
                break;
            }
            case 9309: {
                if (this.tempFilterMap.size() <= 0 || this.displayNextFilter()) break;
                this.curFilterId = this.tempFilterMap.firstKey();
                this.displayCurrentFilter();
            }
        }
        super.func_146284_a(button);
    }

    private void clearDisplay() {
        for (GuiButton drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ITCSetting setting = (ITCSetting)drawable;
            setting.clear();
        }
    }

    @Override
    public void defineDrawableSettings() {
        this.field_146292_n.add(this.filterName);
        this.field_146292_n.add(this.sendToTabBool);
        this.field_146292_n.add(this.sendToAllTabs);
        this.field_146292_n.add(this.sendToTabName);
        this.field_146292_n.add(this.removeMatches);
        this.field_146292_n.add(this.highlightBool);
        this.field_146292_n.add(this.highlightColor);
        this.field_146292_n.add(this.highlightFormat);
        this.field_146292_n.add(this.audioNotificationBool);
        this.field_146292_n.add(this.audioNotificationSound);
        this.field_146292_n.add(this.inverseMatch);
        this.field_146292_n.add(this.caseSensitive);
        this.field_146292_n.add(this.expressionString);
        this.field_146292_n.add(this.globalFilter);
    }

    private void displayCurrentFilter() {
        if (!this.tempFilterMap.containsKey(this.curFilterId)) {
            this.clearDisplay();
        } else {
            Properties displayMe = this.tempFilterMap.get(this.curFilterId).getProperties();
            for (GuiButton drawable : this.field_146292_n) {
                if (!(drawable instanceof ITCSetting)) continue;
                ITCSetting tcDrawable = (ITCSetting)drawable;
                if (tcDrawable instanceof TCSettingEnum) {
                    TCSettingEnum tcDrawableEnum = (TCSettingEnum)tcDrawable;
                    tcDrawableEnum.setTempValueFromProps(displayMe);
                    continue;
                }
                tcDrawable.setTempValue(displayMe.get(tcDrawable.getProperty()));
            }
        }
    }

    private boolean displayNextFilter() {
        return this.displayOtherFilter(true);
    }

    private boolean displayPreviousFilter() {
        return this.displayOtherFilter(false);
    }

    private boolean displayOtherFilter(boolean nextBool) {
        Map.Entry<Integer, TCChatFilter> next = nextBool ? this.tempFilterMap.higherEntry(this.curFilterId) : this.tempFilterMap.lowerEntry(this.curFilterId);
        if (next == null) {
            this.clearDisplay();
            return false;
        }
        Properties displayMe = next.getValue().getProperties();
        for (GuiButton drawable : this.field_146292_n) {
            if (!(drawable instanceof ITCSetting)) continue;
            ITCSetting tcDrawable = (ITCSetting)drawable;
            if (tcDrawable instanceof TCSettingEnum) {
                TCSettingEnum tcEnum = (TCSettingEnum)tcDrawable;
                tcEnum.setTempValueFromProps(displayMe);
                continue;
            }
            tcDrawable.setTempValue(displayMe.get(tcDrawable.getProperty()));
        }
        this.curFilterId = next.getKey();
        return true;
    }

    @Override
    public void initDrawableSettings() {
        int effRight = (this.field_146294_l + 300) / 2;
        int col1x = (this.field_146294_l - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        PrefsButton newButton = new PrefsButton(9316, col1x, (this.field_146295_m + 180) / 2 - 14, 45, 14, I18n.func_135052_a((String)"settings.new", (Object[])new Object[0]));
        PrefsButton delButton = new PrefsButton(9317, col1x + 50, (this.field_146295_m + 180) / 2 - 14, 45, 14, I18n.func_135052_a((String)"settings.delete", (Object[])new Object[0]));
        newButton.bgcolor = this.bgcolor;
        delButton.bgcolor = this.bgcolor;
        this.field_146292_n.add(newButton);
        this.field_146292_n.add(delButton);
        this.filterName.setButtonDims(100, 11);
        this.filterName.setLabelLoc(col1x);
        this.filterName.setButtonLoc(col1x + 33 + this.field_146297_k.field_71466_p.func_78256_a(this.filterName.description), this.rowY(1));
        PrefsButton prevButton = new PrefsButton(9308, this.filterName.x() - 23, this.rowY(1), 20, 14, "<<");
        PrefsButton nextButton = new PrefsButton(9309, this.filterName.x() + 103, this.rowY(1), 20, 14, ">>");
        this.field_146292_n.add(prevButton);
        this.field_146292_n.add(nextButton);
        this.sendToTabBool.setButtonLoc(col1x, this.rowY(2));
        this.sendToTabBool.setLabelLoc(col1x + 19);
        this.sendToTabBool.buttonColor = buttonColor;
        this.sendToAllTabs.setButtonLoc(col1x + 20, this.rowY(3));
        this.sendToAllTabs.setLabelLoc(col1x + 39);
        this.sendToAllTabs.buttonColor = buttonColor;
        this.sendToTabName.setLabelLoc(effRight - this.field_146297_k.field_71466_p.func_78256_a(this.sendToTabName.description) - 55);
        this.sendToTabName.setButtonLoc(effRight - 50, this.rowY(3));
        this.sendToTabName.setButtonDims(50, 11);
        this.removeMatches.setButtonLoc(col1x, this.rowY(4));
        this.removeMatches.setLabelLoc(col1x + 19);
        this.removeMatches.buttonColor = buttonColor;
        this.globalFilter.setLabelLoc(effRight - this.field_146297_k.field_71466_p.func_78256_a(this.globalFilter.description));
        this.globalFilter.setButtonLoc(effRight - this.field_146297_k.field_71466_p.func_78256_a(this.globalFilter.description) - 19, this.rowY(4));
        this.globalFilter.buttonColor = buttonColor;
        this.highlightBool.setButtonLoc(col1x, this.rowY(5));
        this.highlightBool.setLabelLoc(col1x + 19);
        this.highlightBool.buttonColor = buttonColor;
        this.highlightColor.setButtonDims(70, 11);
        this.highlightColor.setButtonLoc(col1x + 15 + this.field_146297_k.field_71466_p.func_78256_a(this.highlightColor.description), this.rowY(6));
        this.highlightColor.setLabelLoc(col1x + 10);
        this.highlightFormat.setButtonDims(60, 11);
        this.highlightFormat.setButtonLoc(effRight - 60, this.rowY(6));
        this.highlightFormat.setLabelLoc(this.highlightFormat.x() - 5 - this.field_146297_k.field_71466_p.func_78256_a(this.highlightFormat.description));
        this.audioNotificationBool.setButtonLoc(col1x, this.rowY(7));
        this.audioNotificationBool.setLabelLoc(col1x + 19);
        this.audioNotificationBool.buttonColor = buttonColor;
        this.audioNotificationSound.setButtonDims(60, 11);
        this.audioNotificationSound.setButtonLoc(effRight - 60, this.rowY(7));
        this.audioNotificationSound.setLabelLoc(this.audioNotificationSound.x() - 5 - this.field_146297_k.field_71466_p.func_78256_a(this.audioNotificationSound.description));
        this.inverseMatch.setButtonLoc(col1x, this.rowY(8));
        this.inverseMatch.setLabelLoc(col1x + 19);
        this.inverseMatch.buttonColor = buttonColor;
        this.caseSensitive.setLabelLoc(effRight - this.field_146297_k.field_71466_p.func_78256_a(this.caseSensitive.description));
        this.caseSensitive.setButtonLoc(effRight - this.field_146297_k.field_71466_p.func_78256_a(this.caseSensitive.description) - 19, this.rowY(8));
        this.caseSensitive.buttonColor = buttonColor;
        this.expressionString.setLabelLoc(col1x);
        this.expressionString.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.expressionString.description), this.rowY(9));
        this.expressionString.setButtonDims(effRight - this.expressionString.x(), 11);
        this.resetTempVars();
        this.displayCurrentFilter();
    }

    @Override
    public Properties loadSettingsFile() {
        this.filterMap.clear();
        Properties settingsTable = super.loadSettingsFile();
        settingsTable.putAll((Map<?, ?>)TabbyChatUtils.loadSettingsFromFile(this.globalFiltersFile));
        Pattern pattern = Pattern.compile(".+(?=\\.)");
        AtomicInteger count = new AtomicInteger(1);
        settingsTable.keySet().stream().map(object -> {
            Matcher matcher = pattern.matcher(object.toString());
            return matcher.find() ? matcher.group() : null;
        }).filter(Objects::nonNull).distinct().forEach(loadId -> {
            String loadName = settingsTable.getProperty(loadId + ".filterName");
            TCChatFilter loaded = new TCChatFilter(loadName);
            loaded.inverseMatch = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".inverseMatch"));
            loaded.caseSensitive = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".caseSensitive"));
            loaded.highlightBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".highlightBool"));
            loaded.highlightColor = ColorCodeEnum.cleanValueOf(settingsTable.getProperty(loadId + ".highlightColor"));
            loaded.highlightFormat = FormatCodeEnum.cleanValueOf(settingsTable.getProperty(loadId + ".highlightFormat"));
            loaded.audioNotificationBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".audioNotificationBool"));
            loaded.audioNotificationSound = TabbyChatUtils.parseSound(settingsTable.getProperty(loadId + ".audioNotificationSound"));
            loaded.sendToTabBool = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".sendToTabBool"));
            loaded.sendToTabName = TabbyChatUtils.parseString(settingsTable.getProperty(loadId + ".sendToTabName"));
            loaded.sendToAllTabs = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".sendToAllTabs"));
            loaded.removeMatches = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".removeMatches"));
            loaded.globalFilter = Boolean.parseBoolean(settingsTable.getProperty(loadId + ".globalFilter"));
            loaded.compilePattern(TabbyChatUtils.parseString(settingsTable.getProperty(loadId + ".expressionString")));
            this.filterMap.put(count.getAndIncrement(), loaded);
        });
        this.resetTempVars();
        return null;
    }

    @Override
    public void func_73864_a(int par1, int par2, int par3) {
        if (this.audioNotificationSound.hovered(par1, par2).booleanValue()) {
            this.audioNotificationSound.mouseClicked(par1, par2, par3);
            this.field_146297_k.field_71439_g.func_85030_a(((NotificationSoundEnum)((Object)this.audioNotificationSound.getTempValue())).file(), 1.0f, 1.0f);
        } else {
            super.func_73864_a(par1, par2, par3);
        }
    }

    @Override
    public void resetTempVars() {
        this.tempFilterMap.clear();
        Map.Entry<Integer, TCChatFilter> realFilter = this.filterMap.firstEntry();
        if (realFilter != null) {
            this.curFilterId = realFilter.getKey();
        }
        while (realFilter != null) {
            this.tempFilterMap.put(realFilter.getKey(), new TCChatFilter(realFilter.getValue()));
            realFilter = this.filterMap.higherEntry(realFilter.getKey());
        }
    }

    @Override
    public void saveSettingsFile() {
        Map<Boolean, List<TCChatFilter>> divideOnGlobal = this.filterMap.values().stream().collect(Collectors.groupingBy(filter -> filter.globalFilter));
        Properties globalFiltersTable = new Properties();
        ((List)divideOnGlobal.getOrDefault(true, new ArrayList())).forEach(tcChatFilter -> TCSettingsFilters.saveIntoProperties(tcChatFilter, globalFiltersTable));
        Properties settingsTable = new Properties();
        ((List)divideOnGlobal.getOrDefault(false, new ArrayList())).forEach(tcChatFilter -> TCSettingsFilters.saveIntoProperties(tcChatFilter, settingsTable));
        ArrayList tmpList = new ArrayList(this.field_146292_n);
        this.field_146292_n.clear();
        this.savePropertiesIntoFile(globalFiltersTable, this.globalFiltersFile);
        super.saveSettingsFile(settingsTable);
        this.field_146292_n = tmpList;
    }

    private static void saveIntoProperties(TCChatFilter saveFilter, Properties properties) {
        UUID saveId = UUID.randomUUID();
        properties.put(saveId + ".filterName", saveFilter.filterName);
        properties.put(saveId + ".inverseMatch", Boolean.toString(saveFilter.inverseMatch));
        properties.put(saveId + ".caseSensitive", Boolean.toString(saveFilter.caseSensitive));
        properties.put(saveId + ".highlightBool", Boolean.toString(saveFilter.highlightBool));
        properties.put(saveId + ".audioNotificationBool", Boolean.toString(saveFilter.audioNotificationBool));
        properties.put(saveId + ".sendToTabBool", Boolean.toString(saveFilter.sendToTabBool));
        properties.put(saveId + ".sendToAllTabs", Boolean.toString(saveFilter.sendToAllTabs));
        properties.put(saveId + ".removeMatches", Boolean.toString(saveFilter.removeMatches));
        properties.put(saveId + ".highlightColor", saveFilter.highlightColor.name());
        properties.put(saveId + ".highlightFormat", saveFilter.highlightFormat.name());
        properties.put(saveId + ".audioNotificationSound", saveFilter.audioNotificationSound.name());
        properties.put(saveId + ".sendToTabName", saveFilter.sendToTabName);
        properties.put(saveId + ".expressionString", saveFilter.expressionString);
        properties.put(saveId + ".globalFilter", Boolean.toString(saveFilter.globalFilter));
    }

    private void storeTempFilter() {
        if (this.tempFilterMap.containsKey(this.curFilterId)) {
            TCChatFilter storeMe = this.tempFilterMap.get(this.curFilterId);
            storeMe.filterName = this.filterName.getTempValue();
            storeMe.inverseMatch = (Boolean)this.inverseMatch.getTempValue();
            storeMe.caseSensitive = (Boolean)this.caseSensitive.getTempValue();
            storeMe.highlightBool = (Boolean)this.highlightBool.getTempValue();
            storeMe.highlightColor = ColorCodeEnum.valueOf(((Enum)this.highlightColor.getTempValue()).name());
            storeMe.highlightFormat = FormatCodeEnum.valueOf(((Enum)this.highlightFormat.getTempValue()).name());
            storeMe.audioNotificationBool = (Boolean)this.audioNotificationBool.getTempValue();
            storeMe.audioNotificationSound = NotificationSoundEnum.valueOf(((Enum)this.audioNotificationSound.getTempValue()).name());
            storeMe.sendToTabBool = (Boolean)this.sendToTabBool.getTempValue();
            storeMe.sendToAllTabs = (Boolean)this.sendToAllTabs.getTempValue();
            storeMe.sendToTabName = this.sendToTabName.getTempValue();
            storeMe.removeMatches = (Boolean)this.removeMatches.getTempValue();
            storeMe.expressionString = this.expressionString.getTempValue();
            storeMe.globalFilter = (Boolean)this.globalFilter.getTempValue();
        }
    }

    @Override
    public void storeTempVars() {
        this.filterMap.clear();
        Map.Entry<Integer, TCChatFilter> tempFilter = this.tempFilterMap.firstEntry();
        while (tempFilter != null) {
            this.filterMap.put(tempFilter.getKey(), new TCChatFilter(tempFilter.getValue()));
            tempFilter = this.tempFilterMap.higherEntry(tempFilter.getKey());
        }
    }

    public void updateForServer() {
        this.settingsFile = new File(TabbyChatUtils.getServerDir(), "filters.cfg");
    }

    @Override
    public void validateButtonStates() {
        this.inverseMatch.field_146124_l = (Boolean)this.highlightBool.getTempValue() == false;
        this.caseSensitive.field_146124_l = true;
        this.highlightBool.field_146124_l = (Boolean)this.removeMatches.getTempValue() == false && (Boolean)this.inverseMatch.getTempValue() == false;
        this.audioNotificationBool.field_146124_l = (Boolean)this.removeMatches.getTempValue() == false;
        this.removeMatches.field_146124_l = (Boolean)this.sendToTabBool.getTempValue() == false && (Boolean)this.highlightBool.getTempValue() == false && (Boolean)this.audioNotificationBool.getTempValue() == false;
        this.sendToTabBool.field_146124_l = (Boolean)this.removeMatches.getTempValue() == false;
        this.highlightColor.field_146124_l = (Boolean)this.highlightBool.getTempValue();
        this.highlightFormat.field_146124_l = (Boolean)this.highlightBool.getTempValue();
        this.audioNotificationSound.field_146124_l = (Boolean)this.audioNotificationBool.getTempValue();
        this.sendToAllTabs.field_146124_l = (Boolean)this.sendToTabBool.getTempValue();
        this.globalFilter.field_146124_l = true;
        for (GuiButton o : this.field_146292_n) {
            TCSettingBool tmpBool;
            if (!(o instanceof ITCSetting)) continue;
            ITCSetting tmp = (ITCSetting)o;
            if (this.tempFilterMap.size() == 0) {
                tmp.disable();
                continue;
            }
            if (tmp.getType() == ITCSetting.TCSettingType.TEXTBOX) {
                tmp.enable();
                continue;
            }
            if (!(tmp instanceof TCSettingBool)) continue;
            tmpBool.setTempValue((Object)((Boolean)(tmpBool = (TCSettingBool)tmp).getTempValue() != false && tmpBool.enabled() ? 1 : 0));
        }
        this.sendToTabName.func_146184_c((Boolean)this.sendToTabBool.getTempValue() != false && (Boolean)this.sendToAllTabs.getTempValue() == false);
    }
}

