/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.TCSettingsGUI;
import acs.tabbychat.settings.TCSettingBool;
import acs.tabbychat.settings.TCSettingSlider;
import acs.tabbychat.settings.TCSettingTextBox;
import acs.tabbychat.settings.files.TCSettingsAdvancedFile;
import acs.tabbychat.util.TabbyChatUtils;
import java.io.File;
import java.util.Properties;
import net.minecraft.client.resources.I18n;

public class TCSettingsAdvanced
extends TCSettingsGUI {
    private static final int CHAT_SCROLL_HISTORY_ID = 9401;
    private static final int MAXLENGTH_CHANNEL_NAME_ID = 9402;
    private static final int MULTICHAT_DELAY_ID = 9403;
    private static final int CHATBOX_UNFOC_HEIGHT_ID = 9406;
    private static final int CHAT_FADE_TICKS_ID = 9408;
    private static final int TEXT_IGNORE_OPACITY_ID = 9410;
    private static final int CONVERT_UNICODE_TEXT_ID = 9411;
    private final TCSettingsAdvancedFile settings = new TCSettingsAdvancedFile();
    public TCSettingTextBox chatScrollHistory;
    public TCSettingTextBox maxLengthChannelName;
    public TCSettingTextBox multiChatDelay;
    public TCSettingSlider chatBoxUnfocHeight;
    public TCSettingSlider chatFadeTicks;
    public TCSettingBool textIgnoreOpacity;
    public TCSettingBool convertUnicodeText;

    public TCSettingsAdvanced(TabbyChat _tc) {
        super(_tc);
        this.propertyPrefix = "settings.advanced";
        this.chatScrollHistory = new TCSettingTextBox("100", "chatScrollHistory", this.propertyPrefix, 9401);
        this.maxLengthChannelName = new TCSettingTextBox("10", "maxLengthChannelName", this.propertyPrefix, 9402);
        this.multiChatDelay = new TCSettingTextBox("500", "multiChatDelay", this.propertyPrefix, 9403);
        this.chatBoxUnfocHeight = new TCSettingSlider(50.0f, "chatBoxUnfocHeight", this.propertyPrefix, 9406, 20.0f, 100.0f);
        this.chatFadeTicks = new TCSettingSlider(200.0f, "chatFadeTicks", this.propertyPrefix, 9408, 10.0f, 2000.0f);
        this.textIgnoreOpacity = new TCSettingBool(false, "textignoreopacity", this.propertyPrefix, 9410);
        this.convertUnicodeText = new TCSettingBool(false, "convertunicodetext", this.propertyPrefix, 9411);
        this.name = I18n.func_135052_a((String)"settings.advanced.name", (Object[])new Object[0]);
        this.settingsFile = new File(tabbyChatDir, "advanced.cfg");
        this.bgcolor = 1719676564;
        this.chatScrollHistory.setCharLimit(3);
        this.maxLengthChannelName.setCharLimit(2);
        this.multiChatDelay.setCharLimit(4);
        this.defineDrawableSettings();
    }

    @Override
    public void defineDrawableSettings() {
        this.field_146292_n.add(this.chatScrollHistory);
        this.field_146292_n.add(this.maxLengthChannelName);
        this.field_146292_n.add(this.multiChatDelay);
        this.field_146292_n.add(this.chatBoxUnfocHeight);
        this.field_146292_n.add(this.chatFadeTicks);
        this.field_146292_n.add(this.textIgnoreOpacity);
        this.field_146292_n.add(this.convertUnicodeText);
    }

    @Override
    public void initDrawableSettings() {
        int col1x = (this.field_146294_l - 300) / 2 + 55;
        int buttonColor = (this.bgcolor & 0xFFFFFF) + -16777216;
        this.chatScrollHistory.setLabelLoc(col1x);
        this.chatScrollHistory.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.chatScrollHistory.description), this.rowY(1));
        this.chatScrollHistory.setButtonDims(30, 11);
        this.maxLengthChannelName.setLabelLoc(col1x);
        this.maxLengthChannelName.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.maxLengthChannelName.description), this.rowY(2));
        this.maxLengthChannelName.setButtonDims(20, 11);
        this.multiChatDelay.setLabelLoc(col1x);
        this.multiChatDelay.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.multiChatDelay.description), this.rowY(3));
        this.multiChatDelay.setButtonDims(40, 11);
        this.chatBoxUnfocHeight.setLabelLoc(col1x);
        this.chatBoxUnfocHeight.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.chatBoxUnfocHeight.description), this.rowY(4));
        this.chatBoxUnfocHeight.buttonColor = buttonColor;
        this.chatFadeTicks.setLabelLoc(col1x);
        this.chatFadeTicks.setButtonLoc(col1x + 5 + this.field_146297_k.field_71466_p.func_78256_a(this.chatFadeTicks.description), this.rowY(5));
        this.chatFadeTicks.buttonColor = buttonColor;
        this.chatFadeTicks.units = "";
        this.textIgnoreOpacity.setButtonLoc(col1x, this.rowY(6));
        this.textIgnoreOpacity.setLabelLoc(col1x + 19);
        this.textIgnoreOpacity.buttonColor = buttonColor;
        this.convertUnicodeText.setButtonLoc(col1x, this.rowY(7));
        this.convertUnicodeText.setLabelLoc(col1x + 19);
        this.convertUnicodeText.buttonColor = buttonColor;
    }

    @Override
    public Properties loadSettingsFile() {
        this.settings.loadSettingsFile();
        this.chatScrollHistory.setValue(Integer.toString(this.settings.chatScrollHistory));
        this.maxLengthChannelName.setValue(Integer.toString(this.settings.maxLengthChannelName));
        ChatBox.anchoredTop = this.settings.anchoredTop;
        this.convertUnicodeText.setValue((Object)this.settings.convertUnicodeText);
        this.multiChatDelay.setValue(Integer.toString(this.settings.multiChatDelay));
        ChatBox.current.height = TabbyChatUtils.parseInteger(String.valueOf(this.settings.chatBoxHeight), ChatBox.absMinH, 10000, 180);
        this.chatBoxUnfocHeight.setValue(Float.valueOf(this.settings.chatBoxUnfocHeight));
        ChatBox.current.y = TabbyChatUtils.parseInteger(String.valueOf(this.settings.chatBoxY), -10000, ChatBox.absMinY, ChatBox.absMinY);
        ChatBox.current.x = TabbyChatUtils.parseInteger(String.valueOf(this.settings.chatBoxX), ChatBox.absMinX, 10000, ChatBox.absMinX);
        this.textIgnoreOpacity.setValue((Object)this.settings.textIgnoreOpacity);
        ChatBox.current.width = TabbyChatUtils.parseInteger(String.valueOf(this.settings.chatBoxWidth), ChatBox.absMinW, 10000, 320);
        this.chatFadeTicks.setValue(Float.valueOf(this.settings.chatFadeTicks));
        ChatBox.pinned = this.settings.pinned;
        return null;
    }

    @Override
    public void saveSettingsFile() {
        try {
            this.settings.anchoredTop = ChatBox.anchoredTop;
            this.settings.convertUnicodeText = (Boolean)this.convertUnicodeText.getValue();
            this.settings.chatBoxHeight = ChatBox.current.height;
            this.settings.chatBoxUnfocHeight = ((Float)this.chatBoxUnfocHeight.getValue()).floatValue();
            this.settings.chatBoxY = ChatBox.current.y;
            this.settings.chatBoxX = ChatBox.current.x;
            this.settings.textIgnoreOpacity = (Boolean)this.textIgnoreOpacity.getValue();
            this.settings.chatBoxWidth = ChatBox.current.width;
            this.settings.chatFadeTicks = ((Float)this.chatFadeTicks.getValue()).floatValue();
            this.settings.pinned = ChatBox.pinned;
            this.settings.chatScrollHistory = Integer.parseInt((String)this.chatScrollHistory.getValue());
            this.settings.maxLengthChannelName = Integer.parseInt((String)this.maxLengthChannelName.getValue());
            this.settings.multiChatDelay = Integer.parseInt((String)this.multiChatDelay.getValue());
        }
        catch (NumberFormatException e) {
            TabbyChatUtils.log.warn("Invalid format in advanced settings");
        }
        this.settings.saveSettingsFile();
    }
}

