/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.gui;

import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.gui.ChatBox;
import java.awt.Point;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.MathHelper;
import org.lwjgl.input.Mouse;

public class ChatScrollBar {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final GuiNewChatTC gnc = GuiNewChatTC.getInstance();
    protected static int barHeight = 5;
    protected static int barWidth = 5;
    private static float mouseLoc = 0.0f;
    private static int scrollBarCenter = 0;
    private static int barBottomY = 0;
    private static int barTopY = 0;
    private static int barX = 326;
    private static int barMinY = 0;
    private static int barMaxY = 0;
    private static int lastY = 0;
    private static boolean scrolling = false;

    public static void handleMouse() {
        Point cursor = ChatBox.scaleMouseCoords(Mouse.getEventX(), Mouse.getEventY());
        if (Mouse.getEventButton() == 0 && Mouse.isButtonDown((int)0)) {
            int offsetX = barX + ChatBox.current.x;
            int offsetY = ChatBox.current.y;
            scrolling = cursor.x - offsetX > 0 && cursor.x - offsetX <= barWidth && cursor.y <= barMaxY + offsetY && cursor.y >= barMinY + offsetY;
        } else if (!Mouse.isButtonDown((int)0)) {
            scrolling = false;
        }
        if (Math.abs(cursor.y - lastY) > 1 && scrolling) {
            ChatScrollBar.scrollBarMouseDrag(cursor.y);
        }
    }

    private static void update() {
        barHeight = MathHelper.func_76141_d((float)(5.0f * gnc.getScaleSetting()));
        barWidth = MathHelper.func_76141_d((float)(5.0f * gnc.getScaleSetting()));
        barX = ChatBox.current.width - barWidth - 2;
        if (ChatBox.anchoredTop) {
            barBottomY = ChatBox.current.height - ChatBox.tabTrayHeight;
            barTopY = 0;
        } else {
            barBottomY = 0;
            barTopY = -ChatBox.current.height + ChatBox.tabTrayHeight;
        }
        barMaxY = barBottomY - barHeight / 2 - 1;
        barMinY = barTopY + barHeight / 2 + 1;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)barMinY + (1.0f - mouseLoc) * (float)barMaxY) : Math.round(mouseLoc * (float)barMaxY + (1.0f - mouseLoc) * (float)barMinY);
    }

    public static void drawScrollBar() {
        ChatScrollBar.update();
        int minX = barX + 1;
        int maxlines = gnc.getHeightSetting() / 9;
        float chatOpacity = ChatScrollBar.mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
        int currentOpacity = (int)(180.0f * chatOpacity);
        Gui.func_73734_a((int)barX, (int)barTopY, (int)(barX + barWidth + 2), (int)barBottomY, (int)(currentOpacity << 24));
        if (gnc.getChatSize() > maxlines) {
            Gui.func_73734_a((int)minX, (int)(scrollBarCenter - barHeight / 2), (int)(minX + barWidth), (int)(scrollBarCenter + barHeight / 2), (int)(0xFFFFFF + (currentOpacity / 2 << 24)));
            Gui.func_73734_a((int)(minX + 1), (int)(scrollBarCenter - barHeight / 2 - 1), (int)(minX + barWidth - 1), (int)(scrollBarCenter + barHeight / 2 + 1), (int)(0xFFFFFF + (currentOpacity / 2 << 24)));
        }
    }

    public static void scrollBarMouseWheel() {
        ChatScrollBar.update();
        int maxlines = gnc.getHeightSetting() / 9;
        int blines = gnc.getChatSize();
        mouseLoc = blines > maxlines ? (float)gnc.chatLinesTraveled() / (float)(blines - maxlines) : 0.0f;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)barMinY + (1.0f - mouseLoc) * (float)barMaxY) : Math.round(mouseLoc * (float)barMaxY + (1.0f - mouseLoc) * (float)barMinY);
    }

    public static void scrollBarMouseDrag(int _absY) {
        float moveInc;
        int maxlines = gnc.getHeightSetting() / 9;
        int blines = gnc.getChatSize();
        if (blines <= maxlines) {
            mouseLoc = 0.0f;
            return;
        }
        int adjBarMin = barMinY + ChatBox.current.y;
        int adjBarMax = barMaxY + ChatBox.current.y;
        mouseLoc = _absY < adjBarMin ? (ChatBox.anchoredTop ? 0.0f : 1.0f) : (_absY > adjBarMax ? (ChatBox.anchoredTop ? 1.0f : 0.0f) : (!ChatBox.anchoredTop ? Math.abs((float)(adjBarMax - _absY)) / (float)(adjBarMax - adjBarMin) : Math.abs((float)(adjBarMin - _absY)) / (float)(adjBarMax - adjBarMin)));
        int moveLines = (int)(mouseLoc / (moveInc = 1.0f / (float)(blines - maxlines)));
        if (moveLines > blines - maxlines) {
            moveLines = blines - maxlines;
        }
        gnc.setVisChatLines(moveLines);
        mouseLoc = moveInc * (float)moveLines;
        scrollBarCenter = !ChatBox.anchoredTop ? Math.round(mouseLoc * (float)(barMinY - barMaxY) + (float)barMaxY) : Math.round(mouseLoc * (float)(barMaxY - barMinY) + (float)barMinY);
        lastY = _absY;
    }

    public static void setOffset(int _x, int _y) {
        int maxlines = gnc.getHeightSetting() / 9;
        int clines = Math.min(gnc.getChatSize(), maxlines);
        barX = 324 + _x;
        barMinY = ChatScrollBar.mc.field_71462_r.field_146295_m - ((clines - 1) * 9 + 8) - 35 + _y;
        barTopY = barMinY + barHeight / 2 + _y;
        barMaxY = ChatScrollBar.mc.field_71462_r.field_146295_m - 45 + _y;
        barBottomY = barMaxY - barHeight / 2 + _y;
    }
}

