/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiChatTC;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.TCSettingsAdvanced;
import acs.tabbychat.gui.TCSettingsFilters;
import acs.tabbychat.gui.TCSettingsGeneral;
import acs.tabbychat.gui.TCSettingsServer;
import acs.tabbychat.gui.TCSettingsSpelling;
import acs.tabbychat.jazzy.TCSpellCheckManager;
import acs.tabbychat.settings.ChannelDelimEnum;
import acs.tabbychat.settings.ColorCodeEnum;
import acs.tabbychat.settings.FormatCodeEnum;
import acs.tabbychat.settings.TCChatFilter;
import acs.tabbychat.threads.BackgroundUpdateCheck;
import acs.tabbychat.util.ChatComponentUtils;
import acs.tabbychat.util.TabbyChatUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;

public class TabbyChat {
    private static final Logger log = TabbyChatUtils.log;
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization().registerTypeAdapter(IChatComponent.class, (Object)new IChatComponent.Serializer()).create();
    public static boolean modLoaded = false;
    public static boolean defaultUnicode;
    public static String version;
    public static Minecraft mc;
    public static TCSettingsGeneral generalSettings;
    public static TCSettingsServer serverSettings;
    public static TCSettingsFilters filterSettings;
    public static TCSettingsSpelling spellingSettings;
    public static TCSettingsAdvanced advancedSettings;
    public static TCSpellCheckManager spellChecker;
    private static boolean firstRun;
    private static boolean updateChecked;
    private static File chanDataFile;
    private static GuiNewChatTC gnc;
    private static TabbyChat instance;
    private final Map<ChatChannel, String> lastChatMap = Maps.newHashMap();
    private final ReentrantReadWriteLock lastChatLock = new ReentrantReadWriteLock(true);
    private final Lock lastChatReadLock = this.lastChatLock.readLock();
    private final Lock lastChatWriteLock = this.lastChatLock.writeLock();
    public LinkedHashMap<String, ChatChannel> channelMap = new LinkedHashMap();
    protected Semaphore serverDataLock = new Semaphore(0, true);
    private volatile TCChatLine lastChat;
    private Pattern chatChannelPatternClean = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatChannelPatternDirty = Pattern.compile("^\\[([\\p{L}0-9_]{1,10})\\]");
    private Pattern chatPMfromMePattern = null;
    private Pattern chatPMtoMePattern = null;

    private TabbyChat(GuiNewChatTC gncInstance) {
        mc = Minecraft.func_71410_x();
        gnc = gncInstance;
        generalSettings = new TCSettingsGeneral(this);
        serverSettings = new TCSettingsServer(this);
        filterSettings = new TCSettingsFilters(this);
        spellingSettings = new TCSettingsSpelling(this);
        advancedSettings = new TCSettingsAdvanced(this);
        spellChecker = TCSpellCheckManager.getInstance();
        generalSettings.loadSettingsFile();
        spellingSettings.loadSettingsFile();
        advancedSettings.loadSettingsFile();
        defaultUnicode = TabbyChat.mc.field_71466_p.func_82883_a();
    }

    public static TabbyChat getInstance() {
        return instance;
    }

    public static TabbyChat getInstance(GuiNewChatTC gncInstance) {
        if (instance == null) {
            instance = new TabbyChat(gncInstance);
        }
        return instance;
    }

    public static String getNewestVersion() {
        String updateURL = "https://raw.githubusercontent.com/mist475/tabbychat/master/latest";
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(updateURL).openConnection();
            BufferedReader buffer = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String newestVersion = buffer.readLine();
            buffer.close();
            return newestVersion;
        }
        catch (Throwable e) {
            TabbyChat.printErr("Unable to check for TabbyChat update.");
            return version;
        }
    }

    public static void printErr(String err) {
        log.warn("[TABBYCHAT] " + err);
    }

    public static void printException(String err, Exception e) {
        log.warn("[TABBYCHAT] " + err, (Throwable)e);
    }

    public static void printMessageToChat(String msg) {
        if (instance == null) {
            return;
        }
        if (!TabbyChat.instance.channelMap.containsKey("TabbyChat")) {
            TabbyChat.instance.channelMap.put("TabbyChat", new ChatChannel("TabbyChat"));
        }
        boolean firstLine = true;
        List split = TabbyChat.mc.field_71466_p.func_78271_c(msg, ChatBox.getMinChatWidth());
        for (String splitMsg : split) {
            if (firstLine) {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.field_71456_v.func_73834_c(), (IChatComponent)new ChatComponentText(splitMsg), 0, true), false);
            } else {
                instance.addToChannel("TabbyChat", new TCChatLine(TabbyChat.mc.field_71456_v.func_73834_c(), (IChatComponent)new ChatComponentText(" " + splitMsg), 0, true), false);
            }
            firstLine = false;
        }
    }

    public void activateIndex(int ind) {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            int i = 1;
            for (ChatChannel chan : this.channelMap.values()) {
                if (i == ind) {
                    GuiScreen guiScreen = TabbyChat.mc.field_71462_r;
                    if (guiScreen instanceof GuiChatTC) {
                        GuiChatTC curScreen = (GuiChatTC)guiScreen;
                        curScreen.checkCommandPrefixChange(this.channelMap.get(actives.get(0)), chan);
                    }
                    this.resetDisplayedChat();
                    return;
                }
                ++i;
            }
        }
    }

    public void activateNext() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            Iterator<ChatChannel> iter = this.channelMap.values().iterator();
            ChatChannel chan = iter.next();
            while (iter.hasNext()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    GuiScreen guiScreen = TabbyChat.mc.field_71462_r;
                    if (guiScreen instanceof GuiChatTC) {
                        GuiChatTC curScreen = (GuiChatTC)guiScreen;
                        curScreen.checkCommandPrefixChange(chan, iter.next());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = iter.next();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                GuiScreen guiScreen;
                iter = this.channelMap.values().iterator();
                if (iter.hasNext() && (guiScreen = TabbyChat.mc.field_71462_r) instanceof GuiChatTC) {
                    GuiChatTC curScreen = (GuiChatTC)guiScreen;
                    curScreen.checkCommandPrefixChange(chan, iter.next());
                }
                this.resetDisplayedChat();
            }
        }
    }

    public void activatePrev() {
        List<String> actives = this.getActive();
        if (actives.size() == 1) {
            ListIterator<Object> iter = Lists.newArrayList(this.channelMap.values()).listIterator(this.channelMap.size());
            ChatChannel chan = (ChatChannel)iter.previous();
            while (iter.hasPrevious()) {
                if (chan.getTitle().equals(actives.get(0))) {
                    GuiScreen guiScreen = TabbyChat.mc.field_71462_r;
                    if (guiScreen instanceof GuiChatTC) {
                        GuiChatTC curScreen = (GuiChatTC)guiScreen;
                        curScreen.checkCommandPrefixChange(chan, (ChatChannel)iter.previous());
                    }
                    this.resetDisplayedChat();
                    return;
                }
                chan = (ChatChannel)iter.previous();
            }
            if (chan.getTitle().equals(actives.get(0))) {
                GuiScreen guiScreen;
                chan.active = false;
                iter = new ArrayList<ChatChannel>(this.channelMap.values()).listIterator(this.channelMap.size());
                if (iter.hasPrevious() && (guiScreen = TabbyChat.mc.field_71462_r) instanceof GuiChatTC) {
                    GuiChatTC curScreen = (GuiChatTC)guiScreen;
                    curScreen.checkCommandPrefixChange(chan, (ChatChannel)iter.previous());
                }
                this.resetDisplayedChat();
            }
        }
    }

    public void addToChannel(String name, TCChatLine thisChat, boolean visible) {
        if (TabbyChat.serverSettings.ignoredChanPattern.matcher(name).matches()) {
            return;
        }
        thisChat = new TCChatLine(thisChat);
        thisChat.setChatLineString(thisChat.getChatComponent().func_150259_f());
        ChatChannel theChan = this.channelMap.get(name);
        if (theChan == null) {
            if (this.channelMap.size() >= 20) {
                return;
            }
            theChan = new ChatChannel(name);
            this.channelMap.put(name, theChan);
            GuiScreen guiScreen = TabbyChat.mc.field_71462_r;
            if (guiScreen instanceof GuiChatTC) {
                GuiChatTC curScreen = (GuiChatTC)guiScreen;
                curScreen.addChannelLive(theChan);
            }
        }
        if (((Boolean)TabbyChat.generalSettings.groupSpam.getValue()).booleanValue()) {
            this.spamCheck(theChan, thisChat);
            if (theChan.hasSpam) {
                theChan.removeChatLine(0);
            }
        } else {
            this.lastChatMap.put(theChan, thisChat.getChatComponent().func_150260_c());
        }
        theChan.addChat(thisChat, visible);
        theChan.trimLog();
    }

    public void deleteChatLines(int id) {
        for (ChatChannel chan : this.channelMap.values()) {
            chan.deleteChatLines(id);
        }
    }

    public boolean channelExists(String name) {
        return this.channelMap.get(name) != null;
    }

    public void checkServer() {
        if (!updateChecked) {
            updateChecked = true;
            BackgroundUpdateCheck buc = new BackgroundUpdateCheck();
            buc.start();
        }
        if (!TabbyChat.serverSettings.serverIP.equals(TabbyChatUtils.getServerIp())) {
            this.storeChannelData();
            this.channelMap.clear();
            if (this.enabled()) {
                this.enable();
                this.resetDisplayedChat();
            } else {
                this.disable();
            }
        }
    }

    public void createNewChannel(String name) {
        if (this.channelExists(name)) {
            return;
        }
        if (name == null || name.length() <= 0 || this.channelMap.size() >= 20) {
            return;
        }
        this.channelMap.put(name, new ChatChannel(name));
    }

    public void disable() {
        this.storeChannelData();
    }

    public void enable() {
        this.storeChannelData();
        if (!this.channelMap.containsKey("*")) {
            this.channelMap.put("*", new ChatChannel("*"));
            this.channelMap.get((Object)"*").active = true;
        }
        if (firstRun) {
            firstRun = false;
            return;
        }
        this.serverDataLock.tryAcquire();
        this.updateChanDataPath();
        serverSettings.updateForServer();
        filterSettings.updateForServer();
        this.reloadServerData();
        this.reloadSettingsData(false);
        if (TabbyChat.serverSettings.serverIP.length() > 0) {
            this.loadPMPatterns();
        }
        this.serverDataLock.release();
        if (((Boolean)TabbyChat.generalSettings.saveChatLog.getValue()).booleanValue() && TabbyChat.serverSettings.serverIP != null) {
            TabbyChatUtils.logChat("\nBEGIN CHAT LOGGING -- " + new SimpleDateFormat().format(Calendar.getInstance().getTime()), null);
        }
    }

    public boolean enabled() {
        return (Boolean)TabbyChat.generalSettings.tabbyChatEnable.getValue();
    }

    protected void finalize() {
        this.storeChannelData();
    }

    public List<String> getActive() {
        int n = this.channelMap.size();
        ArrayList<String> actives = new ArrayList<String>(n);
        for (ChatChannel chan : this.channelMap.values()) {
            if (!chan.active) continue;
            actives.add(chan.getTitle());
        }
        return actives;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadChannelData() {
        Map importData;
        if (!chanDataFile.exists()) {
            return;
        }
        GZIPInputStream inputstream = null;
        try {
            Type type = new TypeToken<Map<String, ChatChannel>>(){}.getType();
            inputstream = new GZIPInputStream(FileUtils.openInputStream((File)chanDataFile));
            String data = IOUtils.toString((InputStream)inputstream, (Charset)Charsets.UTF_8);
            importData = (Map)gson.fromJson(data, type);
        }
        catch (Exception e) {
            try {
                TabbyChat.printException("Unable to read channel data file : '" + e.getLocalizedMessage() + "'", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputstream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputstream);
            return;
        }
        IOUtils.closeQuietly((InputStream)inputstream);
        if (importData == null) {
            return;
        }
        int oldIDs = 0;
        try {
            for (Map.Entry entry : importData.entrySet()) {
                ChatChannel _new;
                if (((String)entry.getKey()).contentEquals("TabbyChat")) continue;
                if (!this.channelMap.containsKey(entry.getKey())) {
                    _new = new ChatChannel((String)entry.getKey());
                    _new.chanID = ((ChatChannel)entry.getValue()).chanID;
                    this.channelMap.put(_new.getTitle(), _new);
                } else {
                    _new = this.channelMap.get(entry.getKey());
                }
                _new.setAlias(((ChatChannel)entry.getValue()).getAlias());
                _new.active = ((ChatChannel)entry.getValue()).active;
                _new.notificationsOn = ((ChatChannel)entry.getValue()).notificationsOn;
                _new.hidePrefix = ((ChatChannel)entry.getValue()).hidePrefix;
                _new.cmdPrefix = ((ChatChannel)entry.getValue()).cmdPrefix;
                _new.importOldChat((ChatChannel)entry.getValue());
                this.addToChannel((String)entry.getKey(), new TCChatLine(-1, (IChatComponent)new ChatComponentText("-- chat history from " + new SimpleDateFormat().format(chanDataFile.lastModified())), 0, true), true);
                ++oldIDs;
            }
        }
        catch (ClassCastException e) {
            TabbyChat.printMessageToChat("Unable to load channel history data due to upgrade (sorry!)");
            TabbyChat.printException("Unable to load channel history", e);
        }
        ChatChannel.nextID = 3600 + oldIDs;
        this.resetDisplayedChat();
    }

    protected void loadPatterns() {
        ChannelDelimEnum delims = (ChannelDelimEnum)((Object)TabbyChat.serverSettings.delimiterChars.getValue());
        String colCode = "";
        String fmtCode = "";
        if (((Boolean)TabbyChat.serverSettings.delimColorBool.getValue()).booleanValue()) {
            colCode = ((ColorCodeEnum)((Object)TabbyChat.serverSettings.delimColorCode.getValue())).toCode();
        }
        if (((Boolean)TabbyChat.serverSettings.delimFormatBool.getValue()).booleanValue()) {
            fmtCode = ((FormatCodeEnum)((Object)TabbyChat.serverSettings.delimFormatCode.getValue())).toCode();
        }
        String frmt = colCode + fmtCode;
        if (((ColorCodeEnum)((Object)TabbyChat.serverSettings.delimColorCode.getValue())).toString().equals("White")) {
            frmt = "(" + colCode + ")?" + fmtCode;
        } else if (frmt.length() > 7) {
            frmt = "[" + frmt + "]{2}";
        }
        if (frmt.length() > 0) {
            frmt = "(?i:" + frmt + ")";
        }
        if (frmt.length() == 0) {
            frmt = "(?i:\u00a7[0-9A-FK-OR])*";
        }
        this.chatChannelPatternDirty = Pattern.compile("^(\u00a7r)?" + frmt + "\\" + delims.open() + "([\\p{L}0-9_\u00a7]+)\\" + delims.close());
        this.chatChannelPatternClean = Pattern.compile("^\\" + delims.open() + "([\\p{L}0-9_]{1," + (String)TabbyChat.advancedSettings.maxLengthChannelName.getValue() + "})\\" + delims.close());
    }

    protected void loadPMPatterns() {
        StringBuilder toMePM = new StringBuilder();
        StringBuilder fromMePM = new StringBuilder();
        toMePM.append("^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?me\\]");
        fromMePM.append("^\\[me[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        toMePM.append("|^\\(From ([\\p{L}\\p{N}_]{3,16})\\)[ ]?:");
        fromMePM.append("|^\\(To ([\\p{L}\\p{N}_]{3,16})\\)[ ]?:");
        toMePM.append("|^From ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        fromMePM.append("|^To ([\\p{L}\\p{N}_]{3,16})[ ]?:");
        toMePM.append("|^([\\p{L}\\p{N}_]{3,16}) whispers to you:");
        fromMePM.append("|^You whisper to ([\\p{L}\\p{N}_]{3,16}):");
        if (TabbyChat.mc.field_71439_g != null && TabbyChat.mc.field_71439_g.func_70005_c_() != null) {
            String me = TabbyChat.mc.field_71439_g.func_70005_c_();
            toMePM.append("|^\\[([\\p{L}\\p{N}_]{3,16})[ ]?\\-\\>[ ]?").append(me).append("\\]");
            fromMePM.append("|^\\[").append(me).append("[ ]?\\-\\>[ ]?([\\p{L}\\p{N}_]{3,16})\\]");
        }
        try {
            String toMe = ((String)TabbyChat.serverSettings.pmTabRegexToMe.getValue()).replace("{$player}", "([\\p{L}\\p{N}_]{3,16})");
            if (!toMe.isEmpty()) {
                Pattern.compile(toMe);
                toMePM.append("|").append(toMe);
            }
        }
        catch (PatternSyntaxException e) {
            log.error("Error while setting 'To me' regex.", (Throwable)e);
            TabbyChat.serverSettings.pmTabRegexToMe.setValue("");
            TabbyChat.printMessageToChat(ColorCodeEnum.RED.toCode() + "Unable to set 'To me' pm regex. See console for details.");
        }
        try {
            String fromMe = ((String)TabbyChat.serverSettings.pmTabRegexFromMe.getValue()).replace("{$player}", "([\\p{L}\\p{N}_]{3,16})");
            if (!fromMe.isEmpty()) {
                Pattern.compile(fromMe);
                fromMePM.append("|").append(fromMe);
            }
        }
        catch (PatternSyntaxException e) {
            log.error("Error while setting 'From me' regex.", (Throwable)e);
            TabbyChat.serverSettings.pmTabRegexFromMe.setValue("");
            TabbyChat.printMessageToChat(ColorCodeEnum.RED.toCode() + "Unable to set 'From me' pm regex. See console for details.");
        }
        this.chatPMtoMePattern = Pattern.compile(toMePM.toString());
        this.chatPMfromMePattern = Pattern.compile(fromMePM.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pollForUnread(Gui _gui, int _tick) {
        if (this.getActive().contains("*")) {
            return;
        }
        int tickdiff = 50;
        this.lastChatReadLock.lock();
        try {
            if (this.lastChat != null) {
                tickdiff = _tick - this.lastChat.func_74540_b();
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
        if (tickdiff < 50) {
            float var6 = TabbyChat.mc.field_71474_y.field_74357_r * 0.9f + 0.1f;
            double var10 = (double)tickdiff / 50.0;
            var10 = 1.0 - var10;
            if ((var10 *= 10.0) < 0.0) {
                var10 = 0.0;
            }
            if (var10 > 1.0) {
                var10 = 1.0;
            }
            var10 *= var10;
            int _opacity = (int)(255.0 * var10);
            if ((_opacity = (int)((float)_opacity * var6)) <= 3) {
                return;
            }
            ChatBox.updateTabs(this.channelMap);
            for (ChatChannel chan : this.channelMap.values()) {
                if (!chan.unread || !chan.notificationsOn) continue;
                chan.unreadNotify(_gui, _opacity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChat(TCChatLine theChat) {
        if (this.serverDataLock.availablePermits() == 0) {
            this.serverDataLock.acquireUninterruptibly();
            this.serverDataLock.release();
        }
        if (theChat == null) {
            return;
        }
        ArrayList<String> toTabs = new ArrayList<String>(20);
        ArrayList<String> filterTabs = new ArrayList<String>(20);
        String channelTab = null;
        String pmTab = null;
        toTabs.add("*");
        IChatComponent raw = theChat.getChatComponent();
        IChatComponent filtered = this.processChatForFilters(raw, filterTabs);
        if (((Boolean)TabbyChat.generalSettings.saveChatLog.getValue()).booleanValue()) {
            TabbyChatUtils.logChat(raw.func_150260_c(), null);
        }
        if (filtered != null) {
            ChatChannel tab;
            if (((Boolean)TabbyChat.serverSettings.autoChannelSearch.getValue()).booleanValue()) {
                channelTab = this.processChatForChannels(raw);
            }
            if (channelTab == null) {
                if (((Boolean)TabbyChat.serverSettings.autoPMSearch.getValue()).booleanValue() && (pmTab = this.processChatForPMs(raw.func_150260_c())) != null) {
                    tab = new ChatChannel(pmTab);
                    if (((Boolean)TabbyChat.generalSettings.saveChatLog.getValue()).booleanValue() && ((Boolean)TabbyChat.generalSettings.splitChatLog.getValue()).booleanValue()) {
                        TabbyChatUtils.logChat(raw.func_150260_c(), tab);
                    }
                }
            } else {
                toTabs.add(channelTab);
                tab = new ChatChannel(channelTab);
                if (((Boolean)TabbyChat.generalSettings.saveChatLog.getValue()).booleanValue() && ((Boolean)TabbyChat.generalSettings.splitChatLog.getValue()).booleanValue()) {
                    TabbyChatUtils.logChat(raw.func_150260_c(), tab);
                }
            }
        } else {
            return;
        }
        toTabs.addAll(filterTabs);
        TCChatLine resultChatLine = new TCChatLine(theChat.func_74540_b(), filtered, theChat.func_74539_c(), theChat.statusMsg);
        resultChatLine.timeStamp = Calendar.getInstance().getTime();
        HashSet tabSet = new HashSet(toTabs);
        List<String> activeTabs = this.getActive();
        boolean visible = false;
        if (pmTab != null) {
            if (!this.channelMap.containsKey(pmTab)) {
                ChatChannel pm = new ChatChannel(pmTab);
                pm.cmdPrefix = "/msg " + pmTab;
                this.channelMap.put(pmTab, pm);
                this.addToChannel(pmTab, resultChatLine, false);
                GuiScreen guiScreen = TabbyChat.mc.field_71462_r;
                if (guiScreen instanceof GuiChatTC) {
                    GuiChatTC curScreen = (GuiChatTC)guiScreen;
                    curScreen.addChannelLive(pm);
                }
            } else {
                if (activeTabs.contains(pmTab)) {
                    visible = true;
                }
                this.addToChannel(pmTab, resultChatLine, visible);
            }
        }
        if (!visible) {
            Set tabUnion = (Set)tabSet.clone();
            tabUnion.retainAll(activeTabs);
            if (tabUnion.size() > 0) {
                visible = true;
            }
        }
        for (String tab : tabSet) {
            this.addToChannel(tab, resultChatLine, visible);
        }
        if (!Collections.disjoint(this.getActive(), tabSet)) {
            for (String name : tabSet) {
                ChatChannel channel = this.channelMap.get(name);
                if (channel == null || !channel.active || !channel.hasSpam) continue;
                resultChatLine.getChatComponent().func_150258_a(" [" + channel.spamCount + "x]");
                break;
            }
        }
        for (ChatChannel channel : this.channelMap.values()) {
            channel.hasSpam = false;
        }
        this.lastChatWriteLock.lock();
        try {
            this.lastChat = resultChatLine;
        }
        finally {
            this.lastChatWriteLock.unlock();
        }
        this.lastChatReadLock.lock();
        try {
            if (visible) {
                gnc.addChatLines(0, this.lastChat);
            }
        }
        finally {
            this.lastChatReadLock.unlock();
        }
    }

    private String processChatForChannels(IChatComponent raw) {
        boolean dirtyCheck;
        Matcher findChannelClean = this.chatChannelPatternClean.matcher(EnumChatFormatting.func_110646_a((String)raw.func_150260_c()));
        Matcher findChannelDirty = this.chatChannelPatternDirty.matcher(raw.func_150254_d());
        boolean bl = dirtyCheck = (Boolean)TabbyChat.serverSettings.delimColorBool.getValue() == false && (Boolean)TabbyChat.serverSettings.delimFormatBool.getValue() == false || findChannelDirty.find();
        if (findChannelClean.find() && dirtyCheck) {
            return findChannelClean.group(1);
        }
        return null;
    }

    private IChatComponent processChatForFilters(IChatComponent raw, List<String> destinations) {
        if (raw == null) {
            return null;
        }
        IChatComponent chat = raw;
        Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
        while (iFilter != null) {
            if (iFilter.getValue().applyFilterToDirtyChat(chat)) {
                Object lastMatch;
                if (iFilter.getValue().removeMatches) {
                    return null;
                }
                if (iFilter.getValue().highlightBool) {
                    lastMatch = iFilter.getValue().getLastMatch();
                    for (int i1 = 0; i1 < ((int[])lastMatch).length; i1 += 2) {
                        int start = lastMatch[i1];
                        Object end = lastMatch[i1 + 1];
                        IChatComponent chat1 = ChatComponentUtils.subComponent(chat, 0, start);
                        IChatComponent chat2 = ChatComponentUtils.subComponent(chat, start, (int)end);
                        IChatComponent chat3 = ChatComponentUtils.subComponent(chat, (int)end);
                        ChatStyle style = chat2.func_150256_b();
                        if (iFilter.getValue().highlightColor != ColorCodeEnum.DEFAULT) {
                            style.func_150238_a(iFilter.getValue().highlightColor.toVanilla());
                        }
                        switch (iFilter.getValue().highlightFormat) {
                            case BOLD: {
                                style.func_150227_a(Boolean.valueOf(true));
                                break;
                            }
                            case ITALIC: {
                                style.func_150217_b(Boolean.valueOf(true));
                                break;
                            }
                            case STRIKED: {
                                style.func_150225_c(Boolean.valueOf(true));
                                break;
                            }
                            case UNDERLINE: {
                                style.func_150228_d(Boolean.valueOf(true));
                                break;
                            }
                            case MAGIC: {
                                style.func_150237_e(Boolean.valueOf(true));
                                break;
                            }
                        }
                        chat = chat1.func_150257_a(chat2).func_150257_a(chat3);
                    }
                    raw = chat;
                }
                if (iFilter.getValue().sendToTabBool) {
                    if (iFilter.getValue().sendToAllTabs) {
                        lastMatch = this.channelMap.values().iterator();
                        while (lastMatch.hasNext()) {
                            ChatChannel chan = (ChatChannel)lastMatch.next();
                            destinations.add(chan.getTitle());
                        }
                    } else {
                        String destTab = iFilter.getValue().getTabName();
                        if (destTab != null && destTab.length() > 0 && !destinations.contains(destTab)) {
                            destinations.add(destTab);
                        }
                    }
                }
                if (iFilter.getValue().audioNotificationBool) {
                    iFilter.getValue().audioNotification();
                }
            }
            iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
        }
        return raw;
    }

    private String processChatForPMs(String raw) {
        block2: {
            Matcher findPMfromMe;
            block3: {
                raw = EnumChatFormatting.func_110646_a((String)raw);
                if (this.chatPMtoMePattern == null) break block2;
                Matcher findPMtoMe = this.chatPMtoMePattern.matcher(raw);
                if (!findPMtoMe.find()) break block3;
                for (int i = 1; i <= findPMtoMe.groupCount(); ++i) {
                    if (findPMtoMe.group(i) == null) continue;
                    return findPMtoMe.group(i);
                }
                break block2;
            }
            if (this.chatPMfromMePattern == null || !(findPMfromMe = this.chatPMfromMePattern.matcher(raw)).find()) break block2;
            for (int i = 1; i <= findPMfromMe.groupCount(); ++i) {
                if (findPMfromMe.group(i) == null) continue;
                return findPMfromMe.group(i);
            }
        }
        return null;
    }

    private void reloadServerData() {
        serverSettings.loadSettingsFile();
        filterSettings.loadSettingsFile();
        this.loadChannelData();
    }

    public void reloadSettingsData(boolean withSave) {
        this.updateDefaults();
        this.loadPatterns();
        this.loadPMPatterns();
        this.updateFilters();
        if (withSave) {
            this.storeChannelData();
        }
    }

    public void removeTab(String _name) {
        this.lastChatMap.remove(this.channelMap.get(_name));
        this.channelMap.remove(_name);
    }

    public void resetDisplayedChat() {
        gnc.clearChatLines();
        List<String> actives = this.getActive();
        if (actives.size() < 1) {
            return;
        }
        gnc.addChatLines(this.channelMap.get(actives.get(0)));
        int n = actives.size();
        for (int i = 1; i < n; ++i) {
            gnc.mergeChatLines(this.channelMap.get(actives.get(i)));
        }
    }

    private void spamCheck(ChatChannel theChan, TCChatLine lineChat) {
        String oldChat = "";
        String newChat = lineChat.getChatComponent().func_150260_c();
        if (this.lastChatMap.containsKey(theChan)) {
            oldChat = this.lastChatMap.get(theChan);
        }
        if (oldChat.equals(newChat)) {
            theChan.hasSpam = true;
            ++theChan.spamCount;
            lineChat.getChatComponent().func_150258_a(" [" + theChan.spamCount + "x]");
        } else {
            theChan.hasSpam = false;
            theChan.spamCount = 1;
            this.lastChatMap.put(theChan, newChat);
        }
    }

    public void storeChannelData() {
        if (chanDataFile == null) {
            return;
        }
        if (!chanDataFile.getParentFile().exists()) {
            try {
                Files.createDirectories(chanDataFile.getParentFile().toPath(), new FileAttribute[0]);
            }
            catch (IOException e) {
                TabbyChat.printException("Error while writing channel data to file '" + chanDataFile.getName() + "'", e);
            }
        }
        GZIPOutputStream output = null;
        try {
            String data = gson.toJson(this.channelMap);
            output = new GZIPOutputStream(Files.newOutputStream(chanDataFile.toPath(), new OpenOption[0]));
            IOUtils.write((String)data, (OutputStream)output, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            try {
                TabbyChat.printErr("Unable to write channel data to file : '" + e.getLocalizedMessage() + "' : " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(output);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
        IOUtils.closeQuietly((OutputStream)output);
    }

    private void updateChanDataPath() {
        String pName = "";
        if (TabbyChat.mc.field_71439_g != null && TabbyChat.mc.field_71439_g.func_70005_c_() != null) {
            pName = TabbyChat.mc.field_71439_g.func_70005_c_();
        }
        File parentDir = TabbyChatUtils.getServerDir();
        chanDataFile = new File(parentDir, pName + "_chanData.ser");
    }

    protected void updateDefaults() {
        if (!((Boolean)TabbyChat.generalSettings.tabbyChatEnable.getValue()).booleanValue()) {
            return;
        }
        ArrayList<String> dList = new ArrayList<String>(TabbyChat.serverSettings.defaultChanList);
        for (ChatChannel chan : this.channelMap.values()) {
            int ind = dList.indexOf(chan.getTitle());
            if (ind < 0) continue;
            dList.remove(ind);
        }
        for (String defChan : dList) {
            if (defChan.length() <= 0) continue;
            this.channelMap.put(defChan, new ChatChannel(defChan));
        }
    }

    protected void updateFilters() {
        if (!((Boolean)TabbyChat.generalSettings.tabbyChatEnable.getValue()).booleanValue()) {
            return;
        }
        if (TabbyChat.filterSettings.filterMap.size() == 0) {
            return;
        }
        Map.Entry<Integer, TCChatFilter> iFilter = TabbyChat.filterSettings.filterMap.firstEntry();
        while (iFilter != null) {
            String newName = iFilter.getValue().sendToTabName;
            if (iFilter.getValue().sendToTabBool && !iFilter.getValue().sendToAllTabs && !this.channelMap.containsKey(newName) && !newName.startsWith("%")) {
                this.channelMap.put(newName, new ChatChannel(newName));
            }
            iFilter = TabbyChat.filterSettings.filterMap.higherEntry(iFilter.getKey());
        }
    }

    static {
        version = "1.12.2";
        firstRun = true;
        updateChecked = false;
        instance = null;
    }
}

