/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.api.IChatKeyboardExtension;
import acs.tabbychat.api.IChatMouseExtension;
import acs.tabbychat.api.IChatRenderExtension;
import acs.tabbychat.api.IChatUpdateExtension;
import acs.tabbychat.api.TCExtensionManager;
import acs.tabbychat.compat.MacroKeybindCompat;
import acs.tabbychat.core.ChatChannel;
import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.ChatButton;
import acs.tabbychat.gui.ChatChannelGUI;
import acs.tabbychat.gui.ChatScrollBar;
import acs.tabbychat.gui.PrefsButton;
import acs.tabbychat.gui.context.ChatContextMenu;
import acs.tabbychat.util.ChatExtensions;
import acs.tabbychat.util.TabbyChatUtils;
import com.google.common.collect.Lists;
import java.awt.Point;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.stream.GuiTwitchUserMode;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.C14PacketTabComplete;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import tv.twitch.chat.ChatUserInfo;

public class GuiChatTC
extends GuiChat {
    private static ScaledResolution sr;
    private final Logger log = TabbyChatUtils.log;
    private final List<String> foundPlayerNames = new ArrayList<String>();
    public String historyBuffer = "";
    public List<GuiTextField> inputList = new ArrayList<GuiTextField>(3);
    public ChatScrollBar scrollBar;
    public TabbyChat tc;
    public GuiNewChatTC gnc;
    private boolean playerNamesFound = false;
    private boolean waitingOnPlayerNames = false;
    private int playerNameIndex = 0;
    private int spellCheckCounter = 0;
    private ChatContextMenu contextMenu;
    private ChatExtensions extensions;

    public GuiChatTC() {
        this.field_146297_k = Minecraft.func_71410_x();
        sr = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.gnc = GuiNewChatTC.getInstance();
        this.tc = TabbyChat.getInstance();
        this.extensions = new ChatExtensions(TCExtensionManager.INSTANCE.getExtensions());
    }

    public GuiChatTC(String par1Str) {
        this();
        this.field_146409_v = par1Str;
    }

    public void func_146284_a(GuiButton par1GuiButton) {
        for (IChatMouseExtension extension : this.extensions.getListOf(IChatMouseExtension.class)) {
            if (!extension.actionPerformed(par1GuiButton)) continue;
            return;
        }
        if (!(par1GuiButton instanceof ChatButton)) {
            return;
        }
        ChatButton _button = (ChatButton)par1GuiButton;
        if (Keyboard.isKeyDown((int)42) && this.tc.channelMap.get("*") == _button.channel) {
            this.field_146297_k.func_147108_a((GuiScreen)TabbyChat.generalSettings);
            return;
        }
        if (!this.tc.enabled()) {
            return;
        }
        if (Keyboard.isKeyDown((int)42)) {
            if (_button.channel.active) {
                this.tc.activatePrev();
            }
            this.field_146292_n.remove((Object)_button);
            this.tc.channelMap.remove(_button.channel.getTitle());
        } else if (Keyboard.isKeyDown((int)29)) {
            if (!_button.channel.active) {
                this.gnc.mergeChatLines(_button.channel);
                _button.channel.unread = false;
            }
            boolean bl = _button.channel.active = !_button.channel.active;
            if (!_button.channel.active) {
                this.tc.resetDisplayedChat();
            }
        } else {
            List<String> preActiveTabs = this.tc.getActive();
            for (ChatChannel chan : this.tc.channelMap.values()) {
                if (((Object)((Object)_button)).equals((Object)chan.tab)) continue;
                chan.active = false;
            }
            if (!_button.channel.active) {
                ChatScrollBar.scrollBarMouseWheel();
                if (preActiveTabs.size() == 1) {
                    this.checkCommandPrefixChange(this.tc.channelMap.get(preActiveTabs.get(0)), _button.channel);
                } else {
                    _button.channel.active = true;
                    _button.channel.unread = false;
                }
            }
            this.tc.resetDisplayedChat();
        }
    }

    protected void addChannelLive(ChatChannel brandNewChan) {
        if (!this.field_146292_n.contains((Object)brandNewChan.tab)) {
            this.field_146292_n.add(brandNewChan.tab);
        }
    }

    public void checkCommandPrefixChange(ChatChannel oldChan, ChatChannel newChan) {
        String oldPrefix = oldChan.cmdPrefix.trim();
        String currentInput = this.field_146415_a.func_146179_b().trim();
        if (currentInput.equals(oldPrefix) || currentInput.length() == 0) {
            String newPrefix = newChan.cmdPrefix.trim();
            if (newPrefix.length() > 0 && !newChan.hidePrefix) {
                this.field_146415_a.func_146180_a(newPrefix + " ");
            } else {
                this.field_146415_a.func_146180_a("");
            }
        }
        oldChan.active = false;
        newChan.active = true;
        newChan.unread = false;
    }

    public void func_146404_p_() {
        if (this.playerNamesFound) {
            this.field_146415_a.func_146175_b(this.field_146415_a.func_146197_a(-1, this.field_146415_a.func_146198_h(), false) - this.field_146415_a.func_146198_h());
            if (this.playerNameIndex >= this.foundPlayerNames.size()) {
                this.playerNameIndex = 0;
            }
        } else {
            int prevWordIndex = this.field_146415_a.func_146197_a(-1, this.field_146415_a.func_146198_h(), false);
            this.foundPlayerNames.clear();
            this.playerNameIndex = 0;
            String nameStart = this.field_146415_a.func_146179_b().substring(prevWordIndex).toLowerCase();
            String textBuffer = this.field_146415_a.func_146179_b().substring(0, this.field_146415_a.func_146198_h());
            this.func_146405_a(textBuffer);
            if (this.foundPlayerNames.isEmpty()) {
                return;
            }
            this.playerNamesFound = true;
            this.field_146415_a.func_146175_b(prevWordIndex - this.field_146415_a.func_146198_h());
        }
        if (this.foundPlayerNames.size() > 1) {
            int low = this.playerNameIndex - 1;
            int high = this.playerNameIndex + 4;
            if (low < 0) {
                int diff = Math.abs(low);
                low = 0;
                high += diff;
            }
            if (high >= this.foundPlayerNames.size()) {
                high = this.foundPlayerNames.size();
            }
            while (high - low < 5 && this.foundPlayerNames.size() >= 5) {
                --low;
            }
            if (high - low < 5) {
                low = 0;
            }
            ArrayList<String> newList = new ArrayList<String>();
            for (int i = low; i < high; ++i) {
                newList.add(this.foundPlayerNames.get(i));
            }
            int counter = low;
            StringBuilder _sb = new StringBuilder();
            for (String textBuffer : newList) {
                if (counter == this.playerNameIndex + 1) {
                    _sb.append(EnumChatFormatting.RESET);
                }
                if (_sb.length() > 0) {
                    _sb.append(", ");
                }
                if (counter == this.playerNameIndex) {
                    _sb.append(EnumChatFormatting.BOLD);
                }
                ++counter;
                _sb.append(textBuffer);
            }
            if (high < this.foundPlayerNames.size()) {
                _sb.append(" ...");
            }
            this.field_146297_k.field_71456_v.func_146158_b().func_146234_a((IChatComponent)new ChatComponentText(_sb.toString()), 1);
        }
        this.field_146415_a.func_146191_b(this.foundPlayerNames.get(this.playerNameIndex++));
    }

    public void func_73878_a(boolean zeroId, int worldNum) {
        if (worldNum == 0) {
            if (zeroId) {
                this.func_146407_a(this.field_146411_u);
            }
            this.field_146411_u = null;
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    public void func_73863_a(int cursorX, int cursorY, float pointless) {
        sr = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.field_146294_l = sr.func_78326_a();
        this.field_146295_m = sr.func_78328_b();
        int inputHeight = 0;
        for (GuiTextField guiTextField : this.inputList) {
            if (!guiTextField.func_146176_q()) continue;
            inputHeight += 12;
        }
        int bgWidth = MacroKeybindCompat.present ? this.field_146294_l - 24 : this.field_146294_l - 2;
        GuiChatTC.func_73734_a((int)2, (int)(this.field_146295_m - 2 - inputHeight), (int)bgWidth, (int)(this.field_146295_m - 2), (int)Integer.MIN_VALUE);
        for (GuiTextField field : this.inputList) {
            if (!field.func_146176_q()) continue;
            field.func_146194_f();
        }
        if (this.tc.enabled()) {
            String string = Integer.valueOf(this.getCurrentSends()).toString();
            int sendsX = sr.func_78326_a() - 12;
            if (MacroKeybindCompat.present) {
                sendsX -= 22;
            }
            this.field_146289_q.func_78261_a(string, sendsX, this.field_146295_m - inputHeight, 0x707070);
        }
        if (((Boolean)TabbyChat.spellingSettings.spellCheckEnable.getValue()).booleanValue() && this.field_146415_a.func_146179_b().length() > 0) {
            TabbyChat.spellChecker.drawErrors((GuiScreen)this, this.inputList);
            if (this.spellCheckCounter == 200) {
                TabbyChat.spellChecker.update(this.inputList);
                this.spellCheckCounter = 0;
            }
            ++this.spellCheckCounter;
        }
        ChatBox.updateTabs(this.tc.channelMap);
        float f = this.gnc.getScaleSetting();
        GL11.glPushMatrix();
        float scaleOffsetX = (float)ChatBox.current.x * (1.0f - f);
        float scaleOffsetY = (float)(this.gnc.sr.func_78328_b() + ChatBox.current.y) * (1.0f - f);
        GL11.glTranslatef((float)scaleOffsetX, (float)scaleOffsetY, (float)1.0f);
        GL11.glScalef((float)f, (float)f, (float)1.0f);
        IChatComponent icc = this.gnc.func_146236_a(Mouse.getX(), Mouse.getY());
        if (icc != null && icc.func_150256_b().func_150210_i() != null) {
            HoverEvent hoverevent = icc.func_150256_b().func_150210_i();
            if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ITEM) {
                ItemStack itemstack = null;
                try {
                    NBTBase nbtbase = JsonToNBT.func_150315_a((String)hoverevent.func_150702_b().func_150260_c());
                    if (nbtbase instanceof NBTTagCompound) {
                        NBTTagCompound nbt = (NBTTagCompound)nbtbase;
                        itemstack = ItemStack.func_77949_a((NBTTagCompound)nbt);
                    }
                }
                catch (Exception nbtbase) {
                    // empty catch block
                }
                if (itemstack != null) {
                    this.func_146285_a(itemstack, cursorX, cursorY);
                } else {
                    this.func_146279_a(EnumChatFormatting.RED + "Invalid Item!", cursorX, cursorY);
                }
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_TEXT) {
                this.func_146279_a(hoverevent.func_150702_b().func_150254_d(), cursorX, cursorY);
            } else if (hoverevent.func_150701_a() == HoverEvent.Action.SHOW_ACHIEVEMENT) {
                StatBase statbase = StatList.func_151177_a((String)hoverevent.func_150702_b().func_150260_c());
                if (statbase != null) {
                    IChatComponent icc1 = statbase.func_150951_e();
                    ChatComponentTranslation cct = new ChatComponentTranslation("stats.tooltip.type." + (statbase.func_75967_d() ? "achievement" : "statistics"), new Object[0]);
                    cct.func_150256_b().func_150217_b(Boolean.valueOf(true));
                    String s = statbase instanceof Achievement ? ((Achievement)statbase).func_75989_e() : null;
                    ArrayList arraylist = Lists.newArrayList((Object[])new String[]{icc1.func_150254_d(), cct.func_150254_d()});
                    if (s != null) {
                        arraylist.addAll(this.field_146289_q.func_78271_c(s, 150));
                    }
                    this.func_146283_a(arraylist, cursorX, cursorY);
                } else {
                    this.func_146279_a(EnumChatFormatting.RED + "Invalid statistic/achievement!", cursorX, cursorY);
                }
            }
            GL11.glDisable((int)2896);
        }
        for (GuiButton buttonTemp : this.field_146292_n) {
            if (buttonTemp instanceof PrefsButton && buttonTemp.field_146127_k == 1 && this.field_146297_k.field_71439_g != null && !this.field_146297_k.field_71439_g.func_70608_bn()) {
                this.field_146292_n.remove(buttonTemp);
                continue;
            }
            buttonTemp.func_146112_a(this.field_146297_k, cursorX, cursorY);
        }
        if (this.contextMenu != null) {
            this.contextMenu.drawMenu(Mouse.getX(), Mouse.getY());
        }
        GL11.glPopMatrix();
        for (IChatRenderExtension extension : this.extensions.getListOf(IChatRenderExtension.class)) {
            extension.drawScreen(cursorX, cursorY, pointless);
        }
    }

    private void func_146405_a(String nameStart) {
        if (nameStart.length() >= 1) {
            this.field_146297_k.field_71439_g.field_71174_a.func_147297_a((Packet)new C14PacketTabComplete(nameStart));
            this.waitingOnPlayerNames = true;
        }
    }

    public void func_146406_a(String[] par1ArrayOfStr) {
        if (this.waitingOnPlayerNames) {
            this.foundPlayerNames.clear();
            String[] _copy = par1ArrayOfStr;
            int _len = par1ArrayOfStr.length;
            for (int i = 0; i < _len; ++i) {
                String name = _copy[i];
                if (name.length() <= 0) continue;
                this.foundPlayerNames.add(name);
                TabbyChat.spellChecker.addToIgnoredWords(name);
            }
            if (this.foundPlayerNames.size() > 0) {
                this.playerNamesFound = true;
                this.func_146404_p_();
            }
        }
    }

    private int getCurrentSends() {
        int _s;
        int lng = 0;
        for (int i = _s = this.inputList.size() - 1; i >= 0; --i) {
            lng += this.inputList.get(i).func_146179_b().length();
        }
        if (lng == 0) {
            return 0;
        }
        return (lng + 100 - 1) / 100;
    }

    private int getFocusedFieldIndex() {
        int _s = this.inputList.size();
        for (int i = 0; i < _s; ++i) {
            if (!this.inputList.get(i).func_146206_l() || !this.inputList.get(i).func_146176_q()) continue;
            return i;
        }
        return 0;
    }

    private int getInputListSize() {
        int size = 0;
        for (GuiTextField field : this.inputList) {
            if (field.func_146179_b().isEmpty()) continue;
            ++size;
        }
        return size;
    }

    public void func_146402_a(int _dir) {
        int loc = this.field_146416_h + _dir;
        int historyLength = this.gnc.func_146238_c().size();
        loc = Math.max(0, loc);
        if ((loc = Math.min(historyLength, loc)) == this.field_146416_h) {
            return;
        }
        if (loc == historyLength) {
            this.field_146416_h = historyLength;
            this.setText(new StringBuilder(this.historyBuffer), 1);
        } else {
            if (this.field_146416_h == historyLength) {
                this.historyBuffer = this.field_146415_a.func_146179_b();
            }
            StringBuilder _sb = new StringBuilder((String)this.gnc.func_146238_c().get(loc));
            this.setText(_sb, _sb.length());
            this.field_146416_h = loc;
        }
    }

    public void func_146274_d() {
        int wheelDelta;
        if (ChatBox.resizing) {
            if (!Mouse.isButtonDown((int)0)) {
                ChatBox.resizing = false;
            } else {
                ChatBox.handleMouseResize(Mouse.getEventX(), Mouse.getEventY());
            }
            return;
        }
        if (ChatBox.dragging) {
            if (!Mouse.isButtonDown((int)0)) {
                ChatBox.dragging = false;
            } else {
                ChatBox.handleMouseDrag(Mouse.getEventX(), Mouse.getEventY());
            }
            return;
        }
        if (Mouse.getEventButton() == 0 && Mouse.isButtonDown((int)0)) {
            if (ChatBox.resizeHovered() && !ChatBox.dragging) {
                ChatBox.startResizing(Mouse.getEventX(), Mouse.getEventY());
            } else if (ChatBox.pinHovered()) {
                ChatBox.pinned = !ChatBox.pinned;
            } else if (ChatBox.tabTrayHovered(Mouse.getEventX(), Mouse.getEventY()) && !ChatBox.resizing) {
                ChatBox.startDragging(Mouse.getEventX(), Mouse.getEventY());
            }
        }
        if ((wheelDelta = Mouse.getEventDWheel()) != 0) {
            wheelDelta = Math.min(1, wheelDelta);
            wheelDelta = Math.max(-1, wheelDelta);
            if (!GuiChatTC.func_146272_n()) {
                wheelDelta *= 7;
            }
            this.gnc.func_146229_b(wheelDelta);
            if (this.tc.enabled()) {
                ChatScrollBar.scrollBarMouseWheel();
            }
        } else if (this.tc.enabled()) {
            ChatScrollBar.handleMouse();
        }
        if (this.field_146297_k.field_71462_r.getClass() != GuiChat.class) {
            super.func_146274_d();
        }
        for (IChatMouseExtension ext : this.extensions.getListOf(IChatMouseExtension.class)) {
            ext.handleMouseInput();
        }
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.extensions = new ChatExtensions(TCExtensionManager.INSTANCE.getExtensions());
        this.field_146292_n.clear();
        this.inputList.clear();
        sr = new ScaledResolution(this.field_146297_k, this.field_146297_k.field_71443_c, this.field_146297_k.field_71440_d);
        this.field_146294_l = sr.func_78326_a();
        this.field_146295_m = sr.func_78328_b();
        this.tc.checkServer();
        if (this.tc.enabled()) {
            if (this.scrollBar == null) {
                this.scrollBar = new ChatScrollBar();
            }
            for (ChatChannel chan : this.tc.channelMap.values()) {
                this.field_146292_n.add(chan.tab);
            }
        } else {
            this.field_146292_n.add(this.tc.channelMap.get((Object)"*").tab);
        }
        this.field_146416_h = this.gnc.func_146238_c().size();
        int textFieldWidth = MacroKeybindCompat.present ? this.field_146294_l - 26 : this.field_146294_l - 4;
        String text = this.field_146409_v;
        if (this.field_146415_a != null) {
            text = this.field_146415_a.func_146179_b();
        }
        this.field_146415_a = new GuiTextField(this.field_146289_q, 4, this.field_146295_m - 12, textFieldWidth, 12);
        this.field_146415_a.func_146203_f(500);
        this.field_146415_a.func_146205_d(false);
        this.field_146415_a.func_146195_b(true);
        this.field_146415_a.func_146180_a(text);
        this.field_146415_a.func_146189_e(true);
        this.field_146415_a.func_146185_a(false);
        this.inputList.add(0, this.field_146415_a);
        if (!this.tc.enabled()) {
            return;
        }
        for (int i = 1; i < 3; ++i) {
            GuiTextField placeholder = new GuiTextField(this.field_146289_q, 4, this.field_146295_m - 12 * (i + 1), textFieldWidth, 12);
            placeholder.func_146203_f(500);
            placeholder.func_146205_d(false);
            placeholder.func_146195_b(false);
            placeholder.func_146180_a("");
            placeholder.func_146189_e(false);
            placeholder.func_146185_a(false);
            this.inputList.add(i, placeholder);
        }
        if (this.tc.enabled()) {
            List<String> activeTabs = this.tc.getActive();
            if (activeTabs.size() != 1) {
                this.field_146415_a.func_146180_a("");
            } else {
                String thePrefix = this.tc.channelMap.get((Object)activeTabs.get((int)0)).cmdPrefix.trim();
                boolean prefixHidden = this.tc.channelMap.get((Object)activeTabs.get((int)0)).hidePrefix;
                if (thePrefix.length() > 0 && !prefixHidden && this.field_146415_a.func_146179_b().isEmpty()) {
                    this.field_146415_a.func_146180_a(this.tc.channelMap.get((Object)activeTabs.get((int)0)).cmdPrefix.trim() + " ");
                }
            }
            ChatBox.enforceScreenBoundary(ChatBox.current);
        }
        for (IChatUpdateExtension extension : this.extensions.getListOf(IChatUpdateExtension.class)) {
            extension.initGui((GuiScreen)this);
        }
    }

    private void insertCharsAtCursor(String _chars) {
        StringBuilder msg = new StringBuilder();
        int cPos = 0;
        boolean cFound = false;
        for (int i = this.inputList.size() - 1; i >= 0; --i) {
            msg.append(this.inputList.get(i).func_146179_b());
            if (this.inputList.get(i).func_146206_l()) {
                cPos += this.inputList.get(i).func_146198_h();
                cFound = true;
                continue;
            }
            if (cFound) continue;
            cPos += this.inputList.get(i).func_146179_b().length();
        }
        if (this.field_146289_q.func_78256_a(msg.toString()) + this.field_146289_q.func_78256_a(_chars) < (sr.func_78326_a() - 20) * this.inputList.size()) {
            msg.insert(cPos, _chars);
            this.setText(msg, cPos + _chars.length());
        }
    }

    public void func_73869_a(char _char, int _code) {
        this.waitingOnPlayerNames = false;
        if (_code != 15) {
            this.playerNamesFound = false;
        }
        switch (_code) {
            case 15: {
                if (GuiScreen.func_146271_m()) {
                    if (GuiScreen.func_146272_n()) {
                        this.tc.activatePrev();
                        break;
                    }
                    this.tc.activateNext();
                    break;
                }
                this.func_146404_p_();
                break;
            }
            case 1: {
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 28: 
            case 156: {
                this.sendChat(ChatBox.pinned);
                break;
            }
            case 200: {
                int newPos;
                int lng;
                int gcp;
                if (GuiScreen.func_146271_m()) {
                    this.func_146402_a(-1);
                    break;
                }
                int foc = this.getFocusedFieldIndex();
                if (foc + 1 < this.inputList.size() && this.inputList.get(foc + 1).func_146176_q()) {
                    gcp = this.inputList.get(foc).func_146198_h();
                    lng = this.inputList.get(foc + 1).func_146179_b().length();
                    newPos = Math.min(gcp, lng);
                    this.inputList.get(foc).func_146195_b(false);
                    this.inputList.get(foc + 1).func_146195_b(true);
                    this.inputList.get(foc + 1).func_146190_e(newPos);
                    break;
                }
                this.func_146402_a(-1);
                break;
            }
            case 208: {
                int newPos;
                int lng;
                int gcp;
                if (GuiScreen.func_146271_m()) {
                    this.func_146402_a(1);
                    break;
                }
                int foc = this.getFocusedFieldIndex();
                if (foc - 1 >= 0 && this.inputList.get(foc - 1).func_146176_q()) {
                    gcp = this.inputList.get(foc).func_146198_h();
                    lng = this.inputList.get(foc - 1).func_146179_b().length();
                    newPos = Math.min(gcp, lng);
                    this.inputList.get(foc).func_146195_b(false);
                    this.inputList.get(foc - 1).func_146195_b(true);
                    this.inputList.get(foc - 1).func_146190_e(newPos);
                    break;
                }
                this.func_146402_a(1);
                break;
            }
            case 201: {
                this.gnc.func_146229_b(19);
                if (!this.tc.enabled()) break;
                ChatScrollBar.scrollBarMouseWheel();
                break;
            }
            case 209: {
                this.gnc.func_146229_b(-19);
                if (!this.tc.enabled()) break;
                ChatScrollBar.scrollBarMouseWheel();
                break;
            }
            case 14: {
                if (this.field_146415_a.func_146206_l() && this.field_146415_a.func_146198_h() > 0) {
                    this.field_146415_a.func_146201_a(_char, _code);
                    break;
                }
                this.removeCharsAtCursor(-1);
                break;
            }
            case 211: {
                if (this.field_146415_a.func_146206_l()) {
                    this.field_146415_a.func_146201_a(_char, _code);
                    break;
                }
                this.removeCharsAtCursor(1);
                break;
            }
            case 203: {
                int foc = this.getFocusedFieldIndex();
                if (foc < this.getInputListSize() - 1 && this.inputList.get(foc).func_146198_h() == 0) {
                    this.inputList.get(foc).func_146195_b(false);
                    this.inputList.get(foc + 1).func_146195_b(true);
                    this.inputList.get(foc + 1).func_146190_e(this.inputList.get(foc + 1).func_146179_b().length());
                }
                this.inputList.get(this.getFocusedFieldIndex()).func_146201_a(_char, _code);
                break;
            }
            case 205: {
                int foc1 = this.getFocusedFieldIndex();
                if (foc1 > 0 && this.inputList.get(foc1).func_146198_h() >= this.inputList.get(foc1).func_146179_b().length()) {
                    this.inputList.get(foc1).func_146195_b(false);
                    this.inputList.get(foc1 - 1).func_146195_b(true);
                    this.inputList.get(foc1 - 1).func_146190_e(0);
                }
                this.inputList.get(this.getFocusedFieldIndex()).func_146201_a(_char, _code);
                break;
            }
            default: {
                if (GuiScreen.func_146271_m() && !Keyboard.isKeyDown((int)56) && !Keyboard.isKeyDown((int)184)) {
                    if (_code > 1 && _code < 12) {
                        this.tc.activateIndex(_code - 1);
                        break;
                    }
                    if (_code == 24) {
                        this.field_146297_k.func_147108_a((GuiScreen)TabbyChat.generalSettings);
                        break;
                    }
                    this.field_146415_a.func_146201_a(_char, _code);
                    break;
                }
                if (this.field_146415_a.func_146206_l() && this.field_146289_q.func_78256_a(this.field_146415_a.func_146179_b()) < sr.func_78326_a() - 20) {
                    this.field_146415_a.func_146201_a(_char, _code);
                    break;
                }
                this.insertCharsAtCursor(Character.toString(_char));
            }
        }
        for (IChatKeyboardExtension ext : this.extensions.getListOf(IChatKeyboardExtension.class)) {
            ext.keyTyped(_char, _code);
        }
    }

    protected void sendChat(boolean keepopen) {
        int i;
        StringBuilder _msg = new StringBuilder(1500);
        for (i = this.inputList.size() - 1; i >= 0; --i) {
            _msg.append(this.inputList.get(i).func_146179_b());
        }
        if (_msg.toString().length() > 0) {
            TabbyChatUtils.writeLargeChat(_msg.toString());
            for (i = 1; i < this.inputList.size(); ++i) {
                this.inputList.get(i).func_146180_a("");
                this.inputList.get(i).func_146195_b(false);
            }
        }
        if (!this.tc.enabled() || !keepopen) {
            this.field_146297_k.func_147108_a(null);
        } else {
            this.resetInputFields();
        }
        this.field_146416_h = this.gnc.func_146238_c().size() + 1;
    }

    public void func_73864_a(int _x, int _y, int _button) {
        boolean clicked;
        Point scaled;
        block34: {
            scaled = ChatBox.scaleMouseCoords(Mouse.getX(), Mouse.getY(), true);
            clicked = false;
            if (scaled != null && _button == 0 && this.field_146297_k.field_71474_y.field_74359_p && (this.contextMenu == null || !this.contextMenu.isCursorOver(scaled.x, scaled.y))) {
                IChatComponent ccd = this.gnc.func_146236_a(Mouse.getX(), Mouse.getY());
                if (ccd != null) {
                    Serializable url;
                    ClickEvent clickEvent = ccd.func_150256_b().func_150235_h();
                    if (clickEvent != null) {
                        if (GuiChatTC.func_146272_n()) {
                            this.field_146415_a.func_146191_b(ccd.func_150256_b().func_150235_h().func_150668_b());
                        } else if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_URL) {
                            try {
                                url = new URI(clickEvent.func_150668_b());
                                if (this.field_146297_k.field_71474_y.field_74358_q) {
                                    this.field_146411_u = url;
                                    this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, clickEvent.func_150668_b(), 0, false));
                                    break block34;
                                }
                                this.func_146407_a((URI)url);
                            }
                            catch (URISyntaxException var7) {
                                this.log.error("Can't open url for " + clickEvent, (Throwable)var7);
                            }
                        } else if (clickEvent.func_150669_a() == ClickEvent.Action.OPEN_FILE) {
                            url = new File(clickEvent.func_150668_b()).toURI();
                            this.func_146407_a((URI)url);
                        } else if (clickEvent.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
                            this.field_146415_a.func_146180_a(clickEvent.func_150668_b());
                        } else if (clickEvent.func_150669_a() == ClickEvent.Action.RUN_COMMAND) {
                            this.func_146403_a(clickEvent.func_150668_b());
                        } else if (clickEvent.func_150669_a() == ClickEvent.Action.TWITCH_USER_INFO) {
                            ChatUserInfo var8 = this.field_146297_k.func_152346_Z().func_152926_a(clickEvent.func_150668_b());
                            if (var8 != null) {
                                this.field_146297_k.func_147108_a((GuiScreen)new GuiTwitchUserMode(this.field_146297_k.func_152346_Z(), var8));
                            } else {
                                this.log.error("Tried to handle twitch user but couldn't find them!");
                            }
                        } else {
                            this.log.error("Don't know how to handle " + clickEvent);
                        }
                    } else {
                        try {
                            url = new URL(ccd.func_150260_c());
                            if (this.field_146297_k.field_71474_y.field_74358_q) {
                                this.field_146411_u = ((URL)url).toURI();
                                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, ccd.func_150260_c(), 0, false));
                                break block34;
                            }
                            this.func_146407_a(((URL)url).toURI());
                        }
                        catch (MalformedURLException | URISyntaxException exception) {}
                    }
                }
            } else if (scaled != null && this.contextMenu != null && this.contextMenu.isCursorOver(scaled.x, scaled.y)) {
                boolean bl = clicked = !this.contextMenu.mouseClicked(scaled.x, scaled.y);
            }
        }
        if (!clicked) {
            this.contextMenu = scaled != null && _button == 1 && (this.contextMenu == null || !this.contextMenu.isCursorOver(scaled.x, scaled.y)) ? new ChatContextMenu(this, scaled.x, scaled.y) : null;
        }
        for (int i = 0; i < this.inputList.size(); ++i) {
            if (_y < this.field_146295_m - 12 * (i + 1) || !this.inputList.get(i).func_146176_q()) continue;
            this.inputList.get(i).func_146195_b(true);
            for (GuiTextField field : this.inputList) {
                if (field == this.inputList.get(i)) continue;
                field.func_146195_b(false);
            }
            this.inputList.get(i).func_146192_a(_x, _y, _button);
            break;
        }
        if (!clicked) {
            for (IChatMouseExtension extension : this.extensions.getListOf(IChatMouseExtension.class)) {
                if (!extension.mouseClicked(_x, _y, _button)) continue;
                return;
            }
        }
        for (GuiButton _guibutton : this.field_146292_n) {
            ChatButton guiButton;
            if (!(_guibutton instanceof ChatButton) || !(guiButton = (ChatButton)_guibutton).func_146116_c(this.field_146297_k, _x, _y)) continue;
            if (_button == 0) {
                this.field_146290_a = guiButton;
                this.field_146297_k.field_71439_g.func_85030_a("random.click", 1.0f, 1.0f);
                this.func_146284_a(guiButton);
                return;
            }
            if (_button != 1) continue;
            if (guiButton.channel == this.tc.channelMap.get("*")) {
                return;
            }
            this.field_146297_k.func_147108_a((GuiScreen)new ChatChannelGUI(guiButton.channel));
        }
    }

    public void func_146281_b() {
        ChatBox.dragging = false;
        ChatBox.resizing = false;
        this.gnc.func_146240_d();
        for (IChatUpdateExtension ext : this.extensions.getListOf(IChatUpdateExtension.class)) {
            ext.onGuiClosed();
        }
    }

    private void removeCharsAtCursor(int _del) {
        StringBuilder msg = new StringBuilder();
        int cPos = 0;
        boolean cFound = false;
        for (int i = this.inputList.size() - 1; i >= 0; --i) {
            msg.append(this.inputList.get(i).func_146179_b());
            if (this.inputList.get(i).func_146206_l()) {
                cPos += this.inputList.get(i).func_146198_h();
                cFound = true;
                continue;
            }
            if (cFound) continue;
            cPos += this.inputList.get(i).func_146179_b().length();
        }
        int other = cPos + _del;
        other = Math.min(msg.length() - 1, other);
        if ((other = Math.max(0, other)) < cPos) {
            msg.replace(other, cPos, "");
            this.setText(msg, other);
        } else if (other > cPos) {
            msg.replace(cPos, other, "");
            this.setText(msg, cPos);
        }
    }

    private void resetInputFields() {
        for (GuiTextField gtf : this.inputList) {
            gtf.func_146180_a("");
            gtf.func_146195_b(false);
            gtf.func_146189_e(false);
        }
        this.field_146415_a.func_146195_b(true);
        this.field_146415_a.func_146189_e(true);
        List<String> actives = this.tc.getActive();
        if (actives.size() == 1) {
            ChatChannel current = this.tc.channelMap.get(actives.get(0));
            String pre = current.cmdPrefix.trim();
            boolean hidden = current.hidePrefix;
            if (pre.length() > 0 && !hidden) {
                this.field_146415_a.func_146180_a(pre + " ");
            }
        }
        this.field_146415_a.func_146202_e();
        this.field_146416_h = this.gnc.func_146238_c().size();
    }

    private void setText(StringBuilder txt, int pos) {
        int strings;
        List<String> txtList = this.stringListByWidth(txt, sr.func_78326_a() - 20);
        for (int i = strings = Math.min(txtList.size() - 1, this.inputList.size() - 1); i >= 0; --i) {
            this.inputList.get(i).func_146180_a(txtList.get(strings - i));
            if (pos > txtList.get(strings - i).length()) {
                pos -= txtList.get(strings - i).length();
                this.inputList.get(i).func_146189_e(true);
                this.inputList.get(i).func_146195_b(false);
                continue;
            }
            if (pos >= 0) {
                this.inputList.get(i).func_146195_b(true);
                this.inputList.get(i).func_146189_e(true);
                this.inputList.get(i).func_146190_e(pos);
                pos = -1;
                continue;
            }
            this.inputList.get(i).func_146189_e(true);
            this.inputList.get(i).func_146195_b(false);
        }
        if (pos > 0) {
            this.field_146415_a.func_146202_e();
        }
        if (this.inputList.size() > txtList.size()) {
            for (int j = txtList.size(); j < this.inputList.size(); ++j) {
                this.inputList.get(j).func_146180_a("");
                this.inputList.get(j).func_146195_b(false);
                this.inputList.get(j).func_146189_e(false);
            }
        }
        if (!this.field_146415_a.func_146176_q()) {
            this.field_146415_a.func_146195_b(true);
            this.field_146415_a.func_146189_e(true);
        }
    }

    private List<String> stringListByWidth(StringBuilder _sb, int _w) {
        ArrayList<String> result = new ArrayList<String>(5);
        int _len = 0;
        StringBuilder bucket = new StringBuilder(_sb.length());
        for (int ind = 0; ind < _sb.length(); ++ind) {
            int _cw = this.field_146289_q.func_78263_a(_sb.charAt(ind));
            if (_len + _cw > _w) {
                result.add(bucket.toString());
                bucket = new StringBuilder(_sb.length());
                _len = 0;
            }
            _len += _cw;
            bucket.append(_sb.charAt(ind));
        }
        if (bucket.length() > 0) {
            result.add(bucket.toString());
        }
        return result;
    }

    public void func_73876_c() {
        this.field_146415_a.func_146178_a();
        for (IChatUpdateExtension ext : this.extensions.getListOf(IChatUpdateExtension.class)) {
            ext.updateScreen();
        }
    }
}

