/*
 * Decompiled with CFR 0.152.
 */
package acs.tabbychat.core;

import acs.tabbychat.core.GuiNewChatTC;
import acs.tabbychat.core.TCChatLine;
import acs.tabbychat.core.TabbyChat;
import acs.tabbychat.gui.ChatBox;
import acs.tabbychat.gui.ChatButton;
import acs.tabbychat.util.ChatComponentUtils;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class ChatChannel {
    protected static int nextID = 3600;
    private final ReentrantReadWriteLock chatListLock = new ReentrantReadWriteLock(true);
    private final Lock chatReadLock = this.chatListLock.readLock();
    private final Lock chatWriteLock = this.chatListLock.writeLock();
    public ChatButton tab;
    public boolean unread = false;
    @Expose
    public boolean active = false;
    @Expose
    public boolean notificationsOn = false;
    @Expose
    public boolean hidePrefix = false;
    @Expose
    public String cmdPrefix = "";
    protected boolean hasSpam = false;
    protected int spamCount = 1;
    @Expose
    protected int chanID = nextID + 1;
    private File logFile;
    @Expose
    private String title;
    @Expose
    private String alias;
    @Expose
    private ArrayList<TCChatLine> chatLog;
    private final Supplier<List<TCChatLine>> supplier = Suppliers.memoizeWithExpiration(() -> this.getSplitChat(true), (long)50L, (TimeUnit)TimeUnit.MILLISECONDS);

    public ChatChannel() {
        this.chanID = nextID++;
        this.chatLog = new ArrayList();
        this.notificationsOn = (Boolean)TabbyChat.generalSettings.unreadFlashing.getValue();
    }

    public ChatChannel(int _x, int _y, int _w, int _h, String _title) {
        this();
        this.tab = new ChatButton(this.chanID, _x, _y, _w, _h, _title);
        this.alias = this.title = _title;
        this.tab.channel = this;
        this.tab.width(TabbyChat.mc.field_71466_p.func_78256_a(this.alias + "<>") + 8);
    }

    public ChatChannel(String _title) {
        this(3, 3, Minecraft.func_71410_x().field_71466_p.func_78256_a("<" + _title + ">") + 8, 14, _title);
    }

    public void addChat(TCChatLine newChat, boolean visible) {
        this.chatWriteLock.lock();
        try {
            this.chatLog.add(0, newChat);
        }
        finally {
            this.chatWriteLock.unlock();
        }
        if (!this.title.equals("*") && this.notificationsOn && !visible) {
            this.unread = true;
        }
    }

    public void deleteChatLines(int id) {
        this.chatReadLock.lock();
        try {
            this.chatLog.removeIf(line -> line.func_74539_c() == id);
        }
        finally {
            this.chatReadLock.unlock();
        }
    }

    public boolean doesButtonEqual(GuiButton btnObj) {
        return this.tab.field_146127_k == btnObj.field_146127_k;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String _alias) {
        this.alias = _alias;
        this.tab.width(TabbyChat.mc.field_71466_p.func_78256_a(_alias + "<>") + 8);
    }

    public int getButtonEnd() {
        return this.tab.x() + this.tab.width();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCChatLine getChatLine(int index) {
        TCChatLine retVal;
        this.chatReadLock.lock();
        List<TCChatLine> lines = this.getSplitChat(false);
        try {
            retVal = lines.get(index);
        }
        finally {
            this.chatReadLock.unlock();
        }
        return retVal;
    }

    public int getChatLogSize() {
        int mySize;
        this.chatReadLock.lock();
        try {
            mySize = this.getSplitChat(false).size();
        }
        finally {
            this.chatReadLock.unlock();
        }
        return mySize;
    }

    private List<TCChatLine> getSplitChat(boolean force) {
        if (!force) {
            return (List)this.supplier.get();
        }
        return ChatComponentUtils.split(this.chatLog, ChatBox.getChatWidth());
    }

    public int getID() {
        return this.chanID;
    }

    public String getDisplayTitle() {
        if (this.active) {
            return "[" + this.alias + "]";
        }
        if (this.unread) {
            return "<" + this.alias + ">";
        }
        return this.alias;
    }

    public String getTitle() {
        return this.title;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public void setLogFile(File file) {
        this.logFile = file;
    }

    public void setButtonObj(ChatButton btnObj) {
        this.tab = btnObj;
        this.tab.channel = this;
    }

    public String toString() {
        return this.getDisplayTitle();
    }

    public void clear() {
        this.chatWriteLock.lock();
        try {
            this.chatLog.clear();
        }
        finally {
            this.chatWriteLock.unlock();
        }
        this.tab = null;
    }

    public void setButtonLoc(int _x, int _y) {
        this.tab.x(_x);
        this.tab.y(_y);
    }

    protected void setChatLogLine(int ind, TCChatLine newLine) {
        this.chatWriteLock.lock();
        try {
            if (ind < this.chatLog.size()) {
                this.chatLog.set(ind, newLine);
            } else {
                this.chatLog.add(newLine);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
        GuiNewChatTC.getInstance().func_146245_b();
    }

    public void removeChatLine(int pos) {
        this.chatWriteLock.lock();
        try {
            if (pos < this.chatLog.size() && pos >= 0) {
                this.chatLog.remove(pos);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
        GuiNewChatTC.getInstance().func_146245_b();
    }

    public void trimLog() {
        TabbyChat tc = GuiNewChatTC.tc;
        if (tc == null || tc.serverDataLock.availablePermits() < 1) {
            return;
        }
        int maxChats = tc.enabled() ? Integer.parseInt((String)TabbyChat.advancedSettings.chatScrollHistory.getValue()) : 100;
        this.chatWriteLock.lock();
        try {
            while (this.chatLog.size() > maxChats) {
                this.chatLog.remove(this.chatLog.size() - 1);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
    }

    public void unreadNotify(Gui _gui, int _opacity) {
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChatTC gnc = GuiNewChatTC.getInstance();
        int tabY = this.tab.y() - gnc.sr.func_78328_b() - ChatBox.current.y;
        tabY = ChatBox.anchoredTop ? tabY - ChatBox.getChatHeight() + ChatBox.getUnfocusedHeight() : tabY + ChatBox.getChatHeight() - ChatBox.getUnfocusedHeight() + 1;
        Gui.func_73734_a((int)this.tab.x(), (int)tabY, (int)(this.tab.x() + this.tab.width()), (int)(tabY + this.tab.height()), (int)(0x720000 + (_opacity / 2 << 24)));
        GL11.glEnable((int)3042);
        mc.field_71456_v.func_146158_b().func_73732_a(mc.field_71466_p, this.getDisplayTitle(), this.tab.x() + this.tab.width() / 2, tabY + 4, 0xFF0000 + (_opacity << 24));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void importOldChat(ChatChannel oldChan) {
        if (oldChan == null || oldChan.chatLog.isEmpty()) {
            return;
        }
        this.chatWriteLock.lock();
        try {
            for (TCChatLine oldChat : oldChan.chatLog) {
                if (oldChat == null || oldChat.statusMsg) continue;
                this.chatLog.add(oldChat);
            }
        }
        finally {
            this.chatWriteLock.unlock();
        }
        this.trimLog();
    }
}

