/*
 * Decompiled with CFR 0.152.
 */
package com.muxiu1997.sharewhereiam.network;

import com.muxiu1997.sharewhereiam.integration.journeymap.WaypointManager;
import com.muxiu1997.sharewhereiam.network.NetworkHandler;
import com.muxiu1997.sharewhereiam.util.WaypointUtil;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import journeymap.client.model.Waypoint;

public class MessageMarkWaypoint
implements IMessage {
    private String playerName;
    private String waypointJson;

    public MessageMarkWaypoint() {
    }

    @SideOnly(value=Side.CLIENT)
    public MessageMarkWaypoint(WaypointUtil.PlayerWaypoint playerWaypoint) {
        this.playerName = playerWaypoint.player.getDisplayName();
        this.waypointJson = playerWaypoint.waypoint.toString();
    }

    public void fromBytes(ByteBuf buf) {
        this.playerName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.waypointJson = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.playerName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.waypointJson);
    }

    public static class Handler
    implements IMessageHandler<MessageMarkWaypoint, IMessage>,
    NetworkHandler.IClientSideHandler,
    NetworkHandler.IServerSideHandler {
        public IMessage onMessage(MessageMarkWaypoint message, MessageContext ctx) {
            switch (ctx.side) {
                case CLIENT: {
                    this.handleClientSideMessage(message);
                    break;
                }
                case SERVER: {
                    this.handleServerSideMessage(message);
                }
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        private void handleClientSideMessage(MessageMarkWaypoint message) {
            WaypointManager.addTransientBeacon(message.playerName, Waypoint.fromString((String)message.waypointJson));
        }

        private void handleServerSideMessage(MessageMarkWaypoint message) {
            NetworkHandler.network.sendToAll((IMessage)message);
        }
    }
}

