/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.wands.ItemWandCasting;

public class WandHelper {
    private static ArrayList<WandCap> allVanillaCaps;
    private static ArrayList<WandRod> allVanillaRods;

    @Nullable
    public static WandCap getWandCapFromItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        for (WandCap cap : WandCap.caps.values()) {
            ItemStack capItemStack = cap.getItem();
            if (capItemStack == null || !itemStack.func_77969_a(capItemStack)) continue;
            return cap;
        }
        return null;
    }

    @Nullable
    public static WandCap getWandCapFromWand(@Nullable ItemStack itemStack) {
        ItemWandCasting wandInstance = WandHelper.getWandItem(itemStack);
        if (wandInstance == null) {
            return null;
        }
        return wandInstance.getCap(itemStack);
    }

    @Nullable
    public static WandRod getWandRodFromItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        for (WandRod rod : WandRod.rods.values()) {
            ItemStack rodItemStack = rod.getItem();
            if (rodItemStack == null || !itemStack.func_77969_a(rodItemStack)) continue;
            return rod;
        }
        return null;
    }

    @Nullable
    public static WandRod getWandRodFromWand(@Nullable ItemStack itemStack) {
        ItemWandCasting wandInstance = WandHelper.getWandItem(itemStack);
        if (wandInstance == null) {
            return null;
        }
        return wandInstance.getRod(itemStack);
    }

    @Nullable
    public static ItemWandCasting getWandItem(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return null;
        }
        if (!(item instanceof ItemWandCasting)) {
            return null;
        }
        ItemWandCasting wandInstance = (ItemWandCasting)item;
        return wandInstance;
    }

    public static List<WandCap> allVanillaCaps() {
        if (allVanillaCaps == null) {
            WandCap[] allCaps = new WandCap[]{ConfigItems.WAND_CAP_IRON, ConfigItems.WAND_CAP_COPPER, ConfigItems.WAND_CAP_GOLD, ConfigItems.WAND_CAP_SILVER, ConfigItems.WAND_CAP_THAUMIUM, ConfigItems.WAND_CAP_VOID};
            allVanillaCaps = new ArrayList(allCaps.length);
            for (WandCap wandCap : allCaps) {
                if (wandCap == null) continue;
                allVanillaCaps.add(wandCap);
            }
        }
        return new ArrayList<WandCap>(allVanillaCaps);
    }

    public static List<WandRod> allVanillaRods() {
        if (allVanillaRods == null) {
            WandRod[] allRods = new WandRod[]{ConfigItems.WAND_ROD_WOOD, ConfigItems.WAND_ROD_GREATWOOD, ConfigItems.WAND_ROD_OBSIDIAN, ConfigItems.WAND_ROD_BLAZE, ConfigItems.WAND_ROD_ICE, ConfigItems.WAND_ROD_QUARTZ, ConfigItems.WAND_ROD_BONE, ConfigItems.WAND_ROD_REED, ConfigItems.WAND_ROD_SILVERWOOD, ConfigItems.STAFF_ROD_GREATWOOD, ConfigItems.STAFF_ROD_OBSIDIAN, ConfigItems.STAFF_ROD_BLAZE, ConfigItems.STAFF_ROD_ICE, ConfigItems.STAFF_ROD_QUARTZ, ConfigItems.STAFF_ROD_BONE, ConfigItems.STAFF_ROD_REED, ConfigItems.STAFF_ROD_SILVERWOOD, ConfigItems.STAFF_ROD_PRIMAL};
            allVanillaRods = new ArrayList(allRods.length);
            for (WandRod wandRod : allRods) {
                if (wandRod == null) continue;
                allVanillaRods.add(wandRod);
            }
        }
        return new ArrayList<WandRod>(allVanillaRods);
    }
}

