/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import dev.rndmorris.salisarcana.api.IResearchItemExtended;
import dev.rndmorris.salisarcana.common.commands.ArcanaCommandBase;
import dev.rndmorris.salisarcana.common.commands.PrerequisitesCommand;
import dev.rndmorris.salisarcana.config.SalisConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.FakePlayer;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.lib.network.PacketHandler;
import thaumcraft.common.lib.network.playerdata.PacketPlayerCompleteToServer;

public class ResearchHelper {
    public static boolean matchesTerm(ResearchItem research, String searchTerm) {
        searchTerm = searchTerm.toLowerCase();
        return research.key.toLowerCase().contains(searchTerm) || research.getName().toLowerCase().contains(searchTerm);
    }

    public static Collection<IChatComponent> printResearchToChat(Predicate<ResearchItem> filter) {
        ArrayList<IChatComponent> results = new ArrayList<IChatComponent>();
        for (Map.Entry entry : ResearchCategories.researchCategories.entrySet()) {
            ResearchCategoryList category = (ResearchCategoryList)entry.getValue();
            ChatComponentText researchMessage = new ChatComponentText("");
            Iterator research$ = category.research.values().iterator();
            boolean anyInCategory = false;
            while (research$.hasNext()) {
                ResearchItem research = (ResearchItem)research$.next();
                if (!filter.test(research)) continue;
                anyInCategory = true;
                IChatComponent item = ResearchHelper.formatResearch(research);
                researchMessage.func_150257_a(item);
                if (!research$.hasNext()) continue;
                researchMessage.func_150258_a(", ");
            }
            if (!anyInCategory) continue;
            results.add(ResearchHelper.categoryMessage((String)entry.getKey()));
            results.add((IChatComponent)researchMessage);
        }
        return results;
    }

    private static IChatComponent categoryMessage(String categoryKey) {
        ChatStyle style = new ChatStyle();
        style.func_150227_a(Boolean.valueOf(true));
        style.func_150238_a(EnumChatFormatting.BLUE);
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(categoryKey)));
        ChatComponentTranslation headerMessage = new ChatComponentTranslation("salisarcana:command.category_header", new Object[]{ResearchCategories.getCategoryName((String)categoryKey)});
        headerMessage.func_150255_a(style);
        return headerMessage;
    }

    public static void sendResearchError(EntityPlayer player, String researchKey, String translationKey) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!(player instanceof FakePlayer)) {
                ChatComponentText researchName;
                ResearchItem research = ResearchCategories.getResearch((String)researchKey);
                if (research instanceof IResearchItemExtended) {
                    IResearchItemExtended extended = (IResearchItemExtended)research;
                    researchName = new ChatComponentTranslation(extended.getNameTranslationKey(), new Object[0]);
                } else {
                    researchName = new ChatComponentText(research.getName());
                }
                ChatComponentTranslation message = new ChatComponentTranslation(translationKey, new Object[]{researchName, new ChatComponentTranslation("tc.research_category." + research.category, new Object[0])});
                message.func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED));
                playerMP.func_145747_a((IChatComponent)message);
            }
        }
    }

    public static IChatComponent formatResearch(ResearchItem research) {
        return ResearchHelper.formatResearch(research, EnumChatFormatting.DARK_PURPLE);
    }

    public static IChatComponent formatResearch(ResearchItem research, EnumChatFormatting formatting) {
        String string;
        if (research instanceof IResearchItemExtended) {
            IResearchItemExtended extended = (IResearchItemExtended)research;
            string = extended.getNameTranslationKey();
        } else {
            string = String.format("tc.research_name.%s", research.key);
        }
        String researchKeyName = string;
        ChatStyle style = new ChatStyle().func_150238_a(formatting).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(research.key)));
        return new ChatComponentText("[").func_150255_a(style).func_150257_a((IChatComponent)new ChatComponentTranslation(researchKeyName, new Object[0])).func_150258_a("]");
    }

    public static IChatComponent formatResearchClickCommand(ResearchItem research) {
        IChatComponent result = ResearchHelper.formatResearch(research);
        result.func_150256_b().func_150241_a(ResearchHelper.suggestResearchCommandOnClick(research));
        return result;
    }

    public static IChatComponent formatResearchClickCommand(ResearchItem research, EnumChatFormatting formatting) {
        IChatComponent result = ResearchHelper.formatResearch(research, formatting);
        result.func_150256_b().func_150241_a(ResearchHelper.suggestResearchCommandOnClick(research));
        return result;
    }

    public static ClickEvent suggestResearchCommandOnClick(ResearchItem research) {
        ArcanaCommandBase<?> arcanaCommandBase;
        if (SalisConfig.commands.prerequisites.isEnabled() && (arcanaCommandBase = SalisConfig.commands.prerequisites.getCommand()) instanceof PrerequisitesCommand) {
            PrerequisitesCommand command = (PrerequisitesCommand)arcanaCommandBase;
            return new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, String.format("/%s --research %s", command.func_71517_b(), research.key));
        }
        return null;
    }

    public static void completeResearchClient(EntityPlayer player, String research) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketPlayerCompleteToServer(research, player.func_70005_c_(), player.field_70170_p.field_73011_w.field_76574_g, 0));
    }
}

