/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.gconfig;

import io.github.cruciblemc.omniconfig.OmniconfigCore;
import io.github.cruciblemc.omniconfig.api.annotation.IAnnotationConfigRegistry;
import io.github.cruciblemc.omniconfig.api.core.IOmniconfig;
import io.github.cruciblemc.omniconfig.gconfig.AnnotationConfigReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AnnotationConfigCore
implements IAnnotationConfigRegistry {
    public static final AnnotationConfigCore INSTANCE = new AnnotationConfigCore();
    private final Map<Class<?>, IOmniconfig> annotationConfigMap = new HashMap();

    private AnnotationConfigCore() {
    }

    public void addAnnotationConfig(Class<?> configClass) {
        if (this.annotationConfigMap.containsKey(configClass)) {
            throw new IllegalArgumentException("Annotation config class " + configClass + "was already registered!");
        }
        OmniconfigCore.logger.info("Registering annotation config class: " + configClass);
        this.annotationConfigMap.put(configClass, new AnnotationConfigReader(configClass).read());
    }

    @Override
    public Collection<Class<?>> getRegisteredAnnotationConfigs() {
        return Collections.unmodifiableCollection(this.annotationConfigMap.keySet());
    }

    @Override
    public Optional<IOmniconfig> getAssociatedOmniconfig(Class<?> annotationConfigClass) {
        return Optional.ofNullable(this.annotationConfigMap.get(annotationConfigClass));
    }
}

