/*
 * Decompiled with CFR 0.152.
 */
package io.github.cruciblemc.omniconfig.api.lib;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class Either<A, B> {
    private final A a;
    private final B b;

    private Either(A a, B b) {
        this.a = a;
        this.b = b;
    }

    public boolean isFirst() {
        return this.a != null;
    }

    public boolean isSecond() {
        return this.b != null;
    }

    public boolean ifFirst(Consumer<A> consumer) {
        if (this.isFirst()) {
            consumer.accept(this.a);
        }
        return this.isFirst();
    }

    public boolean ifSecond(Consumer<B> consumer) {
        if (this.isSecond()) {
            consumer.accept(this.b);
        }
        return this.isSecond();
    }

    public void execute(Consumer<A> caseFirst, Consumer<B> caseSecond) {
        if (!this.ifFirst(caseFirst)) {
            caseSecond.accept(this.b);
        }
    }

    public A getFirst() throws NullPointerException {
        return (A)Preconditions.checkNotNull(this.a);
    }

    public B getSecond() throws NullPointerException {
        return (B)Preconditions.checkNotNull(this.b);
    }

    public static <A, B> Either<A, B> fromFirst(@NotNull A first) {
        return new Either<A, Object>(Objects.requireNonNull(first), null);
    }

    public static <A, B> Either<A, B> fromSecond(@NotNull B second) {
        return new Either<Object, B>(null, Objects.requireNonNull(second));
    }
}

