/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector;

import DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector.AssetDirector;
import DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector.SSLHacker;
import DelirusCrux.Netherlicious.repackage.makamys.mclib.ext.assetdirector.mc.MCUtil;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

public class AssetFetcher {
    static final String MANIFEST_ENDPOINT = System.getProperty("assetDirector.manifestEndpoint", "https://launchermeta.mojang.com/mc/game/version_manifest.json");
    static final String RESOURCES_ENDPOINT = System.getProperty("assetDirector.resourcesEndpoint", "https://resources.download.minecraft.net");
    static final String ASSET_INDEX_PATH = "assets/indexes/%s.json";
    static final String CLIENT_JAR_PATH = "versions/%s/%s.jar";
    static final String VERSION_INDEX_PATH = "versions/%s/%s.json";
    private static final int DOWNLOAD_TIMEOUT = Integer.parseInt(System.getProperty("assetDirector.downloadTimeout", "10000"));
    private static final int DOWNLOAD_ATTEMPTS = Integer.parseInt(System.getProperty("assetDirector.downloadAttempts", "3"));
    private static JsonObject manifest;
    public Map<String, VersionIndex> versionIndexes = new HashMap<String, VersionIndex>();
    public Map<String, AssetIndex> assetIndexes = new HashMap<String, AssetIndex>();
    private Map<String, File> fileMap = new HashMap<String, File>();
    private static final File NULL_FILE;
    public File assetsDir;
    public File adDir;

    public AssetFetcher(File assetsDir, File adDir) {
        this.assetsDir = assetsDir;
        this.adDir = adDir;
        if (!adDir.exists()) {
            adDir.mkdirs();
        }
    }

    public void init() {
        AssetDirector.LOGGER.info("Using directory " + this.adDir);
        Arrays.stream(this.adDir.listFiles((dir, name) -> name.endsWith(".part"))).forEach(f -> f.delete());
        SSLHacker.hack();
    }

    public void fetchAsset(String version, String asset) throws Exception {
        this.loadVersionDeps(version);
        VersionIndex vi = this.versionIndexes.get(version);
        AssetIndex assetIndex = this.assetIndexes.get(vi.assetsId);
        String hash = assetIndex.nameToHash.get(asset);
        if (hash != null) {
            this.downloadAsset(hash);
        }
    }

    public boolean needsFetchResource(String version, String asset) {
        return this.needsFetchAsset(version, asset, false);
    }

    public boolean needsFetchAsset(String version, String asset, boolean printErrors) {
        VersionIndex vi = this.versionIndexes.get(version);
        AssetIndex assetIndex = this.assetIndexes.get(vi.assetsId);
        String hash = assetIndex.nameToHash.get(asset);
        if (hash != null) {
            return !this.fileIsPresent(hash);
        }
        if (printErrors) {
            AssetDirector.LOGGER.error("Couldn't find asset " + asset + " inside " + version + " asset index");
        }
        return false;
    }

    public boolean fileIsPresent(String hash) {
        return this.getAssetFileForRead(hash) != NULL_FILE;
    }

    public void fetchForAllVersions(String asset) throws Exception {
        for (String v : this.assetIndexes.keySet()) {
            this.fetchAsset(v, asset);
        }
    }

    private void downloadAsset(String hash) throws IOException {
        String relPath = "/" + hash.substring(0, 2) + "/" + hash;
        File outFile = this.getAssetFileForWrite(hash);
        File outFileTmp = new File(this.adDir, outFile.getName() + ".part");
        for (int i = 0; i < DOWNLOAD_ATTEMPTS; ++i) {
            this.copyURLToFile(RESOURCES_ENDPOINT + relPath, outFileTmp);
            if (hash.equals(AssetFetcher.getSha1(outFileTmp))) {
                outFile.getParentFile().mkdirs();
                outFileTmp.renameTo(outFile);
                this.fileMap.put(hash, outFile);
                break;
            }
            AssetDirector.LOGGER.warn("Got invalid hash when downloading " + hash + ". Attempt " + (i + 1) + "/" + DOWNLOAD_ATTEMPTS);
        }
    }

    public void loadVersionDeps(String version) throws Exception {
        if (this.versionIndexes.containsKey(version)) {
            return;
        }
        File indexJson = new File(this.adDir, String.format(VERSION_INDEX_PATH, version, version));
        if (!indexJson.exists()) {
            this.downloadVersionIndex(version, indexJson);
        }
        VersionIndex vi = new VersionIndex(this.loadJson(indexJson, JsonObject.class));
        this.versionIndexes.put(version, vi);
        if (!this.assetIndexes.containsKey(vi.assetsId)) {
            File assetIndex = new File(this.adDir, String.format(ASSET_INDEX_PATH, vi.assetsId));
            if (!assetIndex.exists()) {
                String url = vi.json.get("assetIndex").getAsJsonObject().get("url").getAsString();
                this.copyURLToFile(url, assetIndex);
            }
            this.assetIndexes.put(vi.assetsId, new AssetIndex(this.loadJson(assetIndex, JsonObject.class)));
        }
    }

    public void fetchJar(String version) throws IOException {
        this.versionIndexes.get(version).fetchJar(version);
    }

    public void loadJar(String version) throws IOException {
        this.versionIndexes.get(version).loadJar(version);
    }

    public boolean needsFetchJar(String version) {
        return !new File(this.adDir, String.format(CLIENT_JAR_PATH, version, version)).exists();
    }

    private void downloadVersionIndex(String version, File dest) throws Exception {
        if (manifest == null) {
            manifest = this.downloadJson(MANIFEST_ENDPOINT, JsonObject.class);
        }
        for (JsonElement verElem : manifest.get("versions").getAsJsonArray()) {
            ManifestVersionJSON ver = (ManifestVersionJSON)new Gson().fromJson(verElem, ManifestVersionJSON.class);
            if (!ver.id.equals(version)) continue;
            this.copyURLToFile(ver.url, dest);
            return;
        }
        AssetDirector.LOGGER.error("Game version " + version + " could not be found in manifest json.");
    }

    private void copyURLToFile(String source, File destination) throws IOException {
        try {
            URL url = new URL(source);
            AssetDirector.LOGGER.trace("Downloading " + url + " to " + destination);
            SSLHacker.enable();
            FileUtils.copyURLToFile((URL)url, (File)destination, (int)DOWNLOAD_TIMEOUT, (int)DOWNLOAD_TIMEOUT);
        }
        catch (IOException e) {
            AssetDirector.LOGGER.error("Failed to download " + source + " to " + destination);
            throw e;
        }
        finally {
            SSLHacker.disable();
        }
    }

    private <T> T downloadJson(String urlStr, Class<T> classOfT) throws Exception {
        try {
            URL url = new URL(urlStr);
            AssetDirector.LOGGER.trace("Downloading JSON at " + url);
            SSLHacker.enable();
            T t = this.loadJson(url.openStream(), classOfT);
            return t;
        }
        catch (Exception e) {
            AssetDirector.LOGGER.error("Failed to download JSON at " + urlStr);
            throw e;
        }
        finally {
            SSLHacker.disable();
        }
    }

    private <T> T loadJson(File file, Class<T> classOfT) throws Exception {
        return this.loadJson(new FileInputStream(file), classOfT);
    }

    private <T> T loadJson(InputStream stream, Class<T> classOfT) throws Exception {
        return (T)new Gson().fromJson((Reader)new InputStreamReader(new BufferedInputStream(stream)), classOfT);
    }

    public File getAssetFileForRead(String hash) {
        File file = this.fileMap.get(hash);
        if (file == null) {
            File fileUpper = new File(this.adDir, "assets/objects/" + hash.substring(0, 2) + "/" + hash);
            File fileLower = new File(this.assetsDir, "objects/" + hash.substring(0, 2) + "/" + hash);
            file = fileUpper.exists() ? fileUpper : (fileLower.exists() ? fileLower : NULL_FILE);
            this.fileMap.put(hash, file);
        }
        return file;
    }

    public File getAssetFileForWrite(String hash) {
        return new File(this.adDir, "assets/objects/" + hash.substring(0, 2) + "/" + hash);
    }

    public InputStream getAssetInputStream(String hash) throws IOException {
        return new BufferedInputStream(new FileInputStream(this.getAssetFileForRead(hash)));
    }

    public InputStream getAssetInputStream(String version, String path) throws IOException {
        return this.getAssetInputStream(this.assetIndexes.get((Object)this.versionToAssetsId((String)version)).nameToHash.get(path));
    }

    public boolean hashExists(String hash) {
        File file = this.fileMap.get(hash);
        return file != null && file != NULL_FILE;
    }

    static String getSha1(File file) {
        try {
            return Files.hash((File)file, (HashFunction)Hashing.sha1()).toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String versionToAssetsId(String version) {
        try {
            this.loadVersionDeps(version);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.versionIndexes.get((Object)version).assetsId;
    }

    static {
        NULL_FILE = new File("");
    }

    public class VersionIndex {
        public JsonObject json;
        public String assetsId;
        JarFile jar;
        public Set<String> jarContents;
        public MCUtil.Version version;

        public VersionIndex(JsonObject json) {
            this.json = json;
            this.assetsId = json.get("assets").getAsString();
            this.version = new MCUtil.Version(json.get("id").getAsString());
        }

        public void fetchJar(String version) throws IOException {
            if (this.jar != null) {
                return;
            }
            File clientJar = new File(AssetFetcher.this.adDir, String.format(AssetFetcher.CLIENT_JAR_PATH, version, version));
            String url = this.json.get("downloads").getAsJsonObject().get("client").getAsJsonObject().get("url").getAsString();
            AssetFetcher.this.copyURLToFile(url, clientJar);
        }

        public void loadJar(String version) throws IOException {
            if (this.jar != null) {
                return;
            }
            File clientJar = new File(AssetFetcher.this.adDir, String.format(AssetFetcher.CLIENT_JAR_PATH, version, version));
            this.jar = new JarFile(clientJar);
            this.jarContents = this.jar.stream().map(e -> e.getName()).collect(Collectors.toSet());
        }

        public boolean jarContainsFile(String path) {
            return this.jarContents != null && this.jarContents.contains(path);
        }

        public InputStream getJarFileStream(String path) throws IOException {
            return this.jar.getInputStream(this.jar.getEntry(path));
        }
    }

    public static class AssetIndex {
        public JsonObject json;
        public Map<String, String> nameToHash = new HashMap<String, String>();

        public AssetIndex(JsonObject json) {
            this.json = json;
            json.get("objects").getAsJsonObject().entrySet().forEach(e -> {
                String name = (String)e.getKey();
                String hash = ((JsonElement)e.getValue()).getAsJsonObject().get("hash").getAsString();
                this.nameToHash.put(name, hash);
            });
        }
    }

    private static class ManifestVersionJSON {
        String id;
        String url;

        private ManifestVersionJSON() {
        }
    }
}

