/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.World.Worldgen;

import DelirusCrux.Netherlicious.Biomes.Utility.NetherBiomeManager;
import DelirusCrux.Netherlicious.Utility.Configuration.StructureConfiguration;
import DelirusCrux.Netherlicious.Utility.Configuration.WorldgenConfiguration;
import DelirusCrux.Netherlicious.World.Structures.Portals.Portal1;
import DelirusCrux.Netherlicious.World.Structures.Portals.Portal2;
import DelirusCrux.Netherlicious.World.Structures.Portals.Portal3;
import DelirusCrux.Netherlicious.World.Structures.Portals.Portal4;
import DelirusCrux.Netherlicious.World.Structures.Portals.Portal5;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class NetherPortalGen
implements IWorldGenerator {
    private static final NetherPortalGen INSTANCE = new NetherPortalGen();

    public static void register() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)INSTANCE);
        GameRegistry.registerWorldGenerator((IWorldGenerator)INSTANCE, (int)0);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(chunkX, chunkZ);
        if (StructureConfiguration.NetherPortals) {
            if (WorldgenConfiguration.BigNether) {
                if (world.field_73011_w.field_76574_g == -1 && biome != NetherBiomeManager.AbyssalShadowland) {
                    this.generatePortalBigNether(world, random, chunkX * 16, chunkZ * 16);
                }
            } else if (world.field_73011_w.field_76574_g == -1 && biome != NetherBiomeManager.AbyssalShadowland) {
                this.generatePortal(world, random, chunkX * 16, chunkZ * 16);
            }
        }
    }

    public void generatePortal(World world, Random random, int x, int z) {
        if (NetherPortalGen.canSpawnAt(world, x, z)) {
            int randPosX = x + random.nextInt(16) + 16;
            int randPosY = 30 + random.nextInt(80);
            int randPosZ = z + random.nextInt(16) + 16;
            int varPort = random.nextInt(5);
            if (!world.func_147437_c(randPosX, randPosY, randPosZ) && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151584_j && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151572_C && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151585_k && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150357_h && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150353_l && world.func_147437_c(randPosX, randPosY + 1, randPosZ) || !world.func_147437_c(randPosX, randPosY, randPosZ) && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151584_j && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151572_C && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151585_k && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150357_h && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150353_l && world.func_147439_a(randPosX, randPosY + 1, randPosZ).func_149688_o() == Material.field_151585_k) {
                if (varPort == 0) {
                    new Portal1().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 1) {
                    new Portal2().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 2) {
                    new Portal3().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 3) {
                    new Portal4().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else {
                    new Portal5().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                }
            }
        }
    }

    public void generatePortalBigNether(World world, Random random, int x, int z) {
        if (NetherPortalGen.canSpawnAt(world, x, z)) {
            int randPosX = x + random.nextInt(16) + 16;
            int randPosY = 30 + random.nextInt(200);
            int randPosZ = z + random.nextInt(16) + 16;
            int varPort = random.nextInt(5);
            if (!world.func_147437_c(randPosX, randPosY, randPosZ) && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151584_j && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151572_C && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151585_k && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150357_h && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151587_i && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151586_h && world.func_147437_c(randPosX, randPosY + 1, randPosZ) || !world.func_147437_c(randPosX, randPosY, randPosZ) && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151584_j && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151572_C && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151585_k && world.func_147439_a(randPosX, randPosY, randPosZ) != Blocks.field_150357_h && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151587_i && world.func_147439_a(randPosX, randPosY, randPosZ).func_149688_o() != Material.field_151586_h && world.func_147439_a(randPosX, randPosY + 1, randPosZ).func_149688_o() == Material.field_151585_k) {
                if (varPort == 0) {
                    new Portal1().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 1) {
                    new Portal2().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 2) {
                    new Portal3().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else if (varPort == 3) {
                    new Portal4().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                } else {
                    new Portal5().func_76484_a(world, random, randPosX, randPosY, randPosZ);
                }
            }
        }
    }

    public static boolean canSpawnAt(World worldObj, int chunkX, int chunkZ) {
        int spacing = 32;
        int separation = 20;
        int xx = chunkX;
        int zz = chunkZ;
        if (chunkX < 0) {
            chunkX -= spacing - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= spacing - 1;
        }
        int i1 = chunkX / spacing;
        int j1 = chunkZ / spacing;
        Random random = worldObj.func_72843_D(i1, j1, 10387313);
        i1 *= spacing;
        j1 *= spacing;
        i1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2;
        j1 += (random.nextInt(spacing - separation) + random.nextInt(spacing - separation)) / 2;
        return true;
    }
}

