/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.World.Worldgen;

import DelirusCrux.Netherlicious.Biomes.Utility.NetherBiomeManager;
import DelirusCrux.Netherlicious.Netherlicious;
import DelirusCrux.Netherlicious.Utility.Configuration.CropConfiguration;
import DelirusCrux.Netherlicious.World.Features.Plants.Crops.AbyssalOatCropPatch;
import DelirusCrux.Netherlicious.World.Features.Plants.Crops.CropGhastlyGourdPatch;
import DelirusCrux.Netherlicious.World.Features.Plants.Crops.CropInfernalReedGen;
import DelirusCrux.Netherlicious.World.Features.Plants.Crops.DevilishMaizeCropPatch;
import DelirusCrux.Netherlicious.World.Features.Plants.Crops.HellderberryCropPatch;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class CropGeneration
implements IWorldGenerator {
    private static final CropGeneration INSTANCE = new CropGeneration();
    private final List<CropGhastlyGourdPatch> CropGen1 = new LinkedList<CropGhastlyGourdPatch>();
    private final List<DevilishMaizeCropPatch> CropGen2 = new LinkedList<DevilishMaizeCropPatch>();
    private final List<CropInfernalReedGen> CropGen3 = new LinkedList<CropInfernalReedGen>();
    private final List<HellderberryCropPatch> CropGen4 = new LinkedList<HellderberryCropPatch>();
    private final List<AbyssalOatCropPatch> CropGen5 = new LinkedList<AbyssalOatCropPatch>();

    public CropGeneration() {
        this.CropGen1.add(new CropGhastlyGourdPatch());
        this.CropGen2.add(new DevilishMaizeCropPatch());
        this.CropGen3.add(new CropInfernalReedGen());
        this.CropGen4.add(new HellderberryCropPatch());
        this.CropGen5.add(new AbyssalOatCropPatch());
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase biome = world.func_72959_q().func_76935_a(chunkX, chunkZ);
        if (world.field_73011_w.field_76574_g == -1) {
            int i;
            if (CropConfiguration.GhastlyGourd && (biome == NetherBiomeManager.FoxfireSwamp || biome == NetherBiomeManager.CrimsonForest || biome == NetherBiomeManager.WarpedForest || biome == BiomeGenBase.func_150568_d((int)Netherlicious.Undergarden))) {
                for (i = 0; i < 2; ++i) {
                    this.generateGhastlyGourdForChunk(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            if (CropConfiguration.DevilishMaizePatch && (biome == NetherBiomeManager.FoxfireSwamp || biome == NetherBiomeManager.CrimsonForest || biome == NetherBiomeManager.WarpedForest || biome == BiomeGenBase.func_150568_d((int)Netherlicious.Undergarden))) {
                for (i = 0; i < 2; ++i) {
                    this.generateDevilishMaizePatchForChunk(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            if (CropConfiguration.InfernalReed) {
                for (i = 0; i < 2; ++i) {
                    this.generateInfernalReedForChunk(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            if (CropConfiguration.HellderberryBush && (biome == NetherBiomeManager.FoxfireSwamp || biome == NetherBiomeManager.CrimsonForest || biome == NetherBiomeManager.WarpedForest || biome == BiomeGenBase.func_150568_d((int)Netherlicious.Undergarden))) {
                for (i = 0; i < 2; ++i) {
                    this.generateHellderberryBushForChunk(world, random, chunkX * 16, chunkZ * 16);
                }
            }
            if (CropConfiguration.AbyssalOatPatch && (biome == NetherBiomeManager.FoxfireSwamp || biome == NetherBiomeManager.CrimsonForest || biome == NetherBiomeManager.WarpedForest || biome == BiomeGenBase.func_150568_d((int)Netherlicious.Undergarden))) {
                for (i = 0; i < 2; ++i) {
                    this.generateAbyssalOatPatchForChunk(world, random, chunkX * 16, chunkZ * 16);
                }
            }
        }
    }

    public void generateGhastlyGourdForChunk(World world, Random random, int x, int z) {
        int randPosX = x + random.nextInt(16);
        int randPosY = 30 + random.nextInt(90);
        int randPosZ = z + random.nextInt(16);
        this.CropGen1.get(0).func_76484_a(world, random, randPosX, randPosY, randPosZ);
    }

    public void generateDevilishMaizePatchForChunk(World world, Random random, int x, int z) {
        int randPosX = x + random.nextInt(16);
        int randPosY = 30 + random.nextInt(90);
        int randPosZ = z + random.nextInt(16);
        this.CropGen2.get(0).func_76484_a(world, random, randPosX, randPosY, randPosZ);
    }

    public void generateInfernalReedForChunk(World world, Random random, int x, int z) {
        int randPosX = x + random.nextInt(16);
        int randPosY = 30 + random.nextInt(90);
        int randPosZ = z + random.nextInt(16);
        this.CropGen3.get(0).func_76484_a(world, random, randPosX, randPosY, randPosZ);
    }

    public void generateHellderberryBushForChunk(World world, Random random, int x, int z) {
        int randPosX = x + random.nextInt(16);
        int randPosY = 30 + random.nextInt(90);
        int randPosZ = z + random.nextInt(16);
        this.CropGen4.get(0).func_76484_a(world, random, randPosX, randPosY, randPosZ);
    }

    public void generateAbyssalOatPatchForChunk(World world, Random random, int x, int z) {
        int randPosX = x + random.nextInt(16);
        int randPosY = 30 + random.nextInt(90);
        int randPosZ = z + random.nextInt(16);
        this.CropGen5.get(0).func_76484_a(world, random, randPosX, randPosY, randPosZ);
    }
}

