/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.Common.Items;

import DelirusCrux.Netherlicious.Common.BlockItemUtility.ModCreativeTab;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Facing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEntitySpawnEgg
extends ItemMonsterPlacer {
    private static final Map<Short, EggData> eggTypes = new LinkedHashMap<Short, EggData>();

    public static void registerSpawnEgg(Class<? extends EntityLiving> entity, String entityName, int id, int primaryColor, int secondaryColor) {
        eggTypes.put((short)id, new EggData(id, entityName, entity, primaryColor, secondaryColor));
    }

    private static EggData getEggData(ItemStack itemstack) {
        return eggTypes.get((short)itemstack.func_77960_j());
    }

    public ItemEntitySpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(ModCreativeTab.tabNetherliciousItems);
        this.func_111206_d("spawn_egg");
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)new DispenserBehaviourSpawnEgg());
    }

    public String func_77653_i(ItemStack itemstack) {
        EggData egg = ItemEntitySpawnEgg.getEggData(itemstack);
        String s = ("" + StatCollector.func_74838_a((String)(Items.field_151063_bx.func_77658_a() + ".name"))).trim();
        String mob = egg.entityName;
        if (egg != null) {
            s = s + " " + StatCollector.func_74838_a((String)("entity.netherlicious." + egg.entityName + ".name"));
        }
        return s;
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        x += Facing.field_71586_b[side];
        y += Facing.field_71587_c[side];
        z += Facing.field_71585_d[side];
        EggData egg = ItemEntitySpawnEgg.getEggData(itemstack);
        if (egg != null) {
            egg.spawnMob(world, (double)x + 0.5, (double)y + (side == 1 && block != null && block.func_149645_b() == 11 ? 0.5 : 0.0), (double)z + 0.5, itemstack);
            if (!player.field_71075_bZ.field_75098_d) {
                --itemstack.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return itemstack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            EggData egg;
            int x = movingobjectposition.field_72311_b;
            int y = movingobjectposition.field_72312_c;
            int z = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, x, y, z) || !player.func_82247_a(x, y, z, movingobjectposition.field_72310_e, itemstack)) {
                return itemstack;
            }
            if (world.func_147439_a(x, y, z).func_149688_o() == Material.field_151586_h && (egg = ItemEntitySpawnEgg.getEggData(itemstack)) != null) {
                egg.spawnMob(world, x, y, z, itemstack);
                if (!player.field_71075_bZ.field_75098_d) {
                    --itemstack.field_77994_a;
                }
            }
        }
        return itemstack;
    }

    public static EntityLiving getEntity(World world, double x, double y, double z, ItemStack is) {
        EggData egg = ItemEntitySpawnEgg.getEggData(is);
        return egg.spawnMob(world, x, y, z, is);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack is, int pass) {
        EggData egg = ItemEntitySpawnEgg.getEggData(is);
        return egg != null ? (pass == 0 ? egg.primaryColor : egg.secondaryColor) : 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs tab, List list) {
        for (Short s : eggTypes.keySet()) {
            list.add(new ItemStack(id, 1, (int)s.shortValue()));
        }
    }

    static class EggData {
        private final short id;
        String entityName;
        private final Class<? extends EntityLiving> entityClass;
        int primaryColor;
        int secondaryColor;

        EggData(int id, String entityName, Class<? extends EntityLiving> entityClass, int primaryColor, int secondaryColor) {
            this.id = (short)id;
            this.entityName = entityName;
            this.entityClass = entityClass;
            this.primaryColor = primaryColor;
            this.secondaryColor = secondaryColor;
        }

        public EntityLiving spawnMob(World world, double x, double y, double z, ItemStack itemstack) {
            EntityLiving entity = null;
            try {
                entity = this.entityClass.getConstructor(World.class).newInstance(world);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            if (entity == null) {
                return null;
            }
            entity.func_70012_b(x, y, z, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            entity.func_110161_a((IEntityLivingData)null);
            world.func_72838_d((Entity)entity);
            entity.func_70642_aH();
            if (itemstack.func_82837_s()) {
                entity.func_94058_c(itemstack.func_82833_r());
            }
            return entity;
        }

        public int hashCode() {
            return this.id;
        }
    }

    static class DispenserBehaviourSpawnEgg
    extends BehaviorDefaultDispenseItem {
        DispenserBehaviourSpawnEgg() {
        }

        public ItemStack func_82487_b(IBlockSource block, ItemStack stack) {
            EnumFacing enumfacing = BlockDispenser.func_149937_b((int)block.func_82620_h());
            double d0 = block.func_82615_a() + (double)enumfacing.func_82601_c();
            double d1 = (float)block.func_82622_e() + 0.2f;
            double d2 = block.func_82616_c() + (double)enumfacing.func_82599_e();
            World world = block.func_82618_k();
            EntityLiving entity = ItemEntitySpawnEgg.getEntity(world, d0, d1, d2, stack);
            if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                entity.func_94058_c(stack.func_82833_r());
            }
            stack.func_77979_a(1);
            return stack;
        }
    }
}

