/*
 * Decompiled with CFR 0.152.
 */
package DelirusCrux.Netherlicious.Client.Render.Entity.Passive;

import DelirusCrux.Netherlicious.Client.Render.Entity.Model.FoxModel;
import DelirusCrux.Netherlicious.Common.Entities.Passive.EntityFlamingFox;
import DelirusCrux.Netherlicious.Utility.NewMathUtil;
import net.minecraft.block.Block;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class FlamingFoxRender
extends RenderLiving {
    private static final ResourceLocation texture = new ResourceLocation("textures/entity/fox/fox.png");
    private static final ResourceLocation sleepingTexture = new ResourceLocation("textures/entity/fox/fox_sleep.png");
    private static final ResourceLocation snowTexture = new ResourceLocation("textures/entity/fox/snow_fox.png");
    private static final ResourceLocation sleepingSnowTexture = new ResourceLocation("textures/entity/fox/snow_fox_sleep.png");

    public FlamingFoxRender(ModelBase p_i1252_1_, float p_i1252_2_) {
        super(p_i1252_1_, p_i1252_2_);
    }

    protected ResourceLocation getEntityTexture(EntityFlamingFox foxEntity) {
        if (foxEntity.getFoxType() == EntityFlamingFox.Type.RED) {
            return foxEntity.isPlayerSleeping() ? sleepingTexture : texture;
        }
        return foxEntity.isPlayerSleeping() ? sleepingSnowTexture : snowTexture;
    }

    protected ResourceLocation func_110775_a(Entity p_110775_1_) {
        return this.getEntityTexture((EntityFlamingFox)p_110775_1_);
    }

    protected void rotateCorpse(EntityFlamingFox foxEntity, float animationProgress, float bodyYaw, float tickDelta) {
        super.func_77043_a((EntityLivingBase)foxEntity, animationProgress, bodyYaw, tickDelta);
        if (foxEntity.isChasing() || foxEntity.isWalking()) {
            float i = -NewMathUtil.lerp(tickDelta, foxEntity.prevRotationPitch, foxEntity.rotationPitch);
            GL11.glRotatef((float)i, (float)1.0f, (float)0.0f, (float)0.0f);
        }
    }

    protected void func_77043_a(EntityLivingBase entity, float animationProgress, float bodyYaw, float tickDelta) {
        this.rotateCorpse((EntityFlamingFox)entity, animationProgress, bodyYaw, tickDelta);
    }

    protected void func_77029_c(EntityLivingBase p_77029_1_, float p_77029_2_) {
        this.renderEquippedItems((EntityFlamingFox)p_77029_1_, p_77029_2_);
    }

    protected void renderEquippedItems(EntityFlamingFox p_77029_1_, float p_77029_2_) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        super.func_77029_c((EntityLivingBase)p_77029_1_, p_77029_2_);
        ItemStack itemstack = p_77029_1_.getHeldItem();
        if (itemstack != null) {
            float f1;
            GL11.glPushMatrix();
            if (this.field_77045_g.field_78091_s) {
                GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                GL11.glTranslatef((float)0.0f, (float)0.5f, (float)0.209375f);
            }
            FoxModel mf = (FoxModel)this.field_77045_g;
            GL11.glTranslatef((float)(mf.head.field_78800_c / 16.0f), (float)(mf.head.field_78797_d / 16.0f), (float)(mf.head.field_78798_e / 16.0f));
            GL11.glRotatef((float)((float)Math.toDegrees(mf.head.field_78796_g)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)Math.toDegrees(mf.head.field_78795_f)), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)0.3f, (float)-0.35f);
            if (itemstack.func_77973_b() instanceof ItemBlock && RenderBlocks.func_147739_a((int)Block.func_149634_a((Item)itemstack.func_77973_b()).func_149645_b())) {
                f1 = 0.5f;
                GL11.glTranslatef((float)0.0f, (float)0.1875f, (float)-0.3125f);
                GL11.glScalef((float)(f1 *= 0.45f), (float)(-f1), (float)f1);
                GL11.glTranslatef((float)0.3f, (float)1.0f, (float)1.5f);
            } else {
                f1 = 0.335f;
                GL11.glScalef((float)f1, (float)f1, (float)f1);
                GL11.glTranslatef((float)0.72f, (float)-0.15f, (float)-0.45f);
                GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-335.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)-50.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (itemstack.func_77973_b().func_77623_v()) {
                for (int k = 0; k < itemstack.func_77973_b().getRenderPasses(itemstack.func_77960_j()); ++k) {
                    int i = itemstack.func_77973_b().func_82790_a(itemstack, k);
                    float f12 = (float)(i >> 16 & 0xFF) / 255.0f;
                    float f3 = (float)(i >> 8 & 0xFF) / 255.0f;
                    float f4 = (float)(i & 0xFF) / 255.0f;
                    GL11.glColor4f((float)f12, (float)f3, (float)f4, (float)1.0f);
                    this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)p_77029_1_, itemstack, k);
                }
            } else {
                int k = itemstack.func_77973_b().func_82790_a(itemstack, 0);
                float f11 = (float)(k >> 16 & 0xFF) / 255.0f;
                float f12 = (float)(k >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(k & 0xFF) / 255.0f;
                GL11.glColor4f((float)f11, (float)f12, (float)f3, (float)1.0f);
                this.field_76990_c.field_78721_f.func_78443_a((EntityLivingBase)p_77029_1_, itemstack, 0);
            }
            GL11.glPopMatrix();
        }
    }
}

